package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticatorMethodConstraint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Defines the authenticators permitted for the initial authentication step of password recovery
 */
@ApiModel(description = "Defines the authenticators permitted for the initial authentication step of password recovery")
@JsonPropertyOrder({ SsprPrimaryRequirement.JSON_PROPERTY_METHOD_CONSTRAINTS,
        SsprPrimaryRequirement.JSON_PROPERTY_METHODS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SsprPrimaryRequirement implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_METHOD_CONSTRAINTS = "methodConstraints";
    private List<AuthenticatorMethodConstraint> methodConstraints = null;

    /**
     * Gets or Sets methods
     */
    public enum MethodsEnum {
        PUSH(String.valueOf("push")),

        SMS(String.valueOf("sms")),

        VOICE(String.valueOf("voice")),

        EMAIL(String.valueOf("email")),

        OTP(String.valueOf("otp")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        MethodsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static MethodsEnum fromValue(String value) {
            for (MethodsEnum b : MethodsEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_METHODS = "methods";
    private List<MethodsEnum> methods = null;

    public SsprPrimaryRequirement() {
    }

    public SsprPrimaryRequirement methodConstraints(List<AuthenticatorMethodConstraint> methodConstraints) {

        this.methodConstraints = methodConstraints;
        return this;
    }

    public SsprPrimaryRequirement addmethodConstraintsItem(AuthenticatorMethodConstraint methodConstraintsItem) {
        if (this.methodConstraints == null) {
            this.methodConstraints = new ArrayList<>();
        }
        this.methodConstraints.add(methodConstraintsItem);
        return this;
    }

    /**
     * Constraints on the values specified in the &#x60;methods&#x60; array. Specifying a constraint limits methods to
     * specific authenticator(s). Currently, Google OTP is the only accepted constraint.
     *
     * @return methodConstraints
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Constraints on the values specified in the `methods` array. Specifying a constraint limits methods to specific authenticator(s). Currently, Google OTP is the only accepted constraint.")
    @JsonProperty(JSON_PROPERTY_METHOD_CONSTRAINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<AuthenticatorMethodConstraint> getMethodConstraints() {
        return methodConstraints;
    }

    @JsonProperty(JSON_PROPERTY_METHOD_CONSTRAINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMethodConstraints(List<AuthenticatorMethodConstraint> methodConstraints) {
        this.methodConstraints = methodConstraints;
    }

    public SsprPrimaryRequirement methods(List<MethodsEnum> methods) {

        this.methods = methods;
        return this;
    }

    public SsprPrimaryRequirement addmethodsItem(MethodsEnum methodsItem) {
        if (this.methods == null) {
            this.methods = new ArrayList<>();
        }
        this.methods.add(methodsItem);
        return this;
    }

    /**
     * Authenticator methods allowed for the initial authentication step of password recovery. Method &#x60;otp&#x60;
     * requires a constraint limiting it to a Google authenticator.
     *
     * @return methods
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Authenticator methods allowed for the initial authentication step of password recovery. Method `otp` requires a constraint limiting it to a Google authenticator.")
    @JsonProperty(JSON_PROPERTY_METHODS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<MethodsEnum> getMethods() {
        return methods;
    }

    @JsonProperty(JSON_PROPERTY_METHODS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMethods(List<MethodsEnum> methods) {
        this.methods = methods;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SsprPrimaryRequirement ssprPrimaryRequirement = (SsprPrimaryRequirement) o;
        return Objects.equals(this.methodConstraints, ssprPrimaryRequirement.methodConstraints)
                && Objects.equals(this.methods, ssprPrimaryRequirement.methods);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(methodConstraints, methods);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SsprPrimaryRequirement {\n");
        sb.append("    methodConstraints: ").append(toIndentedString(methodConstraints)).append("\n");
        sb.append("    methods: ").append(toIndentedString(methods)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
