package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.Group;
import com.okta.sdk.resource.model.StandardRoleEmbeddedTargetsCatalog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Targets configured for the Role Assignment
 */
@ApiModel(description = "Targets configured for the Role Assignment")
@JsonPropertyOrder({ StandardRoleEmbeddedTargets.JSON_PROPERTY_GROUPS,
        StandardRoleEmbeddedTargets.JSON_PROPERTY_CATALOG })
@JsonTypeName("StandardRole__embedded_targets")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class StandardRoleEmbeddedTargets implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_GROUPS = "groups";
    private List<Group> groups = null;

    public static final String JSON_PROPERTY_CATALOG = "catalog";
    private StandardRoleEmbeddedTargetsCatalog catalog;

    public StandardRoleEmbeddedTargets() {
    }

    public StandardRoleEmbeddedTargets groups(List<Group> groups) {

        this.groups = groups;
        return this;
    }

    public StandardRoleEmbeddedTargets addgroupsItem(Group groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    /**
     * Group targets
     *
     * @return groups
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Group targets")
    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<Group> getGroups() {
        return groups;
    }

    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    public StandardRoleEmbeddedTargets catalog(StandardRoleEmbeddedTargetsCatalog catalog) {

        this.catalog = catalog;
        return this;
    }

    /**
     * Get catalog
     *
     * @return catalog
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CATALOG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public StandardRoleEmbeddedTargetsCatalog getCatalog() {
        return catalog;
    }

    @JsonProperty(JSON_PROPERTY_CATALOG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCatalog(StandardRoleEmbeddedTargetsCatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StandardRoleEmbeddedTargets standardRoleEmbeddedTargets = (StandardRoleEmbeddedTargets) o;
        return Objects.equals(this.groups, standardRoleEmbeddedTargets.groups)
                && Objects.equals(this.catalog, standardRoleEmbeddedTargets.catalog);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(groups, catalog);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StandardRoleEmbeddedTargets {\n");
        sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
        sb.append("    catalog: ").append(toIndentedString(catalog)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
