package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.TelephonyRequestData;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * TelephonyRequest
 */
@JsonPropertyOrder({ TelephonyRequest.JSON_PROPERTY_DATA, TelephonyRequest.JSON_PROPERTY_EVENT_TYPE,
        TelephonyRequest.JSON_PROPERTY_REQUEST_TYPE, TelephonyRequest.JSON_PROPERTY_SOURCE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class TelephonyRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DATA = "data";
    private TelephonyRequestData data;

    public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
    private String eventType;

    public static final String JSON_PROPERTY_REQUEST_TYPE = "requestType";
    private String requestType;

    public static final String JSON_PROPERTY_SOURCE = "source";
    private String source;

    public TelephonyRequest() {
    }

    public TelephonyRequest data(TelephonyRequestData data) {

        this.data = data;
        return this;
    }

    /**
     * Get data
     *
     * @return data
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TelephonyRequestData getData() {
        return data;
    }

    @JsonProperty(JSON_PROPERTY_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setData(TelephonyRequestData data) {
        this.data = data;
    }

    public TelephonyRequest eventType(String eventType) {

        this.eventType = eventType;
        return this;
    }

    /**
     * The type of inline hook. The Telephony inline hook type is &#x60;com.okta.telephony.provider&#x60;.
     *
     * @return eventType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The type of inline hook. The Telephony inline hook type is `com.okta.telephony.provider`.")
    @JsonProperty(JSON_PROPERTY_EVENT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getEventType() {
        return eventType;
    }

    @JsonProperty(JSON_PROPERTY_EVENT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public TelephonyRequest requestType(String requestType) {

        this.requestType = requestType;
        return this;
    }

    /**
     * The type of inline hook request. For example, &#x60;com.okta.user.telephony.pre-enrollment&#x60;.
     *
     * @return requestType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The type of inline hook request. For example, `com.okta.user.telephony.pre-enrollment`.")
    @JsonProperty(JSON_PROPERTY_REQUEST_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRequestType() {
        return requestType;
    }

    @JsonProperty(JSON_PROPERTY_REQUEST_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public TelephonyRequest source(String source) {

        this.source = source;
        return this;
    }

    /**
     * The ID and URL of the Telephony inline hook
     *
     * @return source
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The ID and URL of the Telephony inline hook")
    @JsonProperty(JSON_PROPERTY_SOURCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSource() {
        return source;
    }

    @JsonProperty(JSON_PROPERTY_SOURCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TelephonyRequest telephonyRequest = (TelephonyRequest) o;
        return Objects.equals(this.data, telephonyRequest.data)
                && Objects.equals(this.eventType, telephonyRequest.eventType)
                && Objects.equals(this.requestType, telephonyRequest.requestType)
                && Objects.equals(this.source, telephonyRequest.source);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(data, eventType, requestType, source);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelephonyRequest {\n");
        sb.append("    data: ").append(toIndentedString(data)).append("\n");
        sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
        sb.append("    requestType: ").append(toIndentedString(requestType)).append("\n");
        sb.append("    source: ").append(toIndentedString(source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
