package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.TokenPayLoadData;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * TokenRequest
 */
@JsonPropertyOrder({ TokenRequest.JSON_PROPERTY_CLOUD_EVENT_VERSION, TokenRequest.JSON_PROPERTY_CONTENT_TYPE,
        TokenRequest.JSON_PROPERTY_EVENT_ID, TokenRequest.JSON_PROPERTY_EVENT_TIME,
        TokenRequest.JSON_PROPERTY_EVENT_TYPE_VERSION, TokenRequest.JSON_PROPERTY_DATA })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class TokenRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CLOUD_EVENT_VERSION = "cloudEventVersion";
    private String cloudEventVersion;

    public static final String JSON_PROPERTY_CONTENT_TYPE = "contentType";
    private String contentType;

    public static final String JSON_PROPERTY_EVENT_ID = "eventId";
    private String eventId;

    public static final String JSON_PROPERTY_EVENT_TIME = "eventTime";
    private String eventTime;

    public static final String JSON_PROPERTY_EVENT_TYPE_VERSION = "eventTypeVersion";
    private String eventTypeVersion;

    public static final String JSON_PROPERTY_DATA = "data";
    private TokenPayLoadData data;

    public TokenRequest() {
    }

    public TokenRequest cloudEventVersion(String cloudEventVersion) {

        this.cloudEventVersion = cloudEventVersion;
        return this;
    }

    /**
     * The inline hook cloud version
     *
     * @return cloudEventVersion
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "0.1", value = "The inline hook cloud version")
    @JsonProperty(JSON_PROPERTY_CLOUD_EVENT_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCloudEventVersion() {
        return cloudEventVersion;
    }

    @JsonProperty(JSON_PROPERTY_CLOUD_EVENT_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCloudEventVersion(String cloudEventVersion) {
        this.cloudEventVersion = cloudEventVersion;
    }

    public TokenRequest contentType(String contentType) {

        this.contentType = contentType;
        return this;
    }

    /**
     * The inline hook request header content
     *
     * @return contentType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "application/JSON", value = "The inline hook request header content")
    @JsonProperty(JSON_PROPERTY_CONTENT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getContentType() {
        return contentType;
    }

    @JsonProperty(JSON_PROPERTY_CONTENT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public TokenRequest eventId(String eventId) {

        this.eventId = eventId;
        return this;
    }

    /**
     * The individual inline hook request ID
     *
     * @return eventId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "3o9jBzq1SmOGmmsDsqyyeQ", value = "The individual inline hook request ID")
    @JsonProperty(JSON_PROPERTY_EVENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getEventId() {
        return eventId;
    }

    @JsonProperty(JSON_PROPERTY_EVENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public TokenRequest eventTime(String eventTime) {

        this.eventTime = eventTime;
        return this;
    }

    /**
     * The time the inline hook request was sent
     *
     * @return eventTime
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2020-01-17T21:23:56.000Z", value = "The time the inline hook request was sent")
    @JsonProperty(JSON_PROPERTY_EVENT_TIME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getEventTime() {
        return eventTime;
    }

    @JsonProperty(JSON_PROPERTY_EVENT_TIME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEventTime(String eventTime) {
        this.eventTime = eventTime;
    }

    public TokenRequest eventTypeVersion(String eventTypeVersion) {

        this.eventTypeVersion = eventTypeVersion;
        return this;
    }

    /**
     * The inline hook version
     *
     * @return eventTypeVersion
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "1", value = "The inline hook version")
    @JsonProperty(JSON_PROPERTY_EVENT_TYPE_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getEventTypeVersion() {
        return eventTypeVersion;
    }

    @JsonProperty(JSON_PROPERTY_EVENT_TYPE_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEventTypeVersion(String eventTypeVersion) {
        this.eventTypeVersion = eventTypeVersion;
    }

    public TokenRequest data(TokenPayLoadData data) {

        this.data = data;
        return this;
    }

    /**
     * Get data
     *
     * @return data
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TokenPayLoadData getData() {
        return data;
    }

    @JsonProperty(JSON_PROPERTY_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setData(TokenPayLoadData data) {
        this.data = data;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TokenRequest tokenRequest = (TokenRequest) o;
        return Objects.equals(this.cloudEventVersion, tokenRequest.cloudEventVersion)
                && Objects.equals(this.contentType, tokenRequest.contentType)
                && Objects.equals(this.eventId, tokenRequest.eventId)
                && Objects.equals(this.eventTime, tokenRequest.eventTime)
                && Objects.equals(this.eventTypeVersion, tokenRequest.eventTypeVersion)
                && Objects.equals(this.data, tokenRequest.data);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(cloudEventVersion, contentType, eventId, eventTime, eventTypeVersion, data);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenRequest {\n");
        sb.append("    cloudEventVersion: ").append(toIndentedString(cloudEventVersion)).append("\n");
        sb.append("    contentType: ").append(toIndentedString(contentType)).append("\n");
        sb.append("    eventId: ").append(toIndentedString(eventId)).append("\n");
        sb.append("    eventTime: ").append(toIndentedString(eventTime)).append("\n");
        sb.append("    eventTypeVersion: ").append(toIndentedString(eventTypeVersion)).append("\n");
        sb.append("    data: ").append(toIndentedString(data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
