package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CapabilitiesCreateObject;
import com.okta.sdk.resource.model.CapabilitiesImportRulesObject;
import com.okta.sdk.resource.model.CapabilitiesImportSettingsObject;
import com.okta.sdk.resource.model.CapabilitiesInboundProvisioningObject;
import com.okta.sdk.resource.model.CapabilitiesObject;
import com.okta.sdk.resource.model.CapabilitiesUpdateObject;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UpdateFeatureForApplicationRequest
 */
@JsonPropertyOrder({ UpdateFeatureForApplicationRequest.JSON_PROPERTY_CREATE,
        UpdateFeatureForApplicationRequest.JSON_PROPERTY_UPDATE,
        UpdateFeatureForApplicationRequest.JSON_PROPERTY_IMPORT_RULES,
        UpdateFeatureForApplicationRequest.JSON_PROPERTY_IMPORT_SETTINGS })
@JsonTypeName("updateFeatureForApplication_request")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UpdateFeatureForApplicationRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATE = "create";
    private CapabilitiesCreateObject create;

    public static final String JSON_PROPERTY_UPDATE = "update";
    private CapabilitiesUpdateObject update;

    public static final String JSON_PROPERTY_IMPORT_RULES = "importRules";
    private CapabilitiesImportRulesObject importRules;

    public static final String JSON_PROPERTY_IMPORT_SETTINGS = "importSettings";
    private CapabilitiesImportSettingsObject importSettings;

    public UpdateFeatureForApplicationRequest() {
    }

    public UpdateFeatureForApplicationRequest create(CapabilitiesCreateObject create) {

        this.create = create;
        return this;
    }

    /**
     * Get create
     *
     * @return create
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CapabilitiesCreateObject getCreate() {
        return create;
    }

    @JsonProperty(JSON_PROPERTY_CREATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCreate(CapabilitiesCreateObject create) {
        this.create = create;
    }

    public UpdateFeatureForApplicationRequest update(CapabilitiesUpdateObject update) {

        this.update = update;
        return this;
    }

    /**
     * Get update
     *
     * @return update
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_UPDATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CapabilitiesUpdateObject getUpdate() {
        return update;
    }

    @JsonProperty(JSON_PROPERTY_UPDATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUpdate(CapabilitiesUpdateObject update) {
        this.update = update;
    }

    public UpdateFeatureForApplicationRequest importRules(CapabilitiesImportRulesObject importRules) {

        this.importRules = importRules;
        return this;
    }

    /**
     * Get importRules
     *
     * @return importRules
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_IMPORT_RULES)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public CapabilitiesImportRulesObject getImportRules() {
        return importRules;
    }

    @JsonProperty(JSON_PROPERTY_IMPORT_RULES)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setImportRules(CapabilitiesImportRulesObject importRules) {
        this.importRules = importRules;
    }

    public UpdateFeatureForApplicationRequest importSettings(CapabilitiesImportSettingsObject importSettings) {

        this.importSettings = importSettings;
        return this;
    }

    /**
     * Get importSettings
     *
     * @return importSettings
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_IMPORT_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public CapabilitiesImportSettingsObject getImportSettings() {
        return importSettings;
    }

    @JsonProperty(JSON_PROPERTY_IMPORT_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setImportSettings(CapabilitiesImportSettingsObject importSettings) {
        this.importSettings = importSettings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateFeatureForApplicationRequest updateFeatureForApplicationRequest = (UpdateFeatureForApplicationRequest) o;
        return Objects.equals(this.create, updateFeatureForApplicationRequest.create)
                && Objects.equals(this.update, updateFeatureForApplicationRequest.update)
                && Objects.equals(this.importRules, updateFeatureForApplicationRequest.importRules)
                && Objects.equals(this.importSettings, updateFeatureForApplicationRequest.importSettings);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(create, update, importRules, importSettings);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateFeatureForApplicationRequest {\n");
        sb.append("    create: ").append(toIndentedString(create)).append("\n");
        sb.append("    update: ").append(toIndentedString(update)).append("\n");
        sb.append("    importRules: ").append(toIndentedString(importRules)).append("\n");
        sb.append("    importSettings: ").append(toIndentedString(importSettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
