package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserFactorActivateResponseLinks;
import com.okta.sdk.resource.model.UserFactorProfile;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserFactorActivateResponse
 */
@JsonPropertyOrder({ UserFactorActivateResponse.JSON_PROPERTY_ID, UserFactorActivateResponse.JSON_PROPERTY_FACTOR_TYPE,
        UserFactorActivateResponse.JSON_PROPERTY_PROVIDER, UserFactorActivateResponse.JSON_PROPERTY_VENDOR_NAME,
        UserFactorActivateResponse.JSON_PROPERTY_STATUS, UserFactorActivateResponse.JSON_PROPERTY_CREATED,
        UserFactorActivateResponse.JSON_PROPERTY_LAST_UPDATED, UserFactorActivateResponse.JSON_PROPERTY_PROFILE,
        UserFactorActivateResponse.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "factorType", visible = true, defaultImpl = UserFactorActivateResponse.class)

public class UserFactorActivateResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    /**
     * Type of the Factor
     */
    public enum FactorTypeEnum {
        CALL(String.valueOf("call")),

        EMAIL(String.valueOf("email")),

        SMS(String.valueOf("sms")),

        PUSH(String.valueOf("push")),

        TOKEN_SOFTWARE_TOTP(String.valueOf("token:software:totp")),

        U2F(String.valueOf("u2f")),

        WEBAUTHN(String.valueOf("webauthn")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        FactorTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static FactorTypeEnum fromValue(String value) {
            for (FactorTypeEnum b : FactorTypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_FACTOR_TYPE = "factorType";
    protected FactorTypeEnum factorType;

    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private String provider;

    public static final String JSON_PROPERTY_VENDOR_NAME = "vendorName";
    private String vendorName;

    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;

    public static final String JSON_PROPERTY_CREATED = "created";
    private String created;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private String lastUpdated;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private UserFactorProfile profile;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private UserFactorActivateResponseLinks links;

    public UserFactorActivateResponse() {
    }

    public UserFactorActivateResponse id(String id) {

        this.id = id;
        return this;
    }

    /**
     * Get id
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public UserFactorActivateResponse factorType(FactorTypeEnum factorType) {

        this.factorType = factorType;
        return this;
    }

    /**
     * Type of the Factor
     *
     * @return factorType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Type of the Factor")
    @JsonProperty(JSON_PROPERTY_FACTOR_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FactorTypeEnum getFactorType() {
        return factorType;
    }

    @JsonProperty(JSON_PROPERTY_FACTOR_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFactorType(FactorTypeEnum factorType) {
        this.factorType = factorType;
    }

    public UserFactorActivateResponse provider(String provider) {

        this.provider = provider;
        return this;
    }

    /**
     * Get provider
     *
     * @return provider
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "OKTA", value = "")
    @JsonProperty(JSON_PROPERTY_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getProvider() {
        return provider;
    }

    @JsonProperty(JSON_PROPERTY_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(String provider) {
        this.provider = provider;
    }

    public UserFactorActivateResponse vendorName(String vendorName) {

        this.vendorName = vendorName;
        return this;
    }

    /**
     * Get vendorName
     *
     * @return vendorName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "OKTA", value = "")
    @JsonProperty(JSON_PROPERTY_VENDOR_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getVendorName() {
        return vendorName;
    }

    @JsonProperty(JSON_PROPERTY_VENDOR_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public UserFactorActivateResponse status(String status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "ACTIVE", value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(String status) {
        this.status = status;
    }

    public UserFactorActivateResponse created(String created) {

        this.created = created;
        return this;
    }

    /**
     * Get created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2014-07-16T16:13:56.000Z", value = "")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreated() {
        return created;
    }

    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCreated(String created) {
        this.created = created;
    }

    public UserFactorActivateResponse lastUpdated(String lastUpdated) {

        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * Get lastUpdated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2014-08-06T00:31:07.000Z", value = "")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastUpdated() {
        return lastUpdated;
    }

    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public UserFactorActivateResponse profile(UserFactorProfile profile) {

        this.profile = profile;
        return this;
    }

    /**
     * Get profile
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorProfile getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(UserFactorProfile profile) {
        this.profile = profile;
    }

    public UserFactorActivateResponse links(UserFactorActivateResponseLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorActivateResponseLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(UserFactorActivateResponseLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserFactorActivateResponse userFactorActivateResponse = (UserFactorActivateResponse) o;
        return Objects.equals(this.id, userFactorActivateResponse.id)
                && Objects.equals(this.factorType, userFactorActivateResponse.factorType)
                && Objects.equals(this.provider, userFactorActivateResponse.provider)
                && Objects.equals(this.vendorName, userFactorActivateResponse.vendorName)
                && Objects.equals(this.status, userFactorActivateResponse.status)
                && Objects.equals(this.created, userFactorActivateResponse.created)
                && Objects.equals(this.lastUpdated, userFactorActivateResponse.lastUpdated)
                && Objects.equals(this.profile, userFactorActivateResponse.profile)
                && Objects.equals(this.links, userFactorActivateResponse.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, factorType, provider, vendorName, status, created, lastUpdated, profile, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorActivateResponse {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    factorType: ").append(toIndentedString(factorType)).append("\n");
        sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
        sb.append("    vendorName: ").append(toIndentedString(vendorName)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
