package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserImportResponseCommandsInner
 */
@JsonPropertyOrder({ UserImportResponseCommandsInner.JSON_PROPERTY_TYPE,
        UserImportResponseCommandsInner.JSON_PROPERTY_VALUE })
@JsonTypeName("UserImportResponse_commands_inner")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserImportResponseCommandsInner implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * The command types supported for the import inline hook. When using the &#x60;com.okta.action.update&#x60; command
     * to specify that the user should be treated as a match, you need to also provide a
     * &#x60;com.okta.user.update&#x60; command that sets the ID of the Okta user.
     */
    public enum TypeEnum {
        COM_OKTA_APP_USER_PROFILE_UPDATE(String.valueOf("com.okta.appUser.profile.update")),

        COM_OKTA_USER_PROFILE_UPDATE(String.valueOf("com.okta.user.profile.update")),

        COM_OKTA_ACTION_UPDATE(String.valueOf("com.okta.action.update")),

        COM_OKTA_USER_UPDATE(String.valueOf("com.okta.user.update")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public static final String JSON_PROPERTY_VALUE = "value";
    private Map<String, String> value = null;

    public UserImportResponseCommandsInner() {
    }

    public UserImportResponseCommandsInner type(TypeEnum type) {

        this.type = type;
        return this;
    }

    /**
     * The command types supported for the import inline hook. When using the &#x60;com.okta.action.update&#x60; command
     * to specify that the user should be treated as a match, you need to also provide a
     * &#x60;com.okta.user.update&#x60; command that sets the ID of the Okta user.
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The command types supported for the import inline hook. When using the `com.okta.action.update` command to specify that the user should be treated as a match, you need to also provide a `com.okta.user.update` command that sets the ID of the Okta user.")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TypeEnum getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public UserImportResponseCommandsInner value(Map<String, String> value) {

        this.value = value;
        return this;
    }

    public UserImportResponseCommandsInner putvalueItem(String key, String valueItem) {
        if (this.value == null) {
            this.value = new HashMap<>();
        }
        this.value.put(key, valueItem);
        return this;
    }

    /**
     * The &#x60;value&#x60; object is the parameter to pass to the command. In the case of the
     * &#x60;com.okta.appUser.profile.update&#x60; and &#x60;com.okta.user.profile.update&#x60; commands, the parameter
     * should be a list of one or more profile attributes and the values you wish to set them to. In the case of the
     * &#x60;com.okta.action.update&#x60; command, the parameter should be a &#x60;result&#x60; property set to either
     * &#x60;CREATE_USER&#x60; or &#x60;LINK_USER&#x60;.
     *
     * @return value
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `value` object is the parameter to pass to the command. In the case of the `com.okta.appUser.profile.update` and `com.okta.user.profile.update` commands,  the parameter should be a list of one or more profile attributes and the values you wish to set them to. In the case of the `com.okta.action.update` command, the parameter should be a `result` property set to either `CREATE_USER` or `LINK_USER`.")
    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, String> getValue() {
        return value;
    }

    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValue(Map<String, String> value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserImportResponseCommandsInner userImportResponseCommandsInner = (UserImportResponseCommandsInner) o;
        return Objects.equals(this.type, userImportResponseCommandsInner.type)
                && Objects.equals(this.value, userImportResponseCommandsInner.value);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserImportResponseCommandsInner {\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    value: ").append(toIndentedString(value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
