# ApiServiceIntegrationsApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**activateApiServiceIntegrationInstanceSecret**](ApiServiceIntegrationsApi.md#activateApiServiceIntegrationInstanceSecret) | **POST** /integrations/api/v1/api-services/{apiServiceId}/credentials/secrets/{secretId}/lifecycle/activate | Activate an API Service Integration instance Secret |
| [**createApiServiceIntegrationInstance**](ApiServiceIntegrationsApi.md#createApiServiceIntegrationInstance) | **POST** /integrations/api/v1/api-services | Create an API Service Integration instance |
| [**createApiServiceIntegrationInstanceSecret**](ApiServiceIntegrationsApi.md#createApiServiceIntegrationInstanceSecret) | **POST** /integrations/api/v1/api-services/{apiServiceId}/credentials/secrets | Create an API Service Integration instance Secret |
| [**deactivateApiServiceIntegrationInstanceSecret**](ApiServiceIntegrationsApi.md#deactivateApiServiceIntegrationInstanceSecret) | **POST** /integrations/api/v1/api-services/{apiServiceId}/credentials/secrets/{secretId}/lifecycle/deactivate | Deactivate an API Service Integration instance Secret |
| [**deleteApiServiceIntegrationInstance**](ApiServiceIntegrationsApi.md#deleteApiServiceIntegrationInstance) | **DELETE** /integrations/api/v1/api-services/{apiServiceId} | Delete an API Service Integration instance |
| [**deleteApiServiceIntegrationInstanceSecret**](ApiServiceIntegrationsApi.md#deleteApiServiceIntegrationInstanceSecret) | **DELETE** /integrations/api/v1/api-services/{apiServiceId}/credentials/secrets/{secretId} | Delete an API Service Integration instance Secret |
| [**getApiServiceIntegrationInstance**](ApiServiceIntegrationsApi.md#getApiServiceIntegrationInstance) | **GET** /integrations/api/v1/api-services/{apiServiceId} | Retrieve an API Service Integration instance |
| [**listApiServiceIntegrationInstanceSecrets**](ApiServiceIntegrationsApi.md#listApiServiceIntegrationInstanceSecrets) | **GET** /integrations/api/v1/api-services/{apiServiceId}/credentials/secrets | List all API Service Integration instance Secrets |
| [**listApiServiceIntegrationInstances**](ApiServiceIntegrationsApi.md#listApiServiceIntegrationInstances) | **GET** /integrations/api/v1/api-services | List all API Service Integration instances |



## activateApiServiceIntegrationInstanceSecret

> APIServiceIntegrationInstanceSecret activateApiServiceIntegrationInstanceSecret(apiServiceId, secretId)

Activate an API Service Integration instance Secret

Activates an API Service Integration instance Secret by &#x60;secretId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApiServiceIntegrationsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApiServiceIntegrationsApi apiInstance = new ApiServiceIntegrationsApi(defaultClient);
        String apiServiceId = "000lr2rLjZ6NsGn1P0g3"; // String | `id` of the API Service Integration instance
        String secretId = "ocs2f4zrZbs8nUa7p0g4"; // String | `id` of the API Service Integration instance Secret
        try {
            APIServiceIntegrationInstanceSecret result = apiInstance.activateApiServiceIntegrationInstanceSecret(apiServiceId, secretId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApiServiceIntegrationsApi#activateApiServiceIntegrationInstanceSecret");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **apiServiceId** | **String**| &#x60;id&#x60; of the API Service Integration instance | |
| **secretId** | **String**| &#x60;id&#x60; of the API Service Integration instance Secret | |

### Return type

[**APIServiceIntegrationInstanceSecret**](APIServiceIntegrationInstanceSecret.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## createApiServiceIntegrationInstance

> PostAPIServiceIntegrationInstance createApiServiceIntegrationInstance(postAPIServiceIntegrationInstanceRequest)

Create an API Service Integration instance

Creates and authorizes an API Service Integration instance

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApiServiceIntegrationsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        ApiServiceIntegrationsApi apiInstance = new ApiServiceIntegrationsApi(defaultClient);
        PostAPIServiceIntegrationInstanceRequest postAPIServiceIntegrationInstanceRequest = new PostAPIServiceIntegrationInstanceRequest(); // PostAPIServiceIntegrationInstanceRequest | 
        try {
            PostAPIServiceIntegrationInstance result = apiInstance.createApiServiceIntegrationInstance(postAPIServiceIntegrationInstanceRequest);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApiServiceIntegrationsApi#createApiServiceIntegrationInstance");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **postAPIServiceIntegrationInstanceRequest** | [**PostAPIServiceIntegrationInstanceRequest**](PostAPIServiceIntegrationInstanceRequest.md)|  | |

### Return type

[**PostAPIServiceIntegrationInstance**](PostAPIServiceIntegrationInstance.md)

### Authorization

[apiToken](../README.md#apiToken)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Created |  -  |
| **400** | Bad Request |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## createApiServiceIntegrationInstanceSecret

> APIServiceIntegrationInstanceSecret createApiServiceIntegrationInstanceSecret(apiServiceId)

Create an API Service Integration instance Secret

Creates an API Service Integration instance Secret object with a new active client secret. You can create up to two Secret objects. An error is returned if you attempt to create more than two Secret objects.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApiServiceIntegrationsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApiServiceIntegrationsApi apiInstance = new ApiServiceIntegrationsApi(defaultClient);
        String apiServiceId = "000lr2rLjZ6NsGn1P0g3"; // String | `id` of the API Service Integration instance
        try {
            APIServiceIntegrationInstanceSecret result = apiInstance.createApiServiceIntegrationInstanceSecret(apiServiceId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApiServiceIntegrationsApi#createApiServiceIntegrationInstanceSecret");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **apiServiceId** | **String**| &#x60;id&#x60; of the API Service Integration instance | |

### Return type

[**APIServiceIntegrationInstanceSecret**](APIServiceIntegrationInstanceSecret.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Created |  -  |
| **400** | Bad Request |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## deactivateApiServiceIntegrationInstanceSecret

> APIServiceIntegrationInstanceSecret deactivateApiServiceIntegrationInstanceSecret(apiServiceId, secretId)

Deactivate an API Service Integration instance Secret

Deactivates an API Service Integration instance Secret by &#x60;secretId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApiServiceIntegrationsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApiServiceIntegrationsApi apiInstance = new ApiServiceIntegrationsApi(defaultClient);
        String apiServiceId = "000lr2rLjZ6NsGn1P0g3"; // String | `id` of the API Service Integration instance
        String secretId = "ocs2f4zrZbs8nUa7p0g4"; // String | `id` of the API Service Integration instance Secret
        try {
            APIServiceIntegrationInstanceSecret result = apiInstance.deactivateApiServiceIntegrationInstanceSecret(apiServiceId, secretId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApiServiceIntegrationsApi#deactivateApiServiceIntegrationInstanceSecret");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **apiServiceId** | **String**| &#x60;id&#x60; of the API Service Integration instance | |
| **secretId** | **String**| &#x60;id&#x60; of the API Service Integration instance Secret | |

### Return type

[**APIServiceIntegrationInstanceSecret**](APIServiceIntegrationInstanceSecret.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteApiServiceIntegrationInstance

> deleteApiServiceIntegrationInstance(apiServiceId)

Delete an API Service Integration instance

Deletes an API Service Integration instance by &#x60;id&#x60;. This operation also revokes access to scopes that were previously granted to this API Service Integration instance.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApiServiceIntegrationsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApiServiceIntegrationsApi apiInstance = new ApiServiceIntegrationsApi(defaultClient);
        String apiServiceId = "000lr2rLjZ6NsGn1P0g3"; // String | `id` of the API Service Integration instance
        try {
            apiInstance.deleteApiServiceIntegrationInstance(apiServiceId);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApiServiceIntegrationsApi#deleteApiServiceIntegrationInstance");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **apiServiceId** | **String**| &#x60;id&#x60; of the API Service Integration instance | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteApiServiceIntegrationInstanceSecret

> deleteApiServiceIntegrationInstanceSecret(apiServiceId, secretId)

Delete an API Service Integration instance Secret

Deletes an API Service Integration instance Secret by &#x60;secretId&#x60;. You can only delete an inactive Secret.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApiServiceIntegrationsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApiServiceIntegrationsApi apiInstance = new ApiServiceIntegrationsApi(defaultClient);
        String apiServiceId = "000lr2rLjZ6NsGn1P0g3"; // String | `id` of the API Service Integration instance
        String secretId = "ocs2f4zrZbs8nUa7p0g4"; // String | `id` of the API Service Integration instance Secret
        try {
            apiInstance.deleteApiServiceIntegrationInstanceSecret(apiServiceId, secretId);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApiServiceIntegrationsApi#deleteApiServiceIntegrationInstanceSecret");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **apiServiceId** | **String**| &#x60;id&#x60; of the API Service Integration instance | |
| **secretId** | **String**| &#x60;id&#x60; of the API Service Integration instance Secret | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getApiServiceIntegrationInstance

> APIServiceIntegrationInstance getApiServiceIntegrationInstance(apiServiceId)

Retrieve an API Service Integration instance

Retrieves an API Service Integration instance by &#x60;id&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApiServiceIntegrationsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApiServiceIntegrationsApi apiInstance = new ApiServiceIntegrationsApi(defaultClient);
        String apiServiceId = "000lr2rLjZ6NsGn1P0g3"; // String | `id` of the API Service Integration instance
        try {
            APIServiceIntegrationInstance result = apiInstance.getApiServiceIntegrationInstance(apiServiceId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApiServiceIntegrationsApi#getApiServiceIntegrationInstance");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **apiServiceId** | **String**| &#x60;id&#x60; of the API Service Integration instance | |

### Return type

[**APIServiceIntegrationInstance**](APIServiceIntegrationInstance.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listApiServiceIntegrationInstanceSecrets

> List&lt;APIServiceIntegrationInstanceSecret&gt; listApiServiceIntegrationInstanceSecrets(apiServiceId)

List all API Service Integration instance Secrets

Lists all client secrets for an API Service Integration instance by &#x60;apiServiceId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApiServiceIntegrationsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApiServiceIntegrationsApi apiInstance = new ApiServiceIntegrationsApi(defaultClient);
        String apiServiceId = "000lr2rLjZ6NsGn1P0g3"; // String | `id` of the API Service Integration instance
        try {
            List<APIServiceIntegrationInstanceSecret> result = apiInstance.listApiServiceIntegrationInstanceSecrets(apiServiceId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApiServiceIntegrationsApi#listApiServiceIntegrationInstanceSecrets");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **apiServiceId** | **String**| &#x60;id&#x60; of the API Service Integration instance | |

### Return type

[**List&lt;APIServiceIntegrationInstanceSecret&gt;**](APIServiceIntegrationInstanceSecret.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listApiServiceIntegrationInstances

> List&lt;APIServiceIntegrationInstance&gt; listApiServiceIntegrationInstances(after)

List all API Service Integration instances

Lists all API Service Integration instances with a pagination option

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApiServiceIntegrationsApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApiServiceIntegrationsApi apiInstance = new ApiServiceIntegrationsApi(defaultClient);
        String after = "after_example"; // String | The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the `Link` response header. See [Pagination](https://developer.okta.com/docs/api/#pagination).
        try {
            List<APIServiceIntegrationInstance> result = apiInstance.listApiServiceIntegrationInstances(after);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApiServiceIntegrationsApi#listApiServiceIntegrationInstances");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **after** | **String**| The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](https://developer.okta.com/docs/api/#pagination). | [optional] |

### Return type

[**List&lt;APIServiceIntegrationInstance&gt;**](APIServiceIntegrationInstance.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |

