# ApplicationSsoApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**previewSAMLmetadataForApplication**](ApplicationSsoApi.md#previewSAMLmetadataForApplication) | **GET** /api/v1/apps/{appId}/sso/saml/metadata | Preview the application SAML metadata |



## previewSAMLmetadataForApplication

> String previewSAMLmetadataForApplication(appId, kid)

Preview the application SAML metadata

Previews the SSO SAML metadata for an application

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.ApplicationSsoApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        ApplicationSsoApi apiInstance = new ApplicationSsoApi(defaultClient);
        String appId = "0oafxqCAJWWGELFTYASJ"; // String | Application ID
        String kid = "mXtzOtml09Dg1ZCeKxTRBo3KrQuBWFkJ5oxhVagjTzo"; // String | 
        try {
            String result = apiInstance.previewSAMLmetadataForApplication(appId, kid);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ApplicationSsoApi#previewSAMLmetadataForApplication");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **appId** | **String**| Application ID | |
| **kid** | **String**|  | |

### Return type

**String**

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/xml, application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

