# UserApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**createUser**](UserApi.md#createUser) | **POST** /api/v1/users | Create a User |
| [**deleteUser**](UserApi.md#deleteUser) | **DELETE** /api/v1/users/{id} | Delete a User |
| [**getUser**](UserApi.md#getUser) | **GET** /api/v1/users/{id} | Retrieve a User |
| [**listUserBlocks**](UserApi.md#listUserBlocks) | **GET** /api/v1/users/{userId}/blocks | List all User Blocks |
| [**listUsers**](UserApi.md#listUsers) | **GET** /api/v1/users | List all Users |
| [**replaceUser**](UserApi.md#replaceUser) | **PUT** /api/v1/users/{id} | Replace a User |
| [**updateUser**](UserApi.md#updateUser) | **POST** /api/v1/users/{id} | Update a User |



## createUser

> User createUser(body, activate, provider, nextLogin)

Create a User

Creates a new User in your Okta org with or without credentials.&lt;br&gt; &gt; **Legal Disclaimer** &gt;  &gt; After a User is added to the Okta directory, they receive an activation email. As part of signing up for this service, &gt; you agreed not to use Okta&#39;s service/product to spam and/or send unsolicited messages. &gt; Please refrain from adding unrelated accounts to the directory as Okta is not responsible for, and disclaims any and all &gt; liability associated with, the activation email&#39;s content. You, and you alone, bear responsibility for the emails sent to any recipients.  All responses return the created User. Activation of a User is an asynchronous operation. The system performs group reconciliation during activation and assigns the User to all apps via direct or indirect relationships (group memberships). * The user&#39;s &#x60;transitioningToStatus&#x60; property is &#x60;ACTIVE&#x60; during activation to indicate that the User hasn&#39;t completed the asynchronous operation. * The user&#39;s &#x60;status&#x60; is &#x60;ACTIVE&#x60; when the activation process is complete.  The User is emailed a one-time activation token if activated without a password.  &gt; **Note:** If the User is assigned to an app that is configured for provisioning, the activation process triggers downstream provisioning to the app.  It is possible for a User to sign in before these apps have been successfully provisioned for the User.  &gt; **Important:** Do not generate or send a one-time activation token when activating Users with an assigned password. Users should sign in with their assigned password.  For more information about the various scenarios of creating a user listed in the examples, see User Scenario Creations section in the [Users API](/openapi/okta-management/management/tag/User) description.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        CreateUserRequest body = new CreateUserRequest(); // CreateUserRequest | 
        Boolean activate = true; // Boolean | Executes an [activation lifecycle](/openapi/okta-management/management/tag/UserLifecycle/#tag/UserLifecycle/operation/activateUser) operation when creating the User
        Boolean provider = false; // Boolean | Indicates whether to create a User with a specified authentication provider
        UserNextLogin nextLogin = UserNextLogin.fromValue("changePassword"); // UserNextLogin | With `activate=true`, if `nextLogin=changePassword`, a User is created, activated, and the password is set to `EXPIRED`. The User must change it the next time they sign in.
        try {
            User result = apiInstance.createUser(body, activate, provider, nextLogin);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#createUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **body** | [**CreateUserRequest**](CreateUserRequest.md)|  | |
| **activate** | **Boolean**| Executes an [activation lifecycle](/openapi/okta-management/management/tag/UserLifecycle/#tag/UserLifecycle/operation/activateUser) operation when creating the User | [optional] [default to true] |
| **provider** | **Boolean**| Indicates whether to create a User with a specified authentication provider | [optional] [default to false] |
| **nextLogin** | [**UserNextLogin**](.md)| With &#x60;activate&#x3D;true&#x60;, if &#x60;nextLogin&#x3D;changePassword&#x60;, a User is created, activated, and the password is set to &#x60;EXPIRED&#x60;. The User must change it the next time they sign in. | [optional] [enum: changePassword] |

### Return type

[**User**](User.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## deleteUser

> deleteUser(id, sendEmail, prefer)

Delete a User

Deletes a User permanently. This operation can only be performed on Users that have a &#x60;DEPROVISIONED&#x60; status. **This action can&#39;t be recovered!**  This operation on a User that hasn&#39;t been deactivated causes that User to be deactivated. A second delete operation is required to delete the User.  &gt; **Note:** You can also perform user deletion asynchronously. To invoke asynchronous user deletion, pass an HTTP header &#x60;Prefer: respond-async&#x60; with the request.  This header is also supported by user deactivation, which is performed if the delete endpoint is invoked on a User that hasn&#39;t been deactivated.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String id = "id_example"; // String | `id`, `login`, or `login shortname` (as long as it is unambiguous) of user
        Boolean sendEmail = false; // Boolean | Sends a deactivation email to the admin if `true`
        String prefer = "respond-async"; // String | 
        try {
            apiInstance.deleteUser(id, sendEmail, prefer);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#deleteUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**| &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; (as long as it is unambiguous) of user | |
| **sendEmail** | **Boolean**| Sends a deactivation email to the admin if &#x60;true&#x60; | [optional] [default to false] |
| **prefer** | **String**|  | [optional] [enum: respond-async] |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getUser

> UserGetSingleton getUser(id, contentType, expand)

Retrieve a User

Retrieves a User from your Okta org.  &gt; **Note:** You can substitute &#x60;me&#x60; for the &#x60;id&#x60; to fetch the current User linked to an API token or session cookie. &gt; * The request returns the User linked to the API token that is specified in the Authorization header, not the User linked to the active session. Details of the Admin User who granted the API token is returned. &gt; * When the end User has an active Okta session, it is typically a CORS request from the browser. Therefore, it&#39;s possible to retrieve the current User without the Authorization header.  &gt; **Note:** Some browsers block third-party cookies by default, which disrupts Okta functionality in certain flows. See [Mitigate the impact of third-party cookie deprecation](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext-third-party-cookies).  &gt; **Note:** When fetching a User by &#x60;login&#x60; or &#x60;login shortname&#x60;, [URL encode](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding) the request parameter to ensure that special characters are escaped properly. Logins with a &#x60;/&#x60; character can only be fetched by &#x60;id&#x60; due to URL issues with escaping the &#x60;/&#x60; character.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String id = "id_example"; // String | `id`, `login`, or `login shortname` (as long as it is unambiguous) of user
        String contentType = "application/json; okta-response=omitCredentials,omitCredentialsLinks"; // String | Specifies the media type of the resource. Optional `okta-response` value can be included for performance optimization.  Complex DelAuth configurations may degrade performance when fetching specific parts of the response, and passing this parameter can omit these parts, bypassing the bottleneck.  Enum values for `okta-response`:   * `omitCredentials`: Omits the credentials subobject from the response.   * `omitCredentialsLinks`: Omits the following HAL links from the response: Change Password, Change Recovery Question, Forgot Password, Reset Password, Reset Factors, Unlock.   * `omitTransitioningToStatus`: Omits the `transitioningToStatus` field from the response.
        String expand = "blocks"; // String | An optional parameter to include metadata in the `_embedded` attribute. Valid value: `blocks`
        try {
            UserGetSingleton result = apiInstance.getUser(id, contentType, expand);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#getUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**| &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; (as long as it is unambiguous) of user | |
| **contentType** | **String**| Specifies the media type of the resource. Optional &#x60;okta-response&#x60; value can be included for performance optimization.  Complex DelAuth configurations may degrade performance when fetching specific parts of the response, and passing this parameter can omit these parts, bypassing the bottleneck.  Enum values for &#x60;okta-response&#x60;:   * &#x60;omitCredentials&#x60;: Omits the credentials subobject from the response.   * &#x60;omitCredentialsLinks&#x60;: Omits the following HAL links from the response: Change Password, Change Recovery Question, Forgot Password, Reset Password, Reset Factors, Unlock.   * &#x60;omitTransitioningToStatus&#x60;: Omits the &#x60;transitioningToStatus&#x60; field from the response. | [optional] |
| **expand** | **String**| An optional parameter to include metadata in the &#x60;_embedded&#x60; attribute. Valid value: &#x60;blocks&#x60; | [optional] |

### Return type

[**UserGetSingleton**](UserGetSingleton.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listUserBlocks

> List&lt;UserBlock&gt; listUserBlocks(userId)

List all User Blocks

Lists information about how the User is blocked from accessing their account

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        try {
            List<UserBlock> result = apiInstance.listUserBlocks(userId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#listUserBlocks");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |

### Return type

[**List&lt;UserBlock&gt;**](UserBlock.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listUsers

> List&lt;User&gt; listUsers(contentType, q, after, limit, filter, search, sortBy, sortOrder)

List all Users

Lists Users in your org, with pagination in most cases.  A subset of Users can be returned that match a supported filter expression or search criteria.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String contentType = "application/json; okta-response=omitCredentials,omitCredentialsLinks"; // String | Specifies the media type of the resource. Optional `okta-response` value can be included for performance optimization.  Complex DelAuth configurations may degrade performance when fetching specific parts of the response, and passing this parameter can omit these parts, bypassing the bottleneck.  Enum values for `okta-response`:   * `omitCredentials`: Omits the credentials subobject from the response.   * `omitCredentialsLinks`: Omits the following HAL links from the response: Change Password, Change Recovery Question, Forgot Password, Reset Password, Reset Factors, Unlock.   * `omitTransitioningToStatus`: Omits the `transitioningToStatus` field from the response.
        String q = "q_example"; // String | Finds users who match the specified query. This doesn't support pagination.  This might not deliver optimal performance for large orgs, and is deprecated for such use cases. To ensure optimal performance, use a [`search` parameter](/openapi/okta-management/management/tag/User/#tag/User/operation/listUsers!in=query&path=search&t=request) instead.  Use the `q` parameter for a simple lookup of users by name, for example when creating a people picker. The value of `q` is matched against `firstName`, `lastName`, or `email`. This performs a `startsWith` match, but this is an implementation detail and can change without notice. You don't need to specify `firstName`, `lastName`, or `email`.
        String after = "after_example"; // String | The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the `Link` response header. See [Pagination](https://developer.okta.com/docs/api/#pagination).
        Integer limit = 200; // Integer | Specifies the number of results returned. Defaults to 10 if `q` is provided.
        String filter = "status eq \"LOCKED_OUT\""; // String | Filters users with a supported expression for a subset of properties.  This requires [URL encoding](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding). For example, `filter=lastUpdated gt \"2013-06-01T00:00:00.000Z\"` is encoded as `filter=lastUpdated%20gt%20%222013-06-01T00:00:00.000Z%22`. Filtering is case-sensitive for attribute names and query values, while attribute operators are case-insensitive.  Filtering supports the following limited number of properties: `status`, `lastUpdated`, `id`, `profile.login`, `profile.email`, `profile.firstName`, and `profile.lastName`. Additionally, filtering supports only the equal `eq` operator from the standard Okta API filtering semantics, except in the case of the `lastUpdated` property. This property can also use the inequality operators (`gt`, `ge`, `lt`, and `le`). For logical operators, only the logical operators `and` and `or` are supported. The `not` operator isn't supported.
        String search = "status eq \"STAGED\""; // String | Searches for users with a supported filtering expression for most properties. Okta recommends using this parameter for search for best performance. This operation supports [pagination](https://developer.okta.com/docs/api/#pagination). Use an ID lookup for records that you update to ensure your results contain the latest data.  Property names in the search parameter are case sensitive, whereas operators (`eq`, `sw`, and so on) and string values are case insensitive. Unlike with user logins, diacritical marks are significant in search string values: a search for `isaac.brock` finds `Isaac.Brock`, but doesn't find a property whose value is `isáàc.bröck`. This operation requires [URL encoding](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding). For example, `search=profile.department eq \"Engineering\"` is encoded as `search=profile.department%20eq%20%22Engineering%22`.  > **Note:** If you use the special character `\"` within a quoted string, it must also be escaped `\\` and encoded. For example, `search=profile.lastName eq \"bob\"smith\"` is encoded as `search=profile.lastName%20eq%20%22bob%5C%22smith%22`.  This operation searches many properties:   * Any user profile property, including custom-defined properties   * The top-level properties `id`, `status`, `created`, `activated`, `statusChanged`, and `lastUpdated`   * The [User Type](https://developer.okta.com/docs/reference/api/user-types/) accessed as `type.id`  You can also use `sortBy` and `sortOrder` parameters. The `ne` (not equal) operator isn't supported, but you can obtain the same result by using `lt ... or ... gt`. For example, to see all users except those that have a status of `STAGED`, use `(status lt \"STAGED\" or status gt \"STAGED\")`.  You can search properties that are arrays. If any element matches the search term, the entire array (object) is returned. Okta follows the [SCIM Protocol Specification](https://tools.ietf.org/html/rfc7644#section-3.4.2.2) for searching arrays. You can search multiple arrays, multiple values in an array, as well as using the standard logical and filtering operators. See [Filter](https://developer.okta.com/docs/reference/core-okta-api/#filter).
        String sortBy = "sortBy_example"; // String | Specifies field to sort by (for search queries only). This can be any single property, for example `sortBy=profile.lastName`. Users with the same value for the `sortBy` property will be ordered by `id`.
        String sortOrder = "sortOrder_example"; // String | Specifies sort order asc or desc (for search queries only). Sorting is done in ASCII sort order (that is, by ASCII character value), but isn't case sensitive. `sortOrder` is ignored if `sortBy` is not present.
        try {
            List<User> result = apiInstance.listUsers(contentType, q, after, limit, filter, search, sortBy, sortOrder);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#listUsers");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **contentType** | **String**| Specifies the media type of the resource. Optional &#x60;okta-response&#x60; value can be included for performance optimization.  Complex DelAuth configurations may degrade performance when fetching specific parts of the response, and passing this parameter can omit these parts, bypassing the bottleneck.  Enum values for &#x60;okta-response&#x60;:   * &#x60;omitCredentials&#x60;: Omits the credentials subobject from the response.   * &#x60;omitCredentialsLinks&#x60;: Omits the following HAL links from the response: Change Password, Change Recovery Question, Forgot Password, Reset Password, Reset Factors, Unlock.   * &#x60;omitTransitioningToStatus&#x60;: Omits the &#x60;transitioningToStatus&#x60; field from the response. | [optional] |
| **q** | **String**| Finds users who match the specified query. This doesn&#39;t support pagination.  This might not deliver optimal performance for large orgs, and is deprecated for such use cases. To ensure optimal performance, use a [&#x60;search&#x60; parameter](/openapi/okta-management/management/tag/User/#tag/User/operation/listUsers!in&#x3D;query&amp;path&#x3D;search&amp;t&#x3D;request) instead.  Use the &#x60;q&#x60; parameter for a simple lookup of users by name, for example when creating a people picker. The value of &#x60;q&#x60; is matched against &#x60;firstName&#x60;, &#x60;lastName&#x60;, or &#x60;email&#x60;. This performs a &#x60;startsWith&#x60; match, but this is an implementation detail and can change without notice. You don&#39;t need to specify &#x60;firstName&#x60;, &#x60;lastName&#x60;, or &#x60;email&#x60;. | [optional] |
| **after** | **String**| The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](https://developer.okta.com/docs/api/#pagination). | [optional] |
| **limit** | **Integer**| Specifies the number of results returned. Defaults to 10 if &#x60;q&#x60; is provided. | [optional] [default to 200] |
| **filter** | **String**| Filters users with a supported expression for a subset of properties.  This requires [URL encoding](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding). For example, &#x60;filter&#x3D;lastUpdated gt \&quot;2013-06-01T00:00:00.000Z\&quot;&#x60; is encoded as &#x60;filter&#x3D;lastUpdated%20gt%20%222013-06-01T00:00:00.000Z%22&#x60;. Filtering is case-sensitive for attribute names and query values, while attribute operators are case-insensitive.  Filtering supports the following limited number of properties: &#x60;status&#x60;, &#x60;lastUpdated&#x60;, &#x60;id&#x60;, &#x60;profile.login&#x60;, &#x60;profile.email&#x60;, &#x60;profile.firstName&#x60;, and &#x60;profile.lastName&#x60;. Additionally, filtering supports only the equal &#x60;eq&#x60; operator from the standard Okta API filtering semantics, except in the case of the &#x60;lastUpdated&#x60; property. This property can also use the inequality operators (&#x60;gt&#x60;, &#x60;ge&#x60;, &#x60;lt&#x60;, and &#x60;le&#x60;). For logical operators, only the logical operators &#x60;and&#x60; and &#x60;or&#x60; are supported. The &#x60;not&#x60; operator isn&#39;t supported. | [optional] |
| **search** | **String**| Searches for users with a supported filtering expression for most properties. Okta recommends using this parameter for search for best performance. This operation supports [pagination](https://developer.okta.com/docs/api/#pagination). Use an ID lookup for records that you update to ensure your results contain the latest data.  Property names in the search parameter are case sensitive, whereas operators (&#x60;eq&#x60;, &#x60;sw&#x60;, and so on) and string values are case insensitive. Unlike with user logins, diacritical marks are significant in search string values: a search for &#x60;isaac.brock&#x60; finds &#x60;Isaac.Brock&#x60;, but doesn&#39;t find a property whose value is &#x60;isáàc.bröck&#x60;. This operation requires [URL encoding](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding). For example, &#x60;search&#x3D;profile.department eq \&quot;Engineering\&quot;&#x60; is encoded as &#x60;search&#x3D;profile.department%20eq%20%22Engineering%22&#x60;.  &gt; **Note:** If you use the special character &#x60;\&quot;&#x60; within a quoted string, it must also be escaped &#x60;\\&#x60; and encoded. For example, &#x60;search&#x3D;profile.lastName eq \&quot;bob\&quot;smith\&quot;&#x60; is encoded as &#x60;search&#x3D;profile.lastName%20eq%20%22bob%5C%22smith%22&#x60;.  This operation searches many properties:   * Any user profile property, including custom-defined properties   * The top-level properties &#x60;id&#x60;, &#x60;status&#x60;, &#x60;created&#x60;, &#x60;activated&#x60;, &#x60;statusChanged&#x60;, and &#x60;lastUpdated&#x60;   * The [User Type](https://developer.okta.com/docs/reference/api/user-types/) accessed as &#x60;type.id&#x60;  You can also use &#x60;sortBy&#x60; and &#x60;sortOrder&#x60; parameters. The &#x60;ne&#x60; (not equal) operator isn&#39;t supported, but you can obtain the same result by using &#x60;lt ... or ... gt&#x60;. For example, to see all users except those that have a status of &#x60;STAGED&#x60;, use &#x60;(status lt \&quot;STAGED\&quot; or status gt \&quot;STAGED\&quot;)&#x60;.  You can search properties that are arrays. If any element matches the search term, the entire array (object) is returned. Okta follows the [SCIM Protocol Specification](https://tools.ietf.org/html/rfc7644#section-3.4.2.2) for searching arrays. You can search multiple arrays, multiple values in an array, as well as using the standard logical and filtering operators. See [Filter](https://developer.okta.com/docs/reference/core-okta-api/#filter). | [optional] |
| **sortBy** | **String**| Specifies field to sort by (for search queries only). This can be any single property, for example &#x60;sortBy&#x3D;profile.lastName&#x60;. Users with the same value for the &#x60;sortBy&#x60; property will be ordered by &#x60;id&#x60;. | [optional] |
| **sortOrder** | **String**| Specifies sort order asc or desc (for search queries only). Sorting is done in ASCII sort order (that is, by ASCII character value), but isn&#39;t case sensitive. &#x60;sortOrder&#x60; is ignored if &#x60;sortBy&#x60; is not present. | [optional] |

### Return type

[**List&lt;User&gt;**](User.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## replaceUser

> User replaceUser(id, user, strict)

Replace a User

Replaces a User&#39;s profile, credentials, or both using strict-update semantics.  All profile properties must be specified when updating a User&#39;s profile with a &#x60;PUT&#x60; method. Any property not specified in the request is deleted. &gt; **Important:** Don&#39;t use a &#x60;PUT&#x60; method for partial updates.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String id = "id_example"; // String | `id`, `login`, or `login shortname` (as long as it is unambiguous) of user
        UpdateUserRequest user = new UpdateUserRequest(); // UpdateUserRequest | 
        Boolean strict = true; // Boolean | If `true`, validates against minimum age and history password policy
        try {
            User result = apiInstance.replaceUser(id, user, strict);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#replaceUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**| &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; (as long as it is unambiguous) of user | |
| **user** | [**UpdateUserRequest**](UpdateUserRequest.md)|  | |
| **strict** | **Boolean**| If &#x60;true&#x60;, validates against minimum age and history password policy | [optional] |

### Return type

[**User**](User.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## updateUser

> User updateUser(id, user, strict)

Update a User

Updates a user&#39;s profile or credentials with partial update semantics.  &gt; **Important:** Use the &#x60;POST&#x60; method for partial updates. Unspecified properties are set to null with &#x60;PUT&#x60;.  &#x60;profile&#x60; and &#x60;credentials&#x60; can be updated independently or together with a single request. &gt; **Note**: Currently, the User Type of a User can only be changed via a full replacement PUT operation. If the request parameters of a partial update include the type element from the User object, the value must match the existing type of the User. Only admins are permitted to change the User type of a User; end users are not allowed to change their own User type.  &gt; **Note**: To update a current user&#39;s profile with partial semantics, the &#x60;/api/v1/users/me&#x60; endpoint can be invoked. &gt; &gt; A User can only update profile properties for which the User has write access. Within the profile, if the User tries to update the primary or the secondary email IDs, verification emails are sent to those email IDs, and the fields are updated only upon verification.  If you are using this endpoint to set a password, it sets a password without validating existing user credentials. This is an administrative operation. For operations that validate credentials, refer to the &#x60;Reset Password&#x60;, &#x60;Forgot Password&#x60;, and &#x60;Change Password&#x60; endpoints.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserApi apiInstance = new UserApi(defaultClient);
        String id = "id_example"; // String | `id`, `login`, or `login shortname` (as long as it is unambiguous) of user
        UpdateUserRequest user = new UpdateUserRequest(); // UpdateUserRequest | 
        Boolean strict = true; // Boolean | If true, validates against minimum age and history password policy
        try {
            User result = apiInstance.updateUser(id, user, strict);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#updateUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**| &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; (as long as it is unambiguous) of user | |
| **user** | [**UpdateUserRequest**](UpdateUserRequest.md)|  | |
| **strict** | **Boolean**| If true, validates against minimum age and history password policy | [optional] |

### Return type

[**User**](User.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

