

# UserLinks

Specifies link relations (see [Web Linking](https://datatracker.ietf.org/doc/html/rfc8288) available for the current status of a user. The Links object is used for dynamic discovery of related resources, lifecycle operations, and credential operations. The Links object is read-only.  For an individual User result, the Links object contains a full set of link relations available for that User as determined by your policies. For a collection of users, the Links object contains only the `self` link. Operations that return a collection of Users include List Users and List Group Members.

## Properties

| Name | Type | Description | Notes |
|------------ | ------------- | ------------- | -------------|
|**self** | **HrefObject** | URL to the individual user |  [optional] |
|**activate** | **HrefObject** | URL to activate the user |  [optional] |
|**resetPassword** | **HrefObject** | URL to reset the User&#39;s password |  [optional] |
|**resetFactors** | **HrefObject** | URL to reset the User&#39;s factors |  [optional] |
|**expirePassword** | **HrefObject** | URL to expire the User&#39;s password |  [optional] |
|**forgotPassword** | **HrefObject** | URL to initiate a forgot password operation |  [optional] |
|**changeRecoveryQuestion** | **HrefObject** | URL to change the User&#39;s recovery question |  [optional] |
|**deactivate** | **HrefObject** | URL to deactivate a user |  [optional] |
|**reactivate** | **HrefObject** | URL to reactivate the user |  [optional] |
|**changePassword** | **HrefObject** | URL to change the User&#39;s password |  [optional] |
|**schema** | **HrefObject** | URL to the User&#39;s profile schema |  [optional] |
|**suspend** | **HrefObject** | URL to suspend the user |  [optional] |
|**unsuspend** | **HrefObject** | URL to unsuspend the user |  [optional] |
|**unlock** | **HrefObject** | URL to unlock the locked-out user |  [optional] |
|**type** | **HrefObject** | URL to the User Type |  [optional] |


## Implemented Interfaces

* Serializable


