/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.OAuth2ScopeConsentGrant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ApplicationGrantsApi {

    private ApiClient apiClient;

    public ApplicationGrantsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationGrantsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve an app Grant Retrieves a single scope consent Grant object for the app
     *
     * @param appId
     *            Application ID (required)
     * @param grantId
     *            Grant ID (required)
     * @param expand
     *            An optional parameter to return scope details in the &#x60;_embedded&#x60; property. Valid value:
     *            &#x60;scope&#x60; (optional)
     *
     * @return OAuth2ScopeConsentGrant
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ScopeConsentGrant getScopeConsentGrant(String appId, String grantId, String expand)
            throws ApiException {
        return this.getScopeConsentGrant(appId, grantId, expand, Collections.emptyMap());
    }

    /**
     * Retrieve an app Grant Retrieves a single scope consent Grant object for the app
     *
     * @param appId
     *            Application ID (required)
     * @param grantId
     *            Grant ID (required)
     * @param expand
     *            An optional parameter to return scope details in the &#x60;_embedded&#x60; property. Valid value:
     *            &#x60;scope&#x60; (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2ScopeConsentGrant
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ScopeConsentGrant getScopeConsentGrant(String appId, String grantId, String expand,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getScopeConsentGrant");
        }

        // verify the required parameter 'grantId' is set
        if (grantId == null) {
            throw new ApiException(400, "Missing the required parameter 'grantId' when calling getScopeConsentGrant");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/grants/{grantId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "grantId" + "\\}", apiClient.escapeString(grantId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2ScopeConsentGrant> localVarReturnType = new TypeReference<OAuth2ScopeConsentGrant>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Grant consent to scope Grants consent for the app to request an OAuth 2.0 Okta scope
     *
     * @param appId
     *            Application ID (required)
     * @param oAuth2ScopeConsentGrant
     *            (required)
     *
     * @return OAuth2ScopeConsentGrant
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ScopeConsentGrant grantConsentToScope(String appId, OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant)
            throws ApiException {
        return this.grantConsentToScope(appId, oAuth2ScopeConsentGrant, Collections.emptyMap());
    }

    /**
     * Grant consent to scope Grants consent for the app to request an OAuth 2.0 Okta scope
     *
     * @param appId
     *            Application ID (required)
     * @param oAuth2ScopeConsentGrant
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2ScopeConsentGrant
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ScopeConsentGrant grantConsentToScope(String appId, OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = oAuth2ScopeConsentGrant;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling grantConsentToScope");
        }

        // verify the required parameter 'oAuth2ScopeConsentGrant' is set
        if (oAuth2ScopeConsentGrant == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'oAuth2ScopeConsentGrant' when calling grantConsentToScope");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/grants".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2ScopeConsentGrant> localVarReturnType = new TypeReference<OAuth2ScopeConsentGrant>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all app Grants Lists all scope consent Grants for the app
     *
     * @param appId
     *            Application ID (required)
     * @param expand
     *            An optional parameter to return scope details in the &#x60;_embedded&#x60; property. Valid value:
     *            &#x60;scope&#x60; (optional)
     *
     * @return List&lt;OAuth2ScopeConsentGrant&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2ScopeConsentGrant> listScopeConsentGrants(String appId, String expand) throws ApiException {
        return this.listScopeConsentGrants(appId, expand, Collections.emptyMap());
    }

    /**
     * List all app Grants Lists all scope consent Grants for the app
     *
     * @param appId
     *            Application ID (required)
     * @param expand
     *            An optional parameter to return scope details in the &#x60;_embedded&#x60; property. Valid value:
     *            &#x60;scope&#x60; (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;OAuth2ScopeConsentGrant&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2ScopeConsentGrant> listScopeConsentGrants(String appId, String expand,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listScopeConsentGrants");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/grants".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<OAuth2ScopeConsentGrant>> localVarReturnType = new TypeReference<List<OAuth2ScopeConsentGrant>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Revoke an app Grant Revokes permission for the app to grant the given scope
     *
     * @param appId
     *            Application ID (required)
     * @param grantId
     *            Grant ID (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeScopeConsentGrant(String appId, String grantId) throws ApiException {
        this.revokeScopeConsentGrant(appId, grantId, Collections.emptyMap());
    }

    /**
     * Revoke an app Grant Revokes permission for the app to grant the given scope
     *
     * @param appId
     *            Application ID (required)
     * @param grantId
     *            Grant ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeScopeConsentGrant(String appId, String grantId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling revokeScopeConsentGrant");
        }

        // verify the required parameter 'grantId' is set
        if (grantId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'grantId' when calling revokeScopeConsentGrant");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/grants/{grantId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "grantId" + "\\}", apiClient.escapeString(grantId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
