/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.AppUser;
import com.okta.sdk.resource.model.AppUserAssignRequest;
import com.okta.sdk.resource.model.AppUserUpdateRequest;
import com.okta.sdk.resource.model.Error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ApplicationUsersApi {

    private ApiClient apiClient;

    public ApplicationUsersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationUsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Assign an Application User Assigns a user to an app for: * SSO only&lt;br&gt; Assignments to SSO apps typically
     * don&#39;t include a user profile. However, if your SSO app requires a profile but doesn&#39;t have provisioning
     * enabled, you can add profile attributes in the request body. * SSO and provisioning&lt;br&gt; Assignments to SSO
     * and provisioning apps typically include credentials and an app-specific profile. Profile mappings defined for the
     * app are applied first before applying any profile properties that are specified in the request body. &gt;
     * **Notes:** &gt; * When Universal Directory is enabled, you can only specify profile properties that aren&#39;t
     * defined in profile mappings. &gt; * Omit mapped properties during assignment to minimize assignment errors.
     *
     * @param appId
     *            Application ID (required)
     * @param appUser
     *            (required)
     *
     * @return AppUser
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AppUser assignUserToApplication(String appId, AppUserAssignRequest appUser) throws ApiException {
        return this.assignUserToApplication(appId, appUser, Collections.emptyMap());
    }

    /**
     * Assign an Application User Assigns a user to an app for: * SSO only&lt;br&gt; Assignments to SSO apps typically
     * don&#39;t include a user profile. However, if your SSO app requires a profile but doesn&#39;t have provisioning
     * enabled, you can add profile attributes in the request body. * SSO and provisioning&lt;br&gt; Assignments to SSO
     * and provisioning apps typically include credentials and an app-specific profile. Profile mappings defined for the
     * app are applied first before applying any profile properties that are specified in the request body. &gt;
     * **Notes:** &gt; * When Universal Directory is enabled, you can only specify profile properties that aren&#39;t
     * defined in profile mappings. &gt; * Omit mapped properties during assignment to minimize assignment errors.
     *
     * @param appId
     *            Application ID (required)
     * @param appUser
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AppUser
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AppUser assignUserToApplication(String appId, AppUserAssignRequest appUser,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = appUser;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling assignUserToApplication");
        }

        // verify the required parameter 'appUser' is set
        if (appUser == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appUser' when calling assignUserToApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/users".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AppUser> localVarReturnType = new TypeReference<AppUser>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve an Application User Retrieves a specific user assignment for a specific app
     *
     * @param appId
     *            Application ID (required)
     * @param userId
     *            ID of an existing Okta user (required)
     * @param expand
     *            An optional query parameter to return the corresponding
     *            [User](/openapi/okta-management/management/tag/User/) object in the &#x60;_embedded&#x60; property.
     *            Valid value: &#x60;user&#x60; (optional)
     *
     * @return AppUser
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AppUser getApplicationUser(String appId, String userId, String expand) throws ApiException {
        return this.getApplicationUser(appId, userId, expand, Collections.emptyMap());
    }

    /**
     * Retrieve an Application User Retrieves a specific user assignment for a specific app
     *
     * @param appId
     *            Application ID (required)
     * @param userId
     *            ID of an existing Okta user (required)
     * @param expand
     *            An optional query parameter to return the corresponding
     *            [User](/openapi/okta-management/management/tag/User/) object in the &#x60;_embedded&#x60; property.
     *            Valid value: &#x60;user&#x60; (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AppUser
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AppUser getApplicationUser(String appId, String userId, String expand, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getApplicationUser");
        }

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getApplicationUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/users/{userId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AppUser> localVarReturnType = new TypeReference<AppUser>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Application Users Lists all assigned users for an app
     *
     * @param appId
     *            Application ID (required)
     * @param after
     *            Specifies the pagination cursor for the next page of results. Treat this as an opaque value obtained
     *            through the next link relationship. See [Pagination](/#pagination). (optional)
     * @param limit
     *            Specifies the number of objects to return per page. If there are multiple pages of results, the Link
     *            header contains a &#x60;next&#x60; link that you need to use as an opaque value (follow it, don&#39;t
     *            parse it). See [Pagination](/#pagination). (optional, default to 50)
     * @param q
     *            Specifies a filter for the list of Application Users returned based on their profile attributes. The
     *            value of &#x60;q&#x60; is matched against the beginning of the following profile attributes:
     *            &#x60;userName&#x60;, &#x60;firstName&#x60;, &#x60;lastName&#x60;, and &#x60;email&#x60;. This filter
     *            only supports the &#x60;startsWith&#x60; operation that matches the &#x60;q&#x60; string against the
     *            beginning of the attribute values. &gt; **Note:** For OIDC apps, user profiles don&#39;t contain the
     *            &#x60;firstName&#x60; or &#x60;lastName&#x60; attributes. Therefore, the query only matches against
     *            the &#x60;userName&#x60; or &#x60;email&#x60; attributes. (optional)
     * @param expand
     *            An optional query parameter to return the corresponding
     *            [User](/openapi/okta-management/management/tag/User/) object in the &#x60;_embedded&#x60; property.
     *            Valid value: &#x60;user&#x60; (optional)
     *
     * @return List&lt;AppUser&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AppUser> listApplicationUsers(String appId, String after, Integer limit, String q, String expand)
            throws ApiException {
        return this.listApplicationUsers(appId, after, limit, q, expand, Collections.emptyMap());
    }

    /**
     * List all Application Users Lists all assigned users for an app
     *
     * @param appId
     *            Application ID (required)
     * @param after
     *            Specifies the pagination cursor for the next page of results. Treat this as an opaque value obtained
     *            through the next link relationship. See [Pagination](/#pagination). (optional)
     * @param limit
     *            Specifies the number of objects to return per page. If there are multiple pages of results, the Link
     *            header contains a &#x60;next&#x60; link that you need to use as an opaque value (follow it, don&#39;t
     *            parse it). See [Pagination](/#pagination). (optional, default to 50)
     * @param q
     *            Specifies a filter for the list of Application Users returned based on their profile attributes. The
     *            value of &#x60;q&#x60; is matched against the beginning of the following profile attributes:
     *            &#x60;userName&#x60;, &#x60;firstName&#x60;, &#x60;lastName&#x60;, and &#x60;email&#x60;. This filter
     *            only supports the &#x60;startsWith&#x60; operation that matches the &#x60;q&#x60; string against the
     *            beginning of the attribute values. &gt; **Note:** For OIDC apps, user profiles don&#39;t contain the
     *            &#x60;firstName&#x60; or &#x60;lastName&#x60; attributes. Therefore, the query only matches against
     *            the &#x60;userName&#x60; or &#x60;email&#x60; attributes. (optional)
     * @param expand
     *            An optional query parameter to return the corresponding
     *            [User](/openapi/okta-management/management/tag/User/) object in the &#x60;_embedded&#x60; property.
     *            Valid value: &#x60;user&#x60; (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;AppUser&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AppUser> listApplicationUsers(String appId, String after, Integer limit, String q, String expand,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listApplicationUsers");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/users".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<AppUser>> localVarReturnType = new TypeReference<List<AppUser>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Unassign an Application User Unassigns a user from an app For directories like Active Directory and LDAP, they
     * act as the owner of the user&#39;s credential with Okta delegating authentication (DelAuth) to that directory. If
     * this request is successful for a user when DelAuth is enabled, then the user is in a state with no password. You
     * can then reset the user&#39;s password. &gt; **Important:** This is a destructive operation. You can&#39;t
     * recover the user&#39;s app profile. If the app is enabled for provisioning and configured to deactivate users,
     * the user is also deactivated in the target app.
     *
     * @param appId
     *            Application ID (required)
     * @param userId
     *            ID of an existing Okta user (required)
     * @param sendEmail
     *            Sends a deactivation email to the administrator if &#x60;true&#x60; (optional, default to false)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignUserFromApplication(String appId, String userId, Boolean sendEmail) throws ApiException {
        this.unassignUserFromApplication(appId, userId, sendEmail, Collections.emptyMap());
    }

    /**
     * Unassign an Application User Unassigns a user from an app For directories like Active Directory and LDAP, they
     * act as the owner of the user&#39;s credential with Okta delegating authentication (DelAuth) to that directory. If
     * this request is successful for a user when DelAuth is enabled, then the user is in a state with no password. You
     * can then reset the user&#39;s password. &gt; **Important:** This is a destructive operation. You can&#39;t
     * recover the user&#39;s app profile. If the app is enabled for provisioning and configured to deactivate users,
     * the user is also deactivated in the target app.
     *
     * @param appId
     *            Application ID (required)
     * @param userId
     *            ID of an existing Okta user (required)
     * @param sendEmail
     *            Sends a deactivation email to the administrator if &#x60;true&#x60; (optional, default to false)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignUserFromApplication(String appId, String userId, Boolean sendEmail,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling unassignUserFromApplication");
        }

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling unassignUserFromApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/users/{userId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("sendEmail", sendEmail));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Update an Application User Updates the profile or credentials of a user assigned to an app
     *
     * @param appId
     *            Application ID (required)
     * @param userId
     *            ID of an existing Okta user (required)
     * @param appUser
     *            (required)
     *
     * @return AppUser
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AppUser updateApplicationUser(String appId, String userId, AppUserUpdateRequest appUser)
            throws ApiException {
        return this.updateApplicationUser(appId, userId, appUser, Collections.emptyMap());
    }

    /**
     * Update an Application User Updates the profile or credentials of a user assigned to an app
     *
     * @param appId
     *            Application ID (required)
     * @param userId
     *            ID of an existing Okta user (required)
     * @param appUser
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AppUser
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AppUser updateApplicationUser(String appId, String userId, AppUserUpdateRequest appUser,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = appUser;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling updateApplicationUser");
        }

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateApplicationUser");
        }

        // verify the required parameter 'appUser' is set
        if (appUser == null) {
            throw new ApiException(400, "Missing the required parameter 'appUser' when calling updateApplicationUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/users/{userId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AppUser> localVarReturnType = new TypeReference<AppUser>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
