/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.AssociatedServerMediated;
import com.okta.sdk.resource.model.AuthorizationServer;
import com.okta.sdk.resource.model.Error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class AuthorizationServerAssocApi {

    private ApiClient apiClient;

    public AuthorizationServerAssocApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationServerAssocApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create an associated Authorization Server Creates trusted relationships between the given authorization server
     * and other authorization servers
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param associatedServerMediated
     *            (required)
     *
     * @return List&lt;AuthorizationServer&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthorizationServer> createAssociatedServers(String authServerId,
            AssociatedServerMediated associatedServerMediated) throws ApiException {
        return this.createAssociatedServers(authServerId, associatedServerMediated, Collections.emptyMap());
    }

    /**
     * Create an associated Authorization Server Creates trusted relationships between the given authorization server
     * and other authorization servers
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param associatedServerMediated
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;AuthorizationServer&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthorizationServer> createAssociatedServers(String authServerId,
            AssociatedServerMediated associatedServerMediated, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = associatedServerMediated;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling createAssociatedServers");
        }

        // verify the required parameter 'associatedServerMediated' is set
        if (associatedServerMediated == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'associatedServerMediated' when calling createAssociatedServers");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/associatedServers"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<AuthorizationServer>> localVarReturnType = new TypeReference<List<AuthorizationServer>>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete an associated Authorization Server Deletes an associated Authorization Server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param associatedServerId
     *            &#x60;id&#x60; of the associated Authorization Server (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteAssociatedServer(String authServerId, String associatedServerId) throws ApiException {
        this.deleteAssociatedServer(authServerId, associatedServerId, Collections.emptyMap());
    }

    /**
     * Delete an associated Authorization Server Deletes an associated Authorization Server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param associatedServerId
     *            &#x60;id&#x60; of the associated Authorization Server (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteAssociatedServer(String authServerId, String associatedServerId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling deleteAssociatedServer");
        }

        // verify the required parameter 'associatedServerId' is set
        if (associatedServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'associatedServerId' when calling deleteAssociatedServer");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/associatedServers/{associatedServerId}"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString())).replaceAll(
                        "\\{" + "associatedServerId" + "\\}", apiClient.escapeString(associatedServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * List all associated Authorization Servers Lists all associated Authorization Servers by trusted type for the
     * given &#x60;authServerId&#x60;
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param trusted
     *            Searches trusted authorization servers when &#x60;true&#x60; or searches untrusted authorization
     *            servers when &#x60;false&#x60; (optional)
     * @param q
     *            Searches for the name or audience of the associated authorization servers (optional)
     * @param limit
     *            Specifies the number of results for a page (optional, default to 200)
     * @param after
     *            Specifies the pagination cursor for the next page of the associated authorization servers (optional)
     *
     * @return List&lt;AuthorizationServer&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthorizationServer> listAssociatedServersByTrustedType(String authServerId, Boolean trusted, String q,
            Integer limit, String after) throws ApiException {
        return this.listAssociatedServersByTrustedType(authServerId, trusted, q, limit, after, Collections.emptyMap());
    }

    /**
     * List all associated Authorization Servers Lists all associated Authorization Servers by trusted type for the
     * given &#x60;authServerId&#x60;
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param trusted
     *            Searches trusted authorization servers when &#x60;true&#x60; or searches untrusted authorization
     *            servers when &#x60;false&#x60; (optional)
     * @param q
     *            Searches for the name or audience of the associated authorization servers (optional)
     * @param limit
     *            Specifies the number of results for a page (optional, default to 200)
     * @param after
     *            Specifies the pagination cursor for the next page of the associated authorization servers (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;AuthorizationServer&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthorizationServer> listAssociatedServersByTrustedType(String authServerId, Boolean trusted, String q,
            Integer limit, String after, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling listAssociatedServersByTrustedType");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/associatedServers"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("trusted", trusted));
        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<AuthorizationServer>> localVarReturnType = new TypeReference<List<AuthorizationServer>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
