/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.OAuth2Scope;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class AuthorizationServerScopesApi {

    private ApiClient apiClient;

    public AuthorizationServerScopesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationServerScopesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a Custom Token Scope Creates a custom token scope
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param oAuth2Scope
     *            (required)
     *
     * @return OAuth2Scope
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2Scope createOAuth2Scope(String authServerId, OAuth2Scope oAuth2Scope) throws ApiException {
        return this.createOAuth2Scope(authServerId, oAuth2Scope, Collections.emptyMap());
    }

    /**
     * Create a Custom Token Scope Creates a custom token scope
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param oAuth2Scope
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2Scope
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2Scope createOAuth2Scope(String authServerId, OAuth2Scope oAuth2Scope,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = oAuth2Scope;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling createOAuth2Scope");
        }

        // verify the required parameter 'oAuth2Scope' is set
        if (oAuth2Scope == null) {
            throw new ApiException(400, "Missing the required parameter 'oAuth2Scope' when calling createOAuth2Scope");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/scopes"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2Scope> localVarReturnType = new TypeReference<OAuth2Scope>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Custom Token Scope Deletes a custom token scope
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param scopeId
     *            &#x60;id&#x60; of Scope (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteOAuth2Scope(String authServerId, String scopeId) throws ApiException {
        this.deleteOAuth2Scope(authServerId, scopeId, Collections.emptyMap());
    }

    /**
     * Delete a Custom Token Scope Deletes a custom token scope
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param scopeId
     *            &#x60;id&#x60; of Scope (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteOAuth2Scope(String authServerId, String scopeId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deleteOAuth2Scope");
        }

        // verify the required parameter 'scopeId' is set
        if (scopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'scopeId' when calling deleteOAuth2Scope");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "scopeId" + "\\}", apiClient.escapeString(scopeId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Custom Token Scope Retrieves a custom token scope
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param scopeId
     *            &#x60;id&#x60; of Scope (required)
     *
     * @return OAuth2Scope
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2Scope getOAuth2Scope(String authServerId, String scopeId) throws ApiException {
        return this.getOAuth2Scope(authServerId, scopeId, Collections.emptyMap());
    }

    /**
     * Retrieve a Custom Token Scope Retrieves a custom token scope
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param scopeId
     *            &#x60;id&#x60; of Scope (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2Scope
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2Scope getOAuth2Scope(String authServerId, String scopeId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling getOAuth2Scope");
        }

        // verify the required parameter 'scopeId' is set
        if (scopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'scopeId' when calling getOAuth2Scope");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "scopeId" + "\\}", apiClient.escapeString(scopeId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2Scope> localVarReturnType = new TypeReference<OAuth2Scope>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Custom Token Scopes Lists all custom token scopes
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param q
     *            Searches the &#x60;name&#x60; of Custom Token Scopes for matching values (optional)
     * @param filter
     *            Filter expression for Custom Token Scopes (optional)
     * @param after
     *            Specifies the pagination cursor for the next page of scopes. Treat the after cursor as an opaque value
     *            and obtain it through the next link relationship. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            Specifies the number of objects to return per page. If there are multiple pages of results, the Link
     *            header contains a &#x60;next&#x60; link that you need to use as an opaque value (follow it, don&#39;t
     *            parse it). See [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     *
     * @return List&lt;OAuth2Scope&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2Scope> listOAuth2Scopes(String authServerId, String q, String filter, String after, Integer limit)
            throws ApiException {
        return this.listOAuth2Scopes(authServerId, q, filter, after, limit, Collections.emptyMap());
    }

    /**
     * List all Custom Token Scopes Lists all custom token scopes
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param q
     *            Searches the &#x60;name&#x60; of Custom Token Scopes for matching values (optional)
     * @param filter
     *            Filter expression for Custom Token Scopes (optional)
     * @param after
     *            Specifies the pagination cursor for the next page of scopes. Treat the after cursor as an opaque value
     *            and obtain it through the next link relationship. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            Specifies the number of objects to return per page. If there are multiple pages of results, the Link
     *            header contains a &#x60;next&#x60; link that you need to use as an opaque value (follow it, don&#39;t
     *            parse it). See [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;OAuth2Scope&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2Scope> listOAuth2Scopes(String authServerId, String q, String filter, String after, Integer limit,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling listOAuth2Scopes");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/scopes"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<OAuth2Scope>> localVarReturnType = new TypeReference<List<OAuth2Scope>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Custom Token Scope Replaces a custom token scope
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param scopeId
     *            &#x60;id&#x60; of Scope (required)
     * @param oAuth2Scope
     *            (required)
     *
     * @return OAuth2Scope
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2Scope replaceOAuth2Scope(String authServerId, String scopeId, OAuth2Scope oAuth2Scope)
            throws ApiException {
        return this.replaceOAuth2Scope(authServerId, scopeId, oAuth2Scope, Collections.emptyMap());
    }

    /**
     * Replace a Custom Token Scope Replaces a custom token scope
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param scopeId
     *            &#x60;id&#x60; of Scope (required)
     * @param oAuth2Scope
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2Scope
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2Scope replaceOAuth2Scope(String authServerId, String scopeId, OAuth2Scope oAuth2Scope,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = oAuth2Scope;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling replaceOAuth2Scope");
        }

        // verify the required parameter 'scopeId' is set
        if (scopeId == null) {
            throw new ApiException(400, "Missing the required parameter 'scopeId' when calling replaceOAuth2Scope");
        }

        // verify the required parameter 'oAuth2Scope' is set
        if (oAuth2Scope == null) {
            throw new ApiException(400, "Missing the required parameter 'oAuth2Scope' when calling replaceOAuth2Scope");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/scopes/{scopeId}"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()))
                .replaceAll("\\{" + "scopeId" + "\\}", apiClient.escapeString(scopeId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2Scope> localVarReturnType = new TypeReference<OAuth2Scope>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
