/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.Feature;
import com.okta.sdk.resource.model.FeatureLifecycle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class FeatureApi {

    private ApiClient apiClient;

    public FeatureApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FeatureApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve a Feature Retrieves a feature by ID
     *
     * @param featureId
     *            &#x60;id&#x60; of the feature (required)
     *
     * @return Feature
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Feature getFeature(String featureId) throws ApiException {
        return this.getFeature(featureId, Collections.emptyMap());
    }

    /**
     * Retrieve a Feature Retrieves a feature by ID
     *
     * @param featureId
     *            &#x60;id&#x60; of the feature (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Feature
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Feature getFeature(String featureId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'featureId' is set
        if (featureId == null) {
            throw new ApiException(400, "Missing the required parameter 'featureId' when calling getFeature");
        }

        // create path and map variables
        String localVarPath = "/api/v1/features/{featureId}".replaceAll("\\{" + "featureId" + "\\}",
                apiClient.escapeString(featureId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Feature> localVarReturnType = new TypeReference<Feature>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all dependencies Lists all feature dependencies for a specified feature. A feature&#39;s dependencies are
     * the features that it requires to be enabled in order for itself to be enabled.
     *
     * @param featureId
     *            &#x60;id&#x60; of the feature (required)
     *
     * @return List&lt;Feature&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Feature> listFeatureDependencies(String featureId) throws ApiException {
        return this.listFeatureDependencies(featureId, Collections.emptyMap());
    }

    /**
     * List all dependencies Lists all feature dependencies for a specified feature. A feature&#39;s dependencies are
     * the features that it requires to be enabled in order for itself to be enabled.
     *
     * @param featureId
     *            &#x60;id&#x60; of the feature (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;Feature&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Feature> listFeatureDependencies(String featureId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'featureId' is set
        if (featureId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'featureId' when calling listFeatureDependencies");
        }

        // create path and map variables
        String localVarPath = "/api/v1/features/{featureId}/dependencies".replaceAll("\\{" + "featureId" + "\\}",
                apiClient.escapeString(featureId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<Feature>> localVarReturnType = new TypeReference<List<Feature>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all dependents Lists all feature dependents for the specified feature. A feature&#39;s dependents are the
     * features that need to be disabled in order for the feature itself to be disabled.
     *
     * @param featureId
     *            &#x60;id&#x60; of the feature (required)
     *
     * @return List&lt;Feature&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Feature> listFeatureDependents(String featureId) throws ApiException {
        return this.listFeatureDependents(featureId, Collections.emptyMap());
    }

    /**
     * List all dependents Lists all feature dependents for the specified feature. A feature&#39;s dependents are the
     * features that need to be disabled in order for the feature itself to be disabled.
     *
     * @param featureId
     *            &#x60;id&#x60; of the feature (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;Feature&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Feature> listFeatureDependents(String featureId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'featureId' is set
        if (featureId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'featureId' when calling listFeatureDependents");
        }

        // create path and map variables
        String localVarPath = "/api/v1/features/{featureId}/dependents".replaceAll("\\{" + "featureId" + "\\}",
                apiClient.escapeString(featureId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<Feature>> localVarReturnType = new TypeReference<List<Feature>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Features Lists all self-service features for your org
     *
     * @return List&lt;Feature&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Feature> listFeatures() throws ApiException {
        return this.listFeatures(Collections.emptyMap());
    }

    /**
     * List all Features Lists all self-service features for your org
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;Feature&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Feature> listFeatures(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/features";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<Feature>> localVarReturnType = new TypeReference<List<Feature>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update a Feature lifecycle Updates a feature&#39;s lifecycle status. Use this endpoint to enable or disable a
     * feature for your org. Use the &#x60;mode&#x3D;force&#x60; parameter to override dependency restrictions for a
     * particular feature. Normally, you can&#39;t enable a feature if it has one or more dependencies that aren&#39;t
     * enabled. When you use the &#x60;mode&#x3D;force&#x60; parameter while enabling a feature, Okta first tries to
     * enable any disabled features that this feature may have as dependencies. If you don&#39;t pass the
     * &#x60;mode&#x3D;force&#x60; parameter and the feature has dependencies that need to be enabled before the feature
     * is enabled, a 400 error is returned. When you use the &#x60;mode&#x3D;force&#x60; parameter while disabling a
     * feature, Okta first tries to disable any enabled features that this feature may have as dependents. If you
     * don&#39;t pass the &#x60;mode&#x3D;force&#x60; parameter and the feature has dependents that need to be disabled
     * before the feature is disabled, a 400 error is returned. The following chart shows the different state
     * transitions for a feature. ![State transitions of a
     * feature](../../../../../images/features/update-ssfeat-flowchart.png &#39;#width&#x3D;500px;&#39;)
     *
     * @param featureId
     *            &#x60;id&#x60; of the feature (required)
     * @param lifecycle
     *            Whether to &#x60;ENABLE&#x60; or &#x60;DISABLE&#x60; the feature (required)
     * @param mode
     *            Indicates if you want to force enable or disable a feature. Supported value is &#x60;force&#x60;.
     *            (optional)
     *
     * @return Feature
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Feature updateFeatureLifecycle(String featureId, FeatureLifecycle lifecycle, String mode)
            throws ApiException {
        return this.updateFeatureLifecycle(featureId, lifecycle, mode, Collections.emptyMap());
    }

    /**
     * Update a Feature lifecycle Updates a feature&#39;s lifecycle status. Use this endpoint to enable or disable a
     * feature for your org. Use the &#x60;mode&#x3D;force&#x60; parameter to override dependency restrictions for a
     * particular feature. Normally, you can&#39;t enable a feature if it has one or more dependencies that aren&#39;t
     * enabled. When you use the &#x60;mode&#x3D;force&#x60; parameter while enabling a feature, Okta first tries to
     * enable any disabled features that this feature may have as dependencies. If you don&#39;t pass the
     * &#x60;mode&#x3D;force&#x60; parameter and the feature has dependencies that need to be enabled before the feature
     * is enabled, a 400 error is returned. When you use the &#x60;mode&#x3D;force&#x60; parameter while disabling a
     * feature, Okta first tries to disable any enabled features that this feature may have as dependents. If you
     * don&#39;t pass the &#x60;mode&#x3D;force&#x60; parameter and the feature has dependents that need to be disabled
     * before the feature is disabled, a 400 error is returned. The following chart shows the different state
     * transitions for a feature. ![State transitions of a
     * feature](../../../../../images/features/update-ssfeat-flowchart.png &#39;#width&#x3D;500px;&#39;)
     *
     * @param featureId
     *            &#x60;id&#x60; of the feature (required)
     * @param lifecycle
     *            Whether to &#x60;ENABLE&#x60; or &#x60;DISABLE&#x60; the feature (required)
     * @param mode
     *            Indicates if you want to force enable or disable a feature. Supported value is &#x60;force&#x60;.
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Feature
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Feature updateFeatureLifecycle(String featureId, FeatureLifecycle lifecycle, String mode,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'featureId' is set
        if (featureId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'featureId' when calling updateFeatureLifecycle");
        }

        // verify the required parameter 'lifecycle' is set
        if (lifecycle == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'lifecycle' when calling updateFeatureLifecycle");
        }

        // create path and map variables
        String localVarPath = "/api/v1/features/{featureId}/{lifecycle}"
                .replaceAll("\\{" + "featureId" + "\\}", apiClient.escapeString(featureId.toString()))
                .replaceAll("\\{" + "lifecycle" + "\\}", apiClient.escapeString(lifecycle.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("mode", mode));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Feature> localVarReturnType = new TypeReference<Feature>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
