/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.CreateGroupRuleRequest;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.GroupRule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class GroupRuleApi {

    private ApiClient apiClient;

    public GroupRuleApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GroupRuleApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate a Group Rule Activates a specific Group rule by ID from your org
     *
     * @param groupRuleId
     *            The &#x60;id&#x60; of the group rule (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void activateGroupRule(String groupRuleId) throws ApiException {
        this.activateGroupRule(groupRuleId, Collections.emptyMap());
    }

    /**
     * Activate a Group Rule Activates a specific Group rule by ID from your org
     *
     * @param groupRuleId
     *            The &#x60;id&#x60; of the group rule (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void activateGroupRule(String groupRuleId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'groupRuleId' is set
        if (groupRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupRuleId' when calling activateGroupRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/rules/{groupRuleId}/lifecycle/activate"
                .replaceAll("\\{" + "groupRuleId" + "\\}", apiClient.escapeString(groupRuleId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Create a Group rule Creates a Group rule to dynamically add Users to the specified Group if they match the
     * condition &gt; **Note:** Group rules are created with the status set to &#x60;&#39;INACTIVE&#39;&#x60;.
     *
     * @param groupRule
     *            (required)
     *
     * @return GroupRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public GroupRule createGroupRule(CreateGroupRuleRequest groupRule) throws ApiException {
        return this.createGroupRule(groupRule, Collections.emptyMap());
    }

    /**
     * Create a Group rule Creates a Group rule to dynamically add Users to the specified Group if they match the
     * condition &gt; **Note:** Group rules are created with the status set to &#x60;&#39;INACTIVE&#39;&#x60;.
     *
     * @param groupRule
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return GroupRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public GroupRule createGroupRule(CreateGroupRuleRequest groupRule, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = groupRule;

        // verify the required parameter 'groupRule' is set
        if (groupRule == null) {
            throw new ApiException(400, "Missing the required parameter 'groupRule' when calling createGroupRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/rules";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<GroupRule> localVarReturnType = new TypeReference<GroupRule>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate a Group Rule Deactivates a specific Group rule by ID from your org
     *
     * @param groupRuleId
     *            The &#x60;id&#x60; of the group rule (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateGroupRule(String groupRuleId) throws ApiException {
        this.deactivateGroupRule(groupRuleId, Collections.emptyMap());
    }

    /**
     * Deactivate a Group Rule Deactivates a specific Group rule by ID from your org
     *
     * @param groupRuleId
     *            The &#x60;id&#x60; of the group rule (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateGroupRule(String groupRuleId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'groupRuleId' is set
        if (groupRuleId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'groupRuleId' when calling deactivateGroupRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/rules/{groupRuleId}/lifecycle/deactivate"
                .replaceAll("\\{" + "groupRuleId" + "\\}", apiClient.escapeString(groupRuleId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Delete a Group Rule Deletes a specific group rule by &#x60;groupRuleId&#x60;
     *
     * @param groupRuleId
     *            The &#x60;id&#x60; of the group rule (required)
     * @param removeUsers
     *            If set to &#x60;true&#x60;, removes Users from Groups assigned by this rule (optional, default to
     *            false)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteGroupRule(String groupRuleId, Boolean removeUsers) throws ApiException {
        this.deleteGroupRule(groupRuleId, removeUsers, Collections.emptyMap());
    }

    /**
     * Delete a Group Rule Deletes a specific group rule by &#x60;groupRuleId&#x60;
     *
     * @param groupRuleId
     *            The &#x60;id&#x60; of the group rule (required)
     * @param removeUsers
     *            If set to &#x60;true&#x60;, removes Users from Groups assigned by this rule (optional, default to
     *            false)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteGroupRule(String groupRuleId, Boolean removeUsers, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'groupRuleId' is set
        if (groupRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupRuleId' when calling deleteGroupRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/rules/{groupRuleId}".replaceAll("\\{" + "groupRuleId" + "\\}",
                apiClient.escapeString(groupRuleId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("removeUsers", removeUsers));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Group rule Retrieves a specific Group rule by ID from your org
     *
     * @param groupRuleId
     *            The &#x60;id&#x60; of the group rule (required)
     * @param expand
     *            If specified as &#x60;groupIdToGroupNameMap&#x60;, then show Group names (optional)
     *
     * @return GroupRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public GroupRule getGroupRule(String groupRuleId, String expand) throws ApiException {
        return this.getGroupRule(groupRuleId, expand, Collections.emptyMap());
    }

    /**
     * Retrieve a Group rule Retrieves a specific Group rule by ID from your org
     *
     * @param groupRuleId
     *            The &#x60;id&#x60; of the group rule (required)
     * @param expand
     *            If specified as &#x60;groupIdToGroupNameMap&#x60;, then show Group names (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return GroupRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public GroupRule getGroupRule(String groupRuleId, String expand, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'groupRuleId' is set
        if (groupRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupRuleId' when calling getGroupRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/rules/{groupRuleId}".replaceAll("\\{" + "groupRuleId" + "\\}",
                apiClient.escapeString(groupRuleId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<GroupRule> localVarReturnType = new TypeReference<GroupRule>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Group rules Lists all Group rules for your org
     *
     * @param limit
     *            Specifies the number of rule results in a page (optional, default to 50)
     * @param after
     *            Specifies the pagination cursor for the next page of rules (optional)
     * @param search
     *            Specifies the keyword to search rules for (optional)
     * @param expand
     *            If specified as &#x60;groupIdToGroupNameMap&#x60;, then displays group names (optional)
     *
     * @return List&lt;GroupRule&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<GroupRule> listGroupRules(Integer limit, String after, String search, String expand)
            throws ApiException {
        return this.listGroupRules(limit, after, search, expand, Collections.emptyMap());
    }

    /**
     * List all Group rules Lists all Group rules for your org
     *
     * @param limit
     *            Specifies the number of rule results in a page (optional, default to 50)
     * @param after
     *            Specifies the pagination cursor for the next page of rules (optional)
     * @param search
     *            Specifies the keyword to search rules for (optional)
     * @param expand
     *            If specified as &#x60;groupIdToGroupNameMap&#x60;, then displays group names (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;GroupRule&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<GroupRule> listGroupRules(Integer limit, String after, String search, String expand,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/groups/rules";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("search", search));
        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<GroupRule>> localVarReturnType = new TypeReference<List<GroupRule>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Group rule Replaces a Group rule &gt; **Notes:** You only can update rules with a Group whose status is
     * set to &#x60;&#39;INACTIVE&#39;&#x60;. &gt; &gt; You currently can&#39;t update the &#x60;action&#x60; section.
     *
     * @param groupRuleId
     *            The &#x60;id&#x60; of the group rule (required)
     * @param groupRule
     *            (required)
     *
     * @return GroupRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public GroupRule replaceGroupRule(String groupRuleId, GroupRule groupRule) throws ApiException {
        return this.replaceGroupRule(groupRuleId, groupRule, Collections.emptyMap());
    }

    /**
     * Replace a Group rule Replaces a Group rule &gt; **Notes:** You only can update rules with a Group whose status is
     * set to &#x60;&#39;INACTIVE&#39;&#x60;. &gt; &gt; You currently can&#39;t update the &#x60;action&#x60; section.
     *
     * @param groupRuleId
     *            The &#x60;id&#x60; of the group rule (required)
     * @param groupRule
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return GroupRule
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public GroupRule replaceGroupRule(String groupRuleId, GroupRule groupRule, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = groupRule;

        // verify the required parameter 'groupRuleId' is set
        if (groupRuleId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupRuleId' when calling replaceGroupRule");
        }

        // verify the required parameter 'groupRule' is set
        if (groupRule == null) {
            throw new ApiException(400, "Missing the required parameter 'groupRule' when calling replaceGroupRule");
        }

        // create path and map variables
        String localVarPath = "/api/v1/groups/rules/{groupRuleId}".replaceAll("\\{" + "groupRuleId" + "\\}",
                apiClient.escapeString(groupRuleId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<GroupRule> localVarReturnType = new TypeReference<GroupRule>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
