/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.CsrMetadata;
import com.okta.sdk.resource.model.Error;
import java.io.File;
import com.okta.sdk.resource.model.IdPCsr;
import com.okta.sdk.resource.model.IdPKeyCredential;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class IdentityProviderSigningKeysApi {

    private ApiClient apiClient;

    public IdentityProviderSigningKeysApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IdentityProviderSigningKeysApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Clone a signing Key Credential for IdP Clones an X.509 certificate for an IdP signing Key Credential from a
     * source IdP to target IdP &gt; **Caution:** Sharing certificates isn&#39;t a recommended security practice. &gt;
     * **Note:** If the key is already present in the list of Key Credentials for the target IdP, you receive a 400
     * error response.
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param kid
     *            Unique &#x60;id&#x60; of the IdP Key Credential (required)
     * @param targetIdpId
     *            &#x60;id&#x60; of the target IdP (required)
     *
     * @return IdPKeyCredential
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPKeyCredential cloneIdentityProviderKey(String idpId, String kid, String targetIdpId) throws ApiException {
        return this.cloneIdentityProviderKey(idpId, kid, targetIdpId, Collections.emptyMap());
    }

    /**
     * Clone a signing Key Credential for IdP Clones an X.509 certificate for an IdP signing Key Credential from a
     * source IdP to target IdP &gt; **Caution:** Sharing certificates isn&#39;t a recommended security practice. &gt;
     * **Note:** If the key is already present in the list of Key Credentials for the target IdP, you receive a 400
     * error response.
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param kid
     *            Unique &#x60;id&#x60; of the IdP Key Credential (required)
     * @param targetIdpId
     *            &#x60;id&#x60; of the target IdP (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdPKeyCredential
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPKeyCredential cloneIdentityProviderKey(String idpId, String kid, String targetIdpId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling cloneIdentityProviderKey");
        }

        // verify the required parameter 'kid' is set
        if (kid == null) {
            throw new ApiException(400, "Missing the required parameter 'kid' when calling cloneIdentityProviderKey");
        }

        // verify the required parameter 'targetIdpId' is set
        if (targetIdpId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'targetIdpId' when calling cloneIdentityProviderKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}/credentials/keys/{kid}/clone"
                .replaceAll("\\{" + "idpId" + "\\}", apiClient.escapeString(idpId.toString()))
                .replaceAll("\\{" + "kid" + "\\}", apiClient.escapeString(kid.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("targetIdpId", targetIdpId));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdPKeyCredential> localVarReturnType = new TypeReference<IdPKeyCredential>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Generate a Certificate Signing Request Generates a new key pair and returns a Certificate Signing Request (CSR)
     * for it &gt; **Note:** The private key isn&#39;t listed in the [Signing Key Credentials for
     * IdP](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProviderSigningKeys/#tag/IdentityProviderSigningKeys/operation/listIdentityProviderSigningKeys)
     * until it&#39;s published.
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param metadata
     *            (required)
     *
     * @return IdPCsr
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPCsr generateCsrForIdentityProvider(String idpId, CsrMetadata metadata) throws ApiException {
        return this.generateCsrForIdentityProvider(idpId, metadata, Collections.emptyMap());
    }

    /**
     * Generate a Certificate Signing Request Generates a new key pair and returns a Certificate Signing Request (CSR)
     * for it &gt; **Note:** The private key isn&#39;t listed in the [Signing Key Credentials for
     * IdP](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProviderSigningKeys/#tag/IdentityProviderSigningKeys/operation/listIdentityProviderSigningKeys)
     * until it&#39;s published.
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param metadata
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdPCsr
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPCsr generateCsrForIdentityProvider(String idpId, CsrMetadata metadata,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = metadata;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idpId' when calling generateCsrForIdentityProvider");
        }

        // verify the required parameter 'metadata' is set
        if (metadata == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'metadata' when calling generateCsrForIdentityProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}/credentials/csrs".replaceAll("\\{" + "idpId" + "\\}",
                apiClient.escapeString(idpId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json", "application/pkcs10" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdPCsr> localVarReturnType = new TypeReference<IdPCsr>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Generate a new signing Key Credential for IdP Generates a new X.509 certificate for an IdP signing Key Credential
     * to be used for signing assertions sent to the IdP. IdP signing keys are read-only. &gt; **Note:** To update an
     * IdP with the newly generated Key Credential, [update your
     * IdP](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/replaceIdentityProvider)
     * using the returned key&#39;s &#x60;kid&#x60; in the [signing
     * credential](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/replaceIdentityProvider!path&#x3D;protocol/0/credentials/signing/kid&amp;t&#x3D;request).
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param validityYears
     *            expiry of the IdP Key Credential (required)
     *
     * @return IdPKeyCredential
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPKeyCredential generateIdentityProviderSigningKey(String idpId, Integer validityYears)
            throws ApiException {
        return this.generateIdentityProviderSigningKey(idpId, validityYears, Collections.emptyMap());
    }

    /**
     * Generate a new signing Key Credential for IdP Generates a new X.509 certificate for an IdP signing Key Credential
     * to be used for signing assertions sent to the IdP. IdP signing keys are read-only. &gt; **Note:** To update an
     * IdP with the newly generated Key Credential, [update your
     * IdP](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/replaceIdentityProvider)
     * using the returned key&#39;s &#x60;kid&#x60; in the [signing
     * credential](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/replaceIdentityProvider!path&#x3D;protocol/0/credentials/signing/kid&amp;t&#x3D;request).
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param validityYears
     *            expiry of the IdP Key Credential (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdPKeyCredential
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPKeyCredential generateIdentityProviderSigningKey(String idpId, Integer validityYears,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idpId' when calling generateIdentityProviderSigningKey");
        }

        // verify the required parameter 'validityYears' is set
        if (validityYears == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'validityYears' when calling generateIdentityProviderSigningKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}/credentials/keys/generate".replaceAll("\\{" + "idpId" + "\\}",
                apiClient.escapeString(idpId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("validityYears", validityYears));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdPKeyCredential> localVarReturnType = new TypeReference<IdPKeyCredential>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a Certificate Signing Request Retrieves a specific Certificate Signing Request by &#x60;id&#x60;
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param idpCsrId
     *            &#x60;id&#x60; of the IdP CSR (required)
     *
     * @return IdPCsr
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPCsr getCsrForIdentityProvider(String idpId, String idpCsrId) throws ApiException {
        return this.getCsrForIdentityProvider(idpId, idpCsrId, Collections.emptyMap());
    }

    /**
     * Retrieve a Certificate Signing Request Retrieves a specific Certificate Signing Request by &#x60;id&#x60;
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param idpCsrId
     *            &#x60;id&#x60; of the IdP CSR (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdPCsr
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPCsr getCsrForIdentityProvider(String idpId, String idpCsrId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idpId' when calling getCsrForIdentityProvider");
        }

        // verify the required parameter 'idpCsrId' is set
        if (idpCsrId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idpCsrId' when calling getCsrForIdentityProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}/credentials/csrs/{idpCsrId}"
                .replaceAll("\\{" + "idpId" + "\\}", apiClient.escapeString(idpId.toString()))
                .replaceAll("\\{" + "idpCsrId" + "\\}", apiClient.escapeString(idpCsrId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json", "application/pkcs10" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdPCsr> localVarReturnType = new TypeReference<IdPCsr>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a signing Key Credential for IdP Retrieves a specific IdP Key Credential by &#x60;kid&#x60;
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param kid
     *            Unique &#x60;id&#x60; of the IdP Key Credential (required)
     *
     * @return IdPKeyCredential
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPKeyCredential getIdentityProviderSigningKey(String idpId, String kid) throws ApiException {
        return this.getIdentityProviderSigningKey(idpId, kid, Collections.emptyMap());
    }

    /**
     * Retrieve a signing Key Credential for IdP Retrieves a specific IdP Key Credential by &#x60;kid&#x60;
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param kid
     *            Unique &#x60;id&#x60; of the IdP Key Credential (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdPKeyCredential
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPKeyCredential getIdentityProviderSigningKey(String idpId, String kid,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idpId' when calling getIdentityProviderSigningKey");
        }

        // verify the required parameter 'kid' is set
        if (kid == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'kid' when calling getIdentityProviderSigningKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}/credentials/keys/{kid}"
                .replaceAll("\\{" + "idpId" + "\\}", apiClient.escapeString(idpId.toString()))
                .replaceAll("\\{" + "kid" + "\\}", apiClient.escapeString(kid.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdPKeyCredential> localVarReturnType = new TypeReference<IdPKeyCredential>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Certificate Signing Requests Lists all Certificate Signing Requests for an IdP
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     *
     * @return List&lt;IdPCsr&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<IdPCsr> listCsrsForIdentityProvider(String idpId) throws ApiException {
        return this.listCsrsForIdentityProvider(idpId, Collections.emptyMap());
    }

    /**
     * List all Certificate Signing Requests Lists all Certificate Signing Requests for an IdP
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;IdPCsr&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<IdPCsr> listCsrsForIdentityProvider(String idpId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idpId' when calling listCsrsForIdentityProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}/credentials/csrs".replaceAll("\\{" + "idpId" + "\\}",
                apiClient.escapeString(idpId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<IdPCsr>> localVarReturnType = new TypeReference<List<IdPCsr>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all signing Key Credentials for IdP Lists all signing Key Credentials for an IdP
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     *
     * @return List&lt;IdPKeyCredential&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<IdPKeyCredential> listIdentityProviderSigningKeys(String idpId) throws ApiException {
        return this.listIdentityProviderSigningKeys(idpId, Collections.emptyMap());
    }

    /**
     * List all signing Key Credentials for IdP Lists all signing Key Credentials for an IdP
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;IdPKeyCredential&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<IdPKeyCredential> listIdentityProviderSigningKeys(String idpId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idpId' when calling listIdentityProviderSigningKeys");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}/credentials/keys".replaceAll("\\{" + "idpId" + "\\}",
                apiClient.escapeString(idpId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<IdPKeyCredential>> localVarReturnType = new TypeReference<List<IdPKeyCredential>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Publish a Certificate Signing Request Publishes the CSR with a signed X.509 certificate and adds it into the
     * signing Key Credentials for the IdP &gt; **Notes:** &gt; * Publishing a certificate completes the lifecycle of
     * the CSR, and it&#39;s no longer accessible. &gt; * If the validity period of the certificate is less than 90
     * days, a 400 error response is returned.
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param idpCsrId
     *            &#x60;id&#x60; of the IdP CSR (required)
     * @param body
     *            (required)
     *
     * @return IdPKeyCredential
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPKeyCredential publishCsrForIdentityProvider(String idpId, String idpCsrId, File body)
            throws ApiException {
        return this.publishCsrForIdentityProvider(idpId, idpCsrId, body, Collections.emptyMap());
    }

    /**
     * Publish a Certificate Signing Request Publishes the CSR with a signed X.509 certificate and adds it into the
     * signing Key Credentials for the IdP &gt; **Notes:** &gt; * Publishing a certificate completes the lifecycle of
     * the CSR, and it&#39;s no longer accessible. &gt; * If the validity period of the certificate is less than 90
     * days, a 400 error response is returned.
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param idpCsrId
     *            &#x60;id&#x60; of the IdP CSR (required)
     * @param body
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdPKeyCredential
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdPKeyCredential publishCsrForIdentityProvider(String idpId, String idpCsrId, File body,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = body;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idpId' when calling publishCsrForIdentityProvider");
        }

        // verify the required parameter 'idpCsrId' is set
        if (idpCsrId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idpCsrId' when calling publishCsrForIdentityProvider");
        }

        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'body' when calling publishCsrForIdentityProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}/credentials/csrs/{idpCsrId}/lifecycle/publish"
                .replaceAll("\\{" + "idpId" + "\\}", apiClient.escapeString(idpId.toString()))
                .replaceAll("\\{" + "idpCsrId" + "\\}", apiClient.escapeString(idpCsrId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/pkix-cert", "application/x-x509-ca-cert",
                "application/x-pem-file" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdPKeyCredential> localVarReturnType = new TypeReference<IdPKeyCredential>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Revoke a Certificate Signing Request Revokes a CSR and deletes the key pair from the IdP
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param idpCsrId
     *            &#x60;id&#x60; of the IdP CSR (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeCsrForIdentityProvider(String idpId, String idpCsrId) throws ApiException {
        this.revokeCsrForIdentityProvider(idpId, idpCsrId, Collections.emptyMap());
    }

    /**
     * Revoke a Certificate Signing Request Revokes a CSR and deletes the key pair from the IdP
     *
     * @param idpId
     *            &#x60;id&#x60; of IdP (required)
     * @param idpCsrId
     *            &#x60;id&#x60; of the IdP CSR (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeCsrForIdentityProvider(String idpId, String idpCsrId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'idpId' is set
        if (idpId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idpId' when calling revokeCsrForIdentityProvider");
        }

        // verify the required parameter 'idpCsrId' is set
        if (idpCsrId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'idpCsrId' when calling revokeCsrForIdentityProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/idps/{idpId}/credentials/csrs/{idpCsrId}"
                .replaceAll("\\{" + "idpId" + "\\}", apiClient.escapeString(idpId.toString()))
                .replaceAll("\\{" + "idpCsrId" + "\\}", apiClient.escapeString(idpCsrId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
