/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.LinkedObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class LinkedObjectApi {

    private ApiClient apiClient;

    public LinkedObjectApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LinkedObjectApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a Linked Object Definition Creates a Linked Object definition
     *
     * @param linkedObject
     *            (required)
     *
     * @return LinkedObject
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public LinkedObject createLinkedObjectDefinition(LinkedObject linkedObject) throws ApiException {
        return this.createLinkedObjectDefinition(linkedObject, Collections.emptyMap());
    }

    /**
     * Create a Linked Object Definition Creates a Linked Object definition
     *
     * @param linkedObject
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return LinkedObject
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public LinkedObject createLinkedObjectDefinition(LinkedObject linkedObject, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = linkedObject;

        // verify the required parameter 'linkedObject' is set
        if (linkedObject == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'linkedObject' when calling createLinkedObjectDefinition");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/schemas/user/linkedObjects";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<LinkedObject> localVarReturnType = new TypeReference<LinkedObject>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Linked Object Definition Deletes the Linked Object definition specified by either the
     * &#x60;primary&#x60; or &#x60;associated&#x60; name. The entire definition is removed, regardless of which name
     * that you specify.
     *
     * @param linkedObjectName
     *            Primary or Associated name (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteLinkedObjectDefinition(String linkedObjectName) throws ApiException {
        this.deleteLinkedObjectDefinition(linkedObjectName, Collections.emptyMap());
    }

    /**
     * Delete a Linked Object Definition Deletes the Linked Object definition specified by either the
     * &#x60;primary&#x60; or &#x60;associated&#x60; name. The entire definition is removed, regardless of which name
     * that you specify.
     *
     * @param linkedObjectName
     *            Primary or Associated name (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteLinkedObjectDefinition(String linkedObjectName, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'linkedObjectName' is set
        if (linkedObjectName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'linkedObjectName' when calling deleteLinkedObjectDefinition");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/schemas/user/linkedObjects/{linkedObjectName}"
                .replaceAll("\\{" + "linkedObjectName" + "\\}", apiClient.escapeString(linkedObjectName.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Linked Object Definition Retrieves a Linked Object definition
     *
     * @param linkedObjectName
     *            Primary or Associated name (required)
     *
     * @return LinkedObject
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public LinkedObject getLinkedObjectDefinition(String linkedObjectName) throws ApiException {
        return this.getLinkedObjectDefinition(linkedObjectName, Collections.emptyMap());
    }

    /**
     * Retrieve a Linked Object Definition Retrieves a Linked Object definition
     *
     * @param linkedObjectName
     *            Primary or Associated name (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return LinkedObject
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public LinkedObject getLinkedObjectDefinition(String linkedObjectName, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'linkedObjectName' is set
        if (linkedObjectName == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'linkedObjectName' when calling getLinkedObjectDefinition");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/schemas/user/linkedObjects/{linkedObjectName}"
                .replaceAll("\\{" + "linkedObjectName" + "\\}", apiClient.escapeString(linkedObjectName.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<LinkedObject> localVarReturnType = new TypeReference<LinkedObject>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Linked Object Definitions Lists all Linked Object definitions
     *
     * @return List&lt;LinkedObject&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<LinkedObject> listLinkedObjectDefinitions() throws ApiException {
        return this.listLinkedObjectDefinitions(Collections.emptyMap());
    }

    /**
     * List all Linked Object Definitions Lists all Linked Object definitions
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;LinkedObject&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<LinkedObject> listLinkedObjectDefinitions(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/meta/schemas/user/linkedObjects";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<LinkedObject>> localVarReturnType = new TypeReference<List<LinkedObject>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
