/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import java.io.File;
import com.okta.sdk.resource.model.OrgPreferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OrgSettingCustomizationApi {

    private ApiClient apiClient;

    public OrgSettingCustomizationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrgSettingCustomizationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve the Org Preferences Retrieves preferences of your Okta org
     *
     * @return OrgPreferences
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgPreferences getOrgPreferences() throws ApiException {
        return this.getOrgPreferences(Collections.emptyMap());
    }

    /**
     * Retrieve the Org Preferences Retrieves preferences of your Okta org
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgPreferences
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgPreferences getOrgPreferences(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/org/preferences";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgPreferences> localVarReturnType = new TypeReference<OrgPreferences>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Set the Hide Dashboard Footer Preference Sets the preference to hide the Okta UI footer for all end users of your
     * org
     *
     * @return OrgPreferences
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgPreferences setOrgHideOktaUIFooter() throws ApiException {
        return this.setOrgHideOktaUIFooter(Collections.emptyMap());
    }

    /**
     * Set the Hide Dashboard Footer Preference Sets the preference to hide the Okta UI footer for all end users of your
     * org
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgPreferences
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgPreferences setOrgHideOktaUIFooter(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/org/preferences/hideEndUserFooter";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgPreferences> localVarReturnType = new TypeReference<OrgPreferences>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Set the Show Dashboard Footer Preference Sets the preference to show the Okta UI footer for all end users of your
     * org
     *
     * @return OrgPreferences
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgPreferences setOrgShowOktaUIFooter() throws ApiException {
        return this.setOrgShowOktaUIFooter(Collections.emptyMap());
    }

    /**
     * Set the Show Dashboard Footer Preference Sets the preference to show the Okta UI footer for all end users of your
     * org
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OrgPreferences
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OrgPreferences setOrgShowOktaUIFooter(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/org/preferences/showEndUserFooter";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OrgPreferences> localVarReturnType = new TypeReference<OrgPreferences>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload the Org Logo Uploads and replaces the logo for your organization
     *
     * @param _file
     *            The file must be in PNG, JPG, or GIF format and less than 1 MB in size. For best results use landscape
     *            orientation, a transparent background, and a minimum size of 420px by 120px to prevent upscaling.
     *            (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void uploadOrgLogo(File _file) throws ApiException {
        this.uploadOrgLogo(_file, Collections.emptyMap());
    }

    /**
     * Upload the Org Logo Uploads and replaces the logo for your organization
     *
     * @param _file
     *            The file must be in PNG, JPG, or GIF format and less than 1 MB in size. For best results use landscape
     *            orientation, a transparent background, and a minimum size of 420px by 120px to prevent upscaling.
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void uploadOrgLogo(File _file, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter '_file' is set
        if (_file == null) {
            throw new ApiException(400, "Missing the required parameter '_file' when calling uploadOrgLogo");
        }

        // create path and map variables
        String localVarPath = "/api/v1/org/logo";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        if (_file != null)
            localVarFormParams.put("file", _file);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "multipart/form-data" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
