/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.CreateResourceSetRequest;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.ResourceSet;
import com.okta.sdk.resource.model.ResourceSets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class RoleCResourceSetApi {

    private ApiClient apiClient;

    public RoleCResourceSetApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleCResourceSetApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a Resource Set Creates a new Resource Set. See [Supported
     * Resources](/openapi/okta-management/guides/roles/#supported-resources). &gt; **Note:** The maximum number of
     * &#x60;resources&#x60; allowed in a Resource Set object is 1000. Resources are identified by either an Okta
     * Resource Name (ORN) or by a REST URL format. See [Okta Resource
     * Name](/openapi/okta-management/guides/roles/#okta-resource-name-orn).
     *
     * @param instance
     *            (required)
     *
     * @return ResourceSet
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSet createResourceSet(CreateResourceSetRequest instance) throws ApiException {
        return this.createResourceSet(instance, Collections.emptyMap());
    }

    /**
     * Create a Resource Set Creates a new Resource Set. See [Supported
     * Resources](/openapi/okta-management/guides/roles/#supported-resources). &gt; **Note:** The maximum number of
     * &#x60;resources&#x60; allowed in a Resource Set object is 1000. Resources are identified by either an Okta
     * Resource Name (ORN) or by a REST URL format. See [Okta Resource
     * Name](/openapi/okta-management/guides/roles/#okta-resource-name-orn).
     *
     * @param instance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ResourceSet
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSet createResourceSet(CreateResourceSetRequest instance, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'instance' is set
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling createResourceSet");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/resource-sets";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ResourceSet> localVarReturnType = new TypeReference<ResourceSet>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Resource Set Deletes a Resource Set by &#x60;resourceSetIdOrLabel&#x60;
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteResourceSet(String resourceSetIdOrLabel) throws ApiException {
        this.deleteResourceSet(resourceSetIdOrLabel, Collections.emptyMap());
    }

    /**
     * Delete a Resource Set Deletes a Resource Set by &#x60;resourceSetIdOrLabel&#x60;
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteResourceSet(String resourceSetIdOrLabel, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'resourceSetIdOrLabel' is set
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'resourceSetIdOrLabel' when calling deleteResourceSet");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}".replaceAll(
                "\\{" + "resourceSetIdOrLabel" + "\\}", apiClient.escapeString(resourceSetIdOrLabel.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Resource Set Retrieves a Resource Set by &#x60;resourceSetIdOrLabel&#x60;
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     *
     * @return ResourceSet
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSet getResourceSet(String resourceSetIdOrLabel) throws ApiException {
        return this.getResourceSet(resourceSetIdOrLabel, Collections.emptyMap());
    }

    /**
     * Retrieve a Resource Set Retrieves a Resource Set by &#x60;resourceSetIdOrLabel&#x60;
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ResourceSet
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSet getResourceSet(String resourceSetIdOrLabel, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'resourceSetIdOrLabel' is set
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'resourceSetIdOrLabel' when calling getResourceSet");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}".replaceAll(
                "\\{" + "resourceSetIdOrLabel" + "\\}", apiClient.escapeString(resourceSetIdOrLabel.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ResourceSet> localVarReturnType = new TypeReference<ResourceSet>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Resource Sets Lists all Resource Sets with pagination support
     *
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     *
     * @return ResourceSets
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSets listResourceSets(String after) throws ApiException {
        return this.listResourceSets(after, Collections.emptyMap());
    }

    /**
     * List all Resource Sets Lists all Resource Sets with pagination support
     *
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ResourceSets
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSets listResourceSets(String after, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/iam/resource-sets";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ResourceSets> localVarReturnType = new TypeReference<ResourceSets>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Resource Set Replaces the label and description of a Resource Set
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param instance
     *            (required)
     *
     * @return ResourceSet
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSet replaceResourceSet(String resourceSetIdOrLabel, ResourceSet instance) throws ApiException {
        return this.replaceResourceSet(resourceSetIdOrLabel, instance, Collections.emptyMap());
    }

    /**
     * Replace a Resource Set Replaces the label and description of a Resource Set
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param instance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ResourceSet
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSet replaceResourceSet(String resourceSetIdOrLabel, ResourceSet instance,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'resourceSetIdOrLabel' is set
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'resourceSetIdOrLabel' when calling replaceResourceSet");
        }

        // verify the required parameter 'instance' is set
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling replaceResourceSet");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}".replaceAll(
                "\\{" + "resourceSetIdOrLabel" + "\\}", apiClient.escapeString(resourceSetIdOrLabel.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ResourceSet> localVarReturnType = new TypeReference<ResourceSet>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
