/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.ResourceSetBindingAddMembersRequest;
import com.okta.sdk.resource.model.ResourceSetBindingMember;
import com.okta.sdk.resource.model.ResourceSetBindingMembers;
import com.okta.sdk.resource.model.ResourceSetBindingResponse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class RoleDResourceSetBindingMemberApi {

    private ApiClient apiClient;

    public RoleDResourceSetBindingMemberApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleDResourceSetBindingMemberApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add more Role Resource Set Binding Members Adds more members to a Role Resource Set Binding
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param instance
     *            (required)
     *
     * @return ResourceSetBindingResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSetBindingResponse addMembersToBinding(String resourceSetIdOrLabel, String roleIdOrLabel,
            ResourceSetBindingAddMembersRequest instance) throws ApiException {
        return this.addMembersToBinding(resourceSetIdOrLabel, roleIdOrLabel, instance, Collections.emptyMap());
    }

    /**
     * Add more Role Resource Set Binding Members Adds more members to a Role Resource Set Binding
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param instance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ResourceSetBindingResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSetBindingResponse addMembersToBinding(String resourceSetIdOrLabel, String roleIdOrLabel,
            ResourceSetBindingAddMembersRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'resourceSetIdOrLabel' is set
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'resourceSetIdOrLabel' when calling addMembersToBinding");
        }

        // verify the required parameter 'roleIdOrLabel' is set
        if (roleIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleIdOrLabel' when calling addMembersToBinding");
        }

        // verify the required parameter 'instance' is set
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling addMembersToBinding");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel}/members"
                .replaceAll("\\{" + "resourceSetIdOrLabel" + "\\}",
                        apiClient.escapeString(resourceSetIdOrLabel.toString()))
                .replaceAll("\\{" + "roleIdOrLabel" + "\\}", apiClient.escapeString(roleIdOrLabel.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ResourceSetBindingResponse> localVarReturnType = new TypeReference<ResourceSetBindingResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a Role Resource Set Binding Member Retrieves a Member (identified by &#x60;memberId&#x60;) that belongs
     * to a Role Resource Set Binding
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param memberId
     *            &#x60;id&#x60; of the Member (required)
     *
     * @return ResourceSetBindingMember
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSetBindingMember getMemberOfBinding(String resourceSetIdOrLabel, String roleIdOrLabel,
            String memberId) throws ApiException {
        return this.getMemberOfBinding(resourceSetIdOrLabel, roleIdOrLabel, memberId, Collections.emptyMap());
    }

    /**
     * Retrieve a Role Resource Set Binding Member Retrieves a Member (identified by &#x60;memberId&#x60;) that belongs
     * to a Role Resource Set Binding
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param memberId
     *            &#x60;id&#x60; of the Member (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ResourceSetBindingMember
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSetBindingMember getMemberOfBinding(String resourceSetIdOrLabel, String roleIdOrLabel,
            String memberId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'resourceSetIdOrLabel' is set
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'resourceSetIdOrLabel' when calling getMemberOfBinding");
        }

        // verify the required parameter 'roleIdOrLabel' is set
        if (roleIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleIdOrLabel' when calling getMemberOfBinding");
        }

        // verify the required parameter 'memberId' is set
        if (memberId == null) {
            throw new ApiException(400, "Missing the required parameter 'memberId' when calling getMemberOfBinding");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel}/members/{memberId}"
                .replaceAll("\\{" + "resourceSetIdOrLabel" + "\\}",
                        apiClient.escapeString(resourceSetIdOrLabel.toString()))
                .replaceAll("\\{" + "roleIdOrLabel" + "\\}", apiClient.escapeString(roleIdOrLabel.toString()))
                .replaceAll("\\{" + "memberId" + "\\}", apiClient.escapeString(memberId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ResourceSetBindingMember> localVarReturnType = new TypeReference<ResourceSetBindingMember>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Role Resource Set Binding Members Lists all members of a Role Resource Set Binding with pagination
     * support
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     *
     * @return ResourceSetBindingMembers
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSetBindingMembers listMembersOfBinding(String resourceSetIdOrLabel, String roleIdOrLabel,
            String after) throws ApiException {
        return this.listMembersOfBinding(resourceSetIdOrLabel, roleIdOrLabel, after, Collections.emptyMap());
    }

    /**
     * List all Role Resource Set Binding Members Lists all members of a Role Resource Set Binding with pagination
     * support
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ResourceSetBindingMembers
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResourceSetBindingMembers listMembersOfBinding(String resourceSetIdOrLabel, String roleIdOrLabel,
            String after, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'resourceSetIdOrLabel' is set
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'resourceSetIdOrLabel' when calling listMembersOfBinding");
        }

        // verify the required parameter 'roleIdOrLabel' is set
        if (roleIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleIdOrLabel' when calling listMembersOfBinding");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel}/members"
                .replaceAll("\\{" + "resourceSetIdOrLabel" + "\\}",
                        apiClient.escapeString(resourceSetIdOrLabel.toString()))
                .replaceAll("\\{" + "roleIdOrLabel" + "\\}", apiClient.escapeString(roleIdOrLabel.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ResourceSetBindingMembers> localVarReturnType = new TypeReference<ResourceSetBindingMembers>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Unassign a Role Resource Set Bindiing Member Unassigns a Member (identified by &#x60;memberId&#x60;) from a Role
     * Resource Set Binding
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param memberId
     *            &#x60;id&#x60; of the Member (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignMemberFromBinding(String resourceSetIdOrLabel, String roleIdOrLabel, String memberId)
            throws ApiException {
        this.unassignMemberFromBinding(resourceSetIdOrLabel, roleIdOrLabel, memberId, Collections.emptyMap());
    }

    /**
     * Unassign a Role Resource Set Bindiing Member Unassigns a Member (identified by &#x60;memberId&#x60;) from a Role
     * Resource Set Binding
     *
     * @param resourceSetIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; the Resource Set (required)
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param memberId
     *            &#x60;id&#x60; of the Member (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignMemberFromBinding(String resourceSetIdOrLabel, String roleIdOrLabel, String memberId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'resourceSetIdOrLabel' is set
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'resourceSetIdOrLabel' when calling unassignMemberFromBinding");
        }

        // verify the required parameter 'roleIdOrLabel' is set
        if (roleIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleIdOrLabel' when calling unassignMemberFromBinding");
        }

        // verify the required parameter 'memberId' is set
        if (memberId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'memberId' when calling unassignMemberFromBinding");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/bindings/{roleIdOrLabel}/members/{memberId}"
                .replaceAll("\\{" + "resourceSetIdOrLabel" + "\\}",
                        apiClient.escapeString(resourceSetIdOrLabel.toString()))
                .replaceAll("\\{" + "roleIdOrLabel" + "\\}", apiClient.escapeString(roleIdOrLabel.toString()))
                .replaceAll("\\{" + "memberId" + "\\}", apiClient.escapeString(memberId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
