/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.GroupSchema;
import com.okta.sdk.resource.model.LogStreamSchema;
import com.okta.sdk.resource.model.LogStreamType;
import com.okta.sdk.resource.model.UserSchema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SchemaApi {

    private ApiClient apiClient;

    public SchemaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SchemaApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve the default App User Schema for an App Retrieves the default Schema for an App User. The [User
     * Types](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UserType/) feature does not
     * extend to apps. All users assigned to a given app use the same App User Schema. Therefore, unlike the User Schema
     * operations, the App User Schema operations all specify &#x60;default&#x60; and don&#39;t accept a Schema ID.
     *
     * @param appId
     *            Application ID (required)
     *
     * @return UserSchema
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserSchema getApplicationUserSchema(String appId) throws ApiException {
        return this.getApplicationUserSchema(appId, Collections.emptyMap());
    }

    /**
     * Retrieve the default App User Schema for an App Retrieves the default Schema for an App User. The [User
     * Types](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UserType/) feature does not
     * extend to apps. All users assigned to a given app use the same App User Schema. Therefore, unlike the User Schema
     * operations, the App User Schema operations all specify &#x60;default&#x60; and don&#39;t accept a Schema ID.
     *
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserSchema
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserSchema getApplicationUserSchema(String appId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getApplicationUserSchema");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/schemas/apps/{appId}/default".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserSchema> localVarReturnType = new TypeReference<UserSchema>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve the default Group Schema Retrieves the Group Schema The [User
     * Types](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UserType/) feature does not
     * extend to groups. All groups use the same Group Schema. Unlike User Schema operations, Group Schema operations
     * all specify &#x60;default&#x60; and don&#39;t accept a Schema ID.
     *
     * @return GroupSchema
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public GroupSchema getGroupSchema() throws ApiException {
        return this.getGroupSchema(Collections.emptyMap());
    }

    /**
     * Retrieve the default Group Schema Retrieves the Group Schema The [User
     * Types](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UserType/) feature does not
     * extend to groups. All groups use the same Group Schema. Unlike User Schema operations, Group Schema operations
     * all specify &#x60;default&#x60; and don&#39;t accept a Schema ID.
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return GroupSchema
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public GroupSchema getGroupSchema(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/meta/schemas/group/default";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<GroupSchema> localVarReturnType = new TypeReference<GroupSchema>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve the Log Stream Schema for the schema type Retrieves the Schema for a Log Stream type. The
     * &#x60;logStreamType&#x60; element in the URL specifies the Log Stream type, which is either
     * &#x60;aws_eventbridge&#x60; or &#x60;splunk_cloud_logstreaming&#x60;. Use the &#x60;aws_eventbridge&#x60; literal
     * to retrieve the AWS EventBridge type schema, and use the &#x60;splunk_cloud_logstreaming&#x60; literal retrieve
     * the Splunk Cloud type schema.
     *
     * @param logStreamType
     *            (required)
     *
     * @return LogStreamSchema
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public LogStreamSchema getLogStreamSchema(LogStreamType logStreamType) throws ApiException {
        return this.getLogStreamSchema(logStreamType, Collections.emptyMap());
    }

    /**
     * Retrieve the Log Stream Schema for the schema type Retrieves the Schema for a Log Stream type. The
     * &#x60;logStreamType&#x60; element in the URL specifies the Log Stream type, which is either
     * &#x60;aws_eventbridge&#x60; or &#x60;splunk_cloud_logstreaming&#x60;. Use the &#x60;aws_eventbridge&#x60; literal
     * to retrieve the AWS EventBridge type schema, and use the &#x60;splunk_cloud_logstreaming&#x60; literal retrieve
     * the Splunk Cloud type schema.
     *
     * @param logStreamType
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return LogStreamSchema
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public LogStreamSchema getLogStreamSchema(LogStreamType logStreamType, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'logStreamType' is set
        if (logStreamType == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'logStreamType' when calling getLogStreamSchema");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/schemas/logStream/{logStreamType}"
                .replaceAll("\\{" + "logStreamType" + "\\}", apiClient.escapeString(logStreamType.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<LogStreamSchema> localVarReturnType = new TypeReference<LogStreamSchema>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a User Schema Retrieves the Schema for a User Type
     *
     * @param schemaId
     *            (required)
     *
     * @return UserSchema
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserSchema getUserSchema(String schemaId) throws ApiException {
        return this.getUserSchema(schemaId, Collections.emptyMap());
    }

    /**
     * Retrieve a User Schema Retrieves the Schema for a User Type
     *
     * @param schemaId
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserSchema
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserSchema getUserSchema(String schemaId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'schemaId' is set
        if (schemaId == null) {
            throw new ApiException(400, "Missing the required parameter 'schemaId' when calling getUserSchema");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/schemas/user/{schemaId}".replaceAll("\\{" + "schemaId" + "\\}",
                apiClient.escapeString(schemaId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserSchema> localVarReturnType = new TypeReference<UserSchema>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List the Log Stream Schemas Lists the Schema for all Log Stream types visible for this org
     *
     * @return List&lt;LogStreamSchema&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<LogStreamSchema> listLogStreamSchemas() throws ApiException {
        return this.listLogStreamSchemas(Collections.emptyMap());
    }

    /**
     * List the Log Stream Schemas Lists the Schema for all Log Stream types visible for this org
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;LogStreamSchema&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<LogStreamSchema> listLogStreamSchemas(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/meta/schemas/logStream";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<LogStreamSchema>> localVarReturnType = new TypeReference<List<LogStreamSchema>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update the App User Profile Schema for an App Updates the App User Schema. This updates, adds, or removes one or
     * more custom profile properties or the nullability of a base property in the App User Schema for an app. Changing
     * a base property&#39;s nullability (for example, the value of its &#x60;required&#x60; field) is allowed only if
     * it is nullable in the default predefined Schema for the App. The [User
     * Types](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UserType/) feature does not
     * extend to apps. All users assigned to a given app use the same App User Schema. Therefore, unlike the User Schema
     * operations, the App User Schema operations all specify &#x60;default&#x60; and don&#39;t accept a Schema ID.
     *
     * @param appId
     *            Application ID (required)
     * @param body
     *            (optional)
     *
     * @return UserSchema
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserSchema updateApplicationUserProfile(String appId, UserSchema body) throws ApiException {
        return this.updateApplicationUserProfile(appId, body, Collections.emptyMap());
    }

    /**
     * Update the App User Profile Schema for an App Updates the App User Schema. This updates, adds, or removes one or
     * more custom profile properties or the nullability of a base property in the App User Schema for an app. Changing
     * a base property&#39;s nullability (for example, the value of its &#x60;required&#x60; field) is allowed only if
     * it is nullable in the default predefined Schema for the App. The [User
     * Types](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UserType/) feature does not
     * extend to apps. All users assigned to a given app use the same App User Schema. Therefore, unlike the User Schema
     * operations, the App User Schema operations all specify &#x60;default&#x60; and don&#39;t accept a Schema ID.
     *
     * @param appId
     *            Application ID (required)
     * @param body
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserSchema
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserSchema updateApplicationUserProfile(String appId, UserSchema body, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = body;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling updateApplicationUserProfile");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/schemas/apps/{appId}/default".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserSchema> localVarReturnType = new TypeReference<UserSchema>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update the Group Profile Schema Updates the Group Profile schema. This updates, adds, or removes one or more
     * custom profile properties in a Group Schema. Currently Okta does not support changing base Group Profile
     * properties. The [User
     * Types](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UserType/) feature does not
     * extend to groups. All groups use the same Group Schema. Unlike User Schema operations, Group Schema operations
     * all specify &#x60;default&#x60; and don&#39;t accept a Schema ID. **Note:** Since POST is interpreted as a
     * partial update, you must set properties explicitly to null to remove them from the Schema.
     *
     * @param groupSchema
     *            (optional)
     *
     * @return GroupSchema
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public GroupSchema updateGroupSchema(GroupSchema groupSchema) throws ApiException {
        return this.updateGroupSchema(groupSchema, Collections.emptyMap());
    }

    /**
     * Update the Group Profile Schema Updates the Group Profile schema. This updates, adds, or removes one or more
     * custom profile properties in a Group Schema. Currently Okta does not support changing base Group Profile
     * properties. The [User
     * Types](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UserType/) feature does not
     * extend to groups. All groups use the same Group Schema. Unlike User Schema operations, Group Schema operations
     * all specify &#x60;default&#x60; and don&#39;t accept a Schema ID. **Note:** Since POST is interpreted as a
     * partial update, you must set properties explicitly to null to remove them from the Schema.
     *
     * @param groupSchema
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return GroupSchema
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public GroupSchema updateGroupSchema(GroupSchema groupSchema, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = groupSchema;

        // create path and map variables
        String localVarPath = "/api/v1/meta/schemas/group/default";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<GroupSchema> localVarReturnType = new TypeReference<GroupSchema>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update a User Schema Updates a User Schema. This updates, adds, or removes one or more profile properties in a
     * User Schema. Unlike custom User Profile properties, limited changes are allowed to base User Profile properties
     * (permissions, nullability of the &#x60;firstName&#x60; and &#x60;lastName&#x60; properties, or pattern for
     * &#x60;login&#x60;). A property cannot be removed from the default Schema if it is being referenced as a
     * [matchAttribute](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/) in
     * SAML2 IdPs. Currently, all validation of SAML assertions is only performed against the default user type.
     *
     * @param schemaId
     *            (required)
     * @param userSchema
     *            (required)
     *
     * @return UserSchema
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserSchema updateUserProfile(String schemaId, UserSchema userSchema) throws ApiException {
        return this.updateUserProfile(schemaId, userSchema, Collections.emptyMap());
    }

    /**
     * Update a User Schema Updates a User Schema. This updates, adds, or removes one or more profile properties in a
     * User Schema. Unlike custom User Profile properties, limited changes are allowed to base User Profile properties
     * (permissions, nullability of the &#x60;firstName&#x60; and &#x60;lastName&#x60; properties, or pattern for
     * &#x60;login&#x60;). A property cannot be removed from the default Schema if it is being referenced as a
     * [matchAttribute](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/) in
     * SAML2 IdPs. Currently, all validation of SAML assertions is only performed against the default user type.
     *
     * @param schemaId
     *            (required)
     * @param userSchema
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserSchema
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserSchema updateUserProfile(String schemaId, UserSchema userSchema, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = userSchema;

        // verify the required parameter 'schemaId' is set
        if (schemaId == null) {
            throw new ApiException(400, "Missing the required parameter 'schemaId' when calling updateUserProfile");
        }

        // verify the required parameter 'userSchema' is set
        if (userSchema == null) {
            throw new ApiException(400, "Missing the required parameter 'userSchema' when calling updateUserProfile");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/schemas/user/{schemaId}".replaceAll("\\{" + "schemaId" + "\\}",
                apiClient.escapeString(schemaId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserSchema> localVarReturnType = new TypeReference<UserSchema>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
