/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.CreateUISchema;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.UISchemasResponseObject;
import com.okta.sdk.resource.model.UpdateUISchema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UiSchemaApi {

    private ApiClient apiClient;

    public UiSchemaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UiSchemaApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a UI Schema Creates an input for an enrollment form
     *
     * @param uischemabody
     *            (required)
     *
     * @return UISchemasResponseObject
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UISchemasResponseObject createUISchema(CreateUISchema uischemabody) throws ApiException {
        return this.createUISchema(uischemabody, Collections.emptyMap());
    }

    /**
     * Create a UI Schema Creates an input for an enrollment form
     *
     * @param uischemabody
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UISchemasResponseObject
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UISchemasResponseObject createUISchema(CreateUISchema uischemabody, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = uischemabody;

        // verify the required parameter 'uischemabody' is set
        if (uischemabody == null) {
            throw new ApiException(400, "Missing the required parameter 'uischemabody' when calling createUISchema");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/uischemas";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UISchemasResponseObject> localVarReturnType = new TypeReference<UISchemasResponseObject>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a UI Schema Deletes a UI Schema by &#x60;id&#x60;
     *
     * @param id
     *            The unique ID of the UI Schema (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteUISchemas(String id) throws ApiException {
        this.deleteUISchemas(id, Collections.emptyMap());
    }

    /**
     * Delete a UI Schema Deletes a UI Schema by &#x60;id&#x60;
     *
     * @param id
     *            The unique ID of the UI Schema (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteUISchemas(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteUISchemas");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/uischemas/{id}".replaceAll("\\{" + "id" + "\\}",
                apiClient.escapeString(id.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a UI Schema Retrieves a UI Schema by &#x60;id&#x60;
     *
     * @param id
     *            The unique ID of the UI Schema (required)
     *
     * @return UISchemasResponseObject
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UISchemasResponseObject getUISchema(String id) throws ApiException {
        return this.getUISchema(id, Collections.emptyMap());
    }

    /**
     * Retrieve a UI Schema Retrieves a UI Schema by &#x60;id&#x60;
     *
     * @param id
     *            The unique ID of the UI Schema (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UISchemasResponseObject
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UISchemasResponseObject getUISchema(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getUISchema");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/uischemas/{id}".replaceAll("\\{" + "id" + "\\}",
                apiClient.escapeString(id.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UISchemasResponseObject> localVarReturnType = new TypeReference<UISchemasResponseObject>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all UI Schemas Lists all UI Schemas in your org
     *
     * @return List&lt;UISchemasResponseObject&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<UISchemasResponseObject> listUISchemas() throws ApiException {
        return this.listUISchemas(Collections.emptyMap());
    }

    /**
     * List all UI Schemas Lists all UI Schemas in your org
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;UISchemasResponseObject&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<UISchemasResponseObject> listUISchemas(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/meta/uischemas";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<UISchemasResponseObject>> localVarReturnType = new TypeReference<List<UISchemasResponseObject>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a UI Schema Replaces a UI Schema by &#x60;id&#x60;
     *
     * @param id
     *            The unique ID of the UI Schema (required)
     * @param updateUISchemaBody
     *            (required)
     *
     * @return UISchemasResponseObject
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UISchemasResponseObject replaceUISchemas(String id, UpdateUISchema updateUISchemaBody) throws ApiException {
        return this.replaceUISchemas(id, updateUISchemaBody, Collections.emptyMap());
    }

    /**
     * Replace a UI Schema Replaces a UI Schema by &#x60;id&#x60;
     *
     * @param id
     *            The unique ID of the UI Schema (required)
     * @param updateUISchemaBody
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UISchemasResponseObject
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UISchemasResponseObject replaceUISchemas(String id, UpdateUISchema updateUISchemaBody,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = updateUISchemaBody;

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling replaceUISchemas");
        }

        // verify the required parameter 'updateUISchemaBody' is set
        if (updateUISchemaBody == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'updateUISchemaBody' when calling replaceUISchemas");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/uischemas/{id}".replaceAll("\\{" + "id" + "\\}",
                apiClient.escapeString(id.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UISchemasResponseObject> localVarReturnType = new TypeReference<UISchemasResponseObject>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
