package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.HrefObjectClientLink;
import com.okta.sdk.resource.model.HrefObjectLogoLink;
import com.okta.sdk.resource.model.HrefObjectSelfLink;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the current status
 * of an application using the [JSON Hypertext Application
 * Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. This object is used for
 * dynamic discovery of related resources and lifecycle operations.
 */
@ApiModel(description = "Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the current status of an application using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. This object is used for dynamic discovery of related resources and lifecycle operations.")
@JsonPropertyOrder({ APIServiceIntegrationLinks.JSON_PROPERTY_CLIENT, APIServiceIntegrationLinks.JSON_PROPERTY_LOGO,
        APIServiceIntegrationLinks.JSON_PROPERTY_SELF })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class APIServiceIntegrationLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CLIENT = "client";
    private HrefObjectClientLink client;

    public static final String JSON_PROPERTY_LOGO = "logo";
    private HrefObjectLogoLink logo;

    public static final String JSON_PROPERTY_SELF = "self";
    private HrefObjectSelfLink self;

    public APIServiceIntegrationLinks() {
    }

    public APIServiceIntegrationLinks client(HrefObjectClientLink client) {

        this.client = client;
        return this;
    }

    /**
     * Get client
     *
     * @return client
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CLIENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectClientLink getClient() {
        return client;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClient(HrefObjectClientLink client) {
        this.client = client;
    }

    public APIServiceIntegrationLinks logo(HrefObjectLogoLink logo) {

        this.logo = logo;
        return this;
    }

    /**
     * Get logo
     *
     * @return logo
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LOGO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectLogoLink getLogo() {
        return logo;
    }

    @JsonProperty(JSON_PROPERTY_LOGO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLogo(HrefObjectLogoLink logo) {
        this.logo = logo;
    }

    public APIServiceIntegrationLinks self(HrefObjectSelfLink self) {

        this.self = self;
        return this;
    }

    /**
     * Get self
     *
     * @return self
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectSelfLink getSelf() {
        return self;
    }

    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSelf(HrefObjectSelfLink self) {
        this.self = self;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        APIServiceIntegrationLinks apIServiceIntegrationLinks = (APIServiceIntegrationLinks) o;
        return Objects.equals(this.client, apIServiceIntegrationLinks.client)
                && Objects.equals(this.logo, apIServiceIntegrationLinks.logo)
                && Objects.equals(this.self, apIServiceIntegrationLinks.self);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(client, logo, self);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APIServiceIntegrationLinks {\n");
        sb.append("    client: ").append(toIndentedString(client)).append("\n");
        sb.append("    logo: ").append(toIndentedString(logo)).append("\n");
        sb.append("    self: ").append(toIndentedString(self)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
