package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApiTokenNetwork;
import com.okta.sdk.resource.model.LinksSelf;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * An API token for an Okta User. This token is NOT scoped any further and can be used for any API the user has
 * permissions to call.
 */
@ApiModel(description = "An API token for an Okta User. This token is NOT scoped any further and can be used for any API the user has permissions to call.")
@JsonPropertyOrder({ ApiToken.JSON_PROPERTY_CLIENT_NAME, ApiToken.JSON_PROPERTY_CREATED,
        ApiToken.JSON_PROPERTY_EXPIRES_AT, ApiToken.JSON_PROPERTY_ID, ApiToken.JSON_PROPERTY_LAST_UPDATED,
        ApiToken.JSON_PROPERTY_NAME, ApiToken.JSON_PROPERTY_NETWORK, ApiToken.JSON_PROPERTY_TOKEN_WINDOW,
        ApiToken.JSON_PROPERTY_USER_ID, ApiToken.JSON_PROPERTY_LINK })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ApiToken implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CLIENT_NAME = "clientName";
    private String clientName;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_NETWORK = "network";
    private ApiTokenNetwork network;

    public static final String JSON_PROPERTY_TOKEN_WINDOW = "tokenWindow";
    private String tokenWindow;

    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    public static final String JSON_PROPERTY_LINK = "_link";
    private LinksSelf link;

    public ApiToken() {
    }

    /*
     * @JsonCreator public ApiToken(
     *
     * @JsonProperty(JSON_PROPERTY_CLIENT_NAME) String clientName,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_EXPIRES_AT) OffsetDateTime expiresAt,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.clientName = clientName;
     * this.created = created; this.expiresAt = expiresAt; this.id = id; this.lastUpdated = lastUpdated; }
     */

    /**
     * Get clientName
     *
     * @return clientName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CLIENT_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientName() {
        return clientName;
    }

    /**
     * Get created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * Get expiresAt
     *
     * @return expiresAt
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getExpiresAt() {
        return expiresAt;
    }

    /**
     * Get id
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Get lastUpdated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public ApiToken name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Get name
     *
     * @return name
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public ApiToken network(ApiTokenNetwork network) {

        this.network = network;
        return this;
    }

    /**
     * Get network
     *
     * @return network
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NETWORK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApiTokenNetwork getNetwork() {
        return network;
    }

    @JsonProperty(JSON_PROPERTY_NETWORK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNetwork(ApiTokenNetwork network) {
        this.network = network;
    }

    public ApiToken tokenWindow(String tokenWindow) {

        this.tokenWindow = tokenWindow;
        return this;
    }

    /**
     * A time duration specified as an [ISO-8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).
     *
     * @return tokenWindow
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A time duration specified as an [ISO-8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).")
    @JsonProperty(JSON_PROPERTY_TOKEN_WINDOW)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTokenWindow() {
        return tokenWindow;
    }

    @JsonProperty(JSON_PROPERTY_TOKEN_WINDOW)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTokenWindow(String tokenWindow) {
        this.tokenWindow = tokenWindow;
    }

    public ApiToken userId(String userId) {

        this.userId = userId;
        return this;
    }

    /**
     * Get userId
     *
     * @return userId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserId() {
        return userId;
    }

    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ApiToken link(LinksSelf link) {

        this.link = link;
        return this;
    }

    /**
     * Get link
     *
     * @return link
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLink() {
        return link;
    }

    @JsonProperty(JSON_PROPERTY_LINK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLink(LinksSelf link) {
        this.link = link;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApiToken apiToken = (ApiToken) o;
        return Objects.equals(this.clientName, apiToken.clientName) && Objects.equals(this.created, apiToken.created)
                && Objects.equals(this.expiresAt, apiToken.expiresAt) && Objects.equals(this.id, apiToken.id)
                && Objects.equals(this.lastUpdated, apiToken.lastUpdated) && Objects.equals(this.name, apiToken.name)
                && Objects.equals(this.network, apiToken.network)
                && Objects.equals(this.tokenWindow, apiToken.tokenWindow)
                && Objects.equals(this.userId, apiToken.userId) && Objects.equals(this.link, apiToken.link);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientName, created, expiresAt, id, lastUpdated, name, network, tokenWindow, userId, link);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiToken {\n");
        sb.append("    clientName: ").append(toIndentedString(clientName)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    network: ").append(toIndentedString(network)).append("\n");
        sb.append("    tokenWindow: ").append(toIndentedString(tokenWindow)).append("\n");
        sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("    link: ").append(toIndentedString(link)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
