package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Information used to generate the secret JSON Web Token for the token requests to Apple IdP &gt; **Note:** The
 * &#x60;privateKey&#x60; property is required for a CREATE request. For an UPDATE request, it can be null and keeps the
 * existing value if it&#39;s null. The &#x60;privateKey&#x60; property isn&#39;t returned for LIST and GET requests or
 * UPDATE requests if it&#39;s null.
 */
@ApiModel(description = "Information used to generate the secret JSON Web Token for the token requests to Apple IdP > **Note:** The `privateKey` property is required for a CREATE request. For an UPDATE request, it can be null and keeps the existing value if it's null. The `privateKey` property isn't returned for LIST and GET requests or UPDATE requests if it's null.")
@JsonPropertyOrder({ AppleClientSigning.JSON_PROPERTY_KID, AppleClientSigning.JSON_PROPERTY_PRIVATE_KEY,
        AppleClientSigning.JSON_PROPERTY_TEAM_ID })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class AppleClientSigning implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;

    public static final String JSON_PROPERTY_PRIVATE_KEY = "privateKey";
    private String privateKey;

    public static final String JSON_PROPERTY_TEAM_ID = "teamId";
    private String teamId;

    public AppleClientSigning() {
    }

    public AppleClientSigning kid(String kid) {

        this.kid = kid;
        return this;
    }

    /**
     * The Key ID that you obtained from Apple when you created the private key for the client
     *
     * @return kid
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "test key id", value = "The Key ID that you obtained from Apple when you created the private key for the client")
    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKid() {
        return kid;
    }

    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    public AppleClientSigning privateKey(String privateKey) {

        this.privateKey = privateKey;
        return this;
    }

    /**
     * The PKCS \\#8 encoded private key that you created for the client and downloaded from Apple
     *
     * @return privateKey
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "MIGTAgEAMBM........Cb9PnybCnzDv+3cWSGWqpAIsQQZ", value = "The PKCS \\#8 encoded private key that you created for the client and downloaded from Apple")
    @JsonProperty(JSON_PROPERTY_PRIVATE_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPrivateKey() {
        return privateKey;
    }

    @JsonProperty(JSON_PROPERTY_PRIVATE_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public AppleClientSigning teamId(String teamId) {

        this.teamId = teamId;
        return this;
    }

    /**
     * The Team ID associated with your Apple developer account
     *
     * @return teamId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "test team id", value = "The Team ID associated with your Apple developer account")
    @JsonProperty(JSON_PROPERTY_TEAM_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTeamId() {
        return teamId;
    }

    @JsonProperty(JSON_PROPERTY_TEAM_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AppleClientSigning appleClientSigning = (AppleClientSigning) o;
        return Objects.equals(this.kid, appleClientSigning.kid)
                && Objects.equals(this.privateKey, appleClientSigning.privateKey)
                && Objects.equals(this.teamId, appleClientSigning.teamId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(kid, privateKey, teamId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppleClientSigning {\n");
        sb.append("    kid: ").append(toIndentedString(kid)).append("\n");
        sb.append("    privateKey: ").append(toIndentedString(privateKey)).append("\n");
        sb.append("    teamId: ").append(toIndentedString(teamId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
