package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationCredentialsSigningUse;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * App signing key properties &gt; **Note:** Only apps with SAML_2_0, SAML_1_1, WS_FEDERATION, or OPENID_CONNECT
 * &#x60;signOnMode&#x60; support the key rotation feature.
 */
@ApiModel(description = "App signing key properties > **Note:** Only apps with SAML_2_0, SAML_1_1, WS_FEDERATION, or OPENID_CONNECT `signOnMode` support the key rotation feature. ")
@JsonPropertyOrder({ ApplicationCredentialsSigning.JSON_PROPERTY_KID,
        ApplicationCredentialsSigning.JSON_PROPERTY_LAST_ROTATED,
        ApplicationCredentialsSigning.JSON_PROPERTY_NEXT_ROTATION,
        ApplicationCredentialsSigning.JSON_PROPERTY_ROTATION_MODE, ApplicationCredentialsSigning.JSON_PROPERTY_USE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ApplicationCredentialsSigning implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;

    public static final String JSON_PROPERTY_LAST_ROTATED = "lastRotated";
    private OffsetDateTime lastRotated;

    public static final String JSON_PROPERTY_NEXT_ROTATION = "nextRotation";
    private OffsetDateTime nextRotation;

    public static final String JSON_PROPERTY_ROTATION_MODE = "rotationMode";
    private String rotationMode;

    public static final String JSON_PROPERTY_USE = "use";
    private ApplicationCredentialsSigningUse use;

    public ApplicationCredentialsSigning() {
    }

    /*
     * @JsonCreator public ApplicationCredentialsSigning(
     *
     * @JsonProperty(JSON_PROPERTY_LAST_ROTATED) OffsetDateTime lastRotated,
     *
     * @JsonProperty(JSON_PROPERTY_NEXT_ROTATION) OffsetDateTime nextRotation ) { this(); this.lastRotated =
     * lastRotated; this.nextRotation = nextRotation; }
     */

    public ApplicationCredentialsSigning kid(String kid) {

        this.kid = kid;
        return this;
    }

    /**
     * Key identifier used for signing assertions &gt; **Note:** Currently, only the X.509 JWK format is supported for
     * apps with SAML_2_0 &#x60;signOnMode&#x60;.
     *
     * @return kid
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Key identifier used for signing assertions > **Note:** Currently, only the X.509 JWK format is supported for apps with SAML_2_0 `signOnMode`.")
    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKid() {
        return kid;
    }

    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    /**
     * Timestamp when the signing key was last rotated
     *
     * @return lastRotated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the signing key was last rotated")
    @JsonProperty(JSON_PROPERTY_LAST_ROTATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastRotated() {
        return lastRotated;
    }

    /**
     * The scheduled time for the next signing key rotation
     *
     * @return nextRotation
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The scheduled time for the next signing key rotation")
    @JsonProperty(JSON_PROPERTY_NEXT_ROTATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getNextRotation() {
        return nextRotation;
    }

    public ApplicationCredentialsSigning rotationMode(String rotationMode) {

        this.rotationMode = rotationMode;
        return this;
    }

    /**
     * The mode of key rotation
     *
     * @return rotationMode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The mode of key rotation")
    @JsonProperty(JSON_PROPERTY_ROTATION_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRotationMode() {
        return rotationMode;
    }

    @JsonProperty(JSON_PROPERTY_ROTATION_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRotationMode(String rotationMode) {
        this.rotationMode = rotationMode;
    }

    public ApplicationCredentialsSigning use(ApplicationCredentialsSigningUse use) {

        this.use = use;
        return this;
    }

    /**
     * Get use
     *
     * @return use
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationCredentialsSigningUse getUse() {
        return use;
    }

    @JsonProperty(JSON_PROPERTY_USE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUse(ApplicationCredentialsSigningUse use) {
        this.use = use;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplicationCredentialsSigning applicationCredentialsSigning = (ApplicationCredentialsSigning) o;
        return Objects.equals(this.kid, applicationCredentialsSigning.kid)
                && Objects.equals(this.lastRotated, applicationCredentialsSigning.lastRotated)
                && Objects.equals(this.nextRotation, applicationCredentialsSigning.nextRotation)
                && Objects.equals(this.rotationMode, applicationCredentialsSigning.rotationMode)
                && Objects.equals(this.use, applicationCredentialsSigning.use);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(kid, lastRotated, nextRotation, rotationMode, use);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationCredentialsSigning {\n");
        sb.append("    kid: ").append(toIndentedString(kid)).append("\n");
        sb.append("    lastRotated: ").append(toIndentedString(lastRotated)).append("\n");
        sb.append("    nextRotation: ").append(toIndentedString(nextRotation)).append("\n");
        sb.append("    rotationMode: ").append(toIndentedString(rotationMode)).append("\n");
        sb.append("    use: ").append(toIndentedString(use)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
