package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationVisibilityHide;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies visibility settings for the app
 */
@ApiModel(description = "Specifies visibility settings for the app")
@JsonPropertyOrder({ ApplicationVisibility.JSON_PROPERTY_APP_LINKS, ApplicationVisibility.JSON_PROPERTY_AUTO_LAUNCH,
        ApplicationVisibility.JSON_PROPERTY_AUTO_SUBMIT_TOOLBAR, ApplicationVisibility.JSON_PROPERTY_HIDE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ApplicationVisibility implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_APP_LINKS = "appLinks";
    private Map<String, Boolean> appLinks = null;

    public static final String JSON_PROPERTY_AUTO_LAUNCH = "autoLaunch";
    private Boolean autoLaunch;

    public static final String JSON_PROPERTY_AUTO_SUBMIT_TOOLBAR = "autoSubmitToolbar";
    private Boolean autoSubmitToolbar;

    public static final String JSON_PROPERTY_HIDE = "hide";
    private ApplicationVisibilityHide hide;

    public ApplicationVisibility() {
    }

    public ApplicationVisibility appLinks(Map<String, Boolean> appLinks) {

        this.appLinks = appLinks;
        return this;
    }

    public ApplicationVisibility putappLinksItem(String key, Boolean appLinksItem) {
        if (this.appLinks == null) {
            this.appLinks = new HashMap<>();
        }
        this.appLinks.put(key, appLinksItem);
        return this;
    }

    /**
     * Links or icons that appear on the End-User Dashboard if they&#39;re set to &#x60;true&#x60;.
     *
     * @return appLinks
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Links or icons that appear on the End-User Dashboard if they're set to `true`.")
    @JsonProperty(JSON_PROPERTY_APP_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Boolean> getAppLinks() {
        return appLinks;
    }

    @JsonProperty(JSON_PROPERTY_APP_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAppLinks(Map<String, Boolean> appLinks) {
        this.appLinks = appLinks;
    }

    public ApplicationVisibility autoLaunch(Boolean autoLaunch) {

        this.autoLaunch = autoLaunch;
        return this;
    }

    /**
     * Automatically signs in to the app when user signs into Okta
     *
     * @return autoLaunch
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Automatically signs in to the app when user signs into Okta")
    @JsonProperty(JSON_PROPERTY_AUTO_LAUNCH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getAutoLaunch() {
        return autoLaunch;
    }

    @JsonProperty(JSON_PROPERTY_AUTO_LAUNCH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAutoLaunch(Boolean autoLaunch) {
        this.autoLaunch = autoLaunch;
    }

    public ApplicationVisibility autoSubmitToolbar(Boolean autoSubmitToolbar) {

        this.autoSubmitToolbar = autoSubmitToolbar;
        return this;
    }

    /**
     * Automatically sign in when user lands on the sign-in page
     *
     * @return autoSubmitToolbar
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Automatically sign in when user lands on the sign-in page")
    @JsonProperty(JSON_PROPERTY_AUTO_SUBMIT_TOOLBAR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getAutoSubmitToolbar() {
        return autoSubmitToolbar;
    }

    @JsonProperty(JSON_PROPERTY_AUTO_SUBMIT_TOOLBAR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAutoSubmitToolbar(Boolean autoSubmitToolbar) {
        this.autoSubmitToolbar = autoSubmitToolbar;
    }

    public ApplicationVisibility hide(ApplicationVisibilityHide hide) {

        this.hide = hide;
        return this;
    }

    /**
     * Get hide
     *
     * @return hide
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_HIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationVisibilityHide getHide() {
        return hide;
    }

    @JsonProperty(JSON_PROPERTY_HIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHide(ApplicationVisibilityHide hide) {
        this.hide = hide;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplicationVisibility applicationVisibility = (ApplicationVisibility) o;
        return Objects.equals(this.appLinks, applicationVisibility.appLinks)
                && Objects.equals(this.autoLaunch, applicationVisibility.autoLaunch)
                && Objects.equals(this.autoSubmitToolbar, applicationVisibility.autoSubmitToolbar)
                && Objects.equals(this.hide, applicationVisibility.hide);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(appLinks, autoLaunch, autoSubmitToolbar, hide);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationVisibility {\n");
        sb.append("    appLinks: ").append(toIndentedString(appLinks)).append("\n");
        sb.append("    autoLaunch: ").append(toIndentedString(autoLaunch)).append("\n");
        sb.append("    autoSubmitToolbar: ").append(toIndentedString(autoSubmitToolbar)).append("\n");
        sb.append("    hide: ").append(toIndentedString(hide)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
