package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthServerLinksAllOfClaims;
import com.okta.sdk.resource.model.AuthServerLinksAllOfPolicies;
import com.okta.sdk.resource.model.AuthServerLinksAllOfRotateKey;
import com.okta.sdk.resource.model.AuthServerLinksAllOfScopes;
import com.okta.sdk.resource.model.HrefObject;
import com.okta.sdk.resource.model.HrefObjectDeactivateLink;
import com.okta.sdk.resource.model.HrefObjectSelfLink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthServerLinks
 */
@JsonPropertyOrder({ AuthServerLinks.JSON_PROPERTY_SELF, AuthServerLinks.JSON_PROPERTY_CLAIMS,
        AuthServerLinks.JSON_PROPERTY_DEACTIVATE, AuthServerLinks.JSON_PROPERTY_METADATA,
        AuthServerLinks.JSON_PROPERTY_POLICIES, AuthServerLinks.JSON_PROPERTY_ROTATE_KEY,
        AuthServerLinks.JSON_PROPERTY_SCOPES })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class AuthServerLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SELF = "self";
    private HrefObjectSelfLink self;

    public static final String JSON_PROPERTY_CLAIMS = "claims";
    private AuthServerLinksAllOfClaims claims;

    public static final String JSON_PROPERTY_DEACTIVATE = "deactivate";
    private HrefObjectDeactivateLink deactivate;

    public static final String JSON_PROPERTY_METADATA = "metadata";
    private List<HrefObject> metadata = null;

    public static final String JSON_PROPERTY_POLICIES = "policies";
    private AuthServerLinksAllOfPolicies policies;

    public static final String JSON_PROPERTY_ROTATE_KEY = "rotateKey";
    private AuthServerLinksAllOfRotateKey rotateKey;

    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private AuthServerLinksAllOfScopes scopes;

    public AuthServerLinks() {
    }

    public AuthServerLinks self(HrefObjectSelfLink self) {

        this.self = self;
        return this;
    }

    /**
     * Get self
     *
     * @return self
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectSelfLink getSelf() {
        return self;
    }

    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSelf(HrefObjectSelfLink self) {
        this.self = self;
    }

    public AuthServerLinks claims(AuthServerLinksAllOfClaims claims) {

        this.claims = claims;
        return this;
    }

    /**
     * Get claims
     *
     * @return claims
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CLAIMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthServerLinksAllOfClaims getClaims() {
        return claims;
    }

    @JsonProperty(JSON_PROPERTY_CLAIMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClaims(AuthServerLinksAllOfClaims claims) {
        this.claims = claims;
    }

    public AuthServerLinks deactivate(HrefObjectDeactivateLink deactivate) {

        this.deactivate = deactivate;
        return this;
    }

    /**
     * Get deactivate
     *
     * @return deactivate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DEACTIVATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectDeactivateLink getDeactivate() {
        return deactivate;
    }

    @JsonProperty(JSON_PROPERTY_DEACTIVATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDeactivate(HrefObjectDeactivateLink deactivate) {
        this.deactivate = deactivate;
    }

    public AuthServerLinks metadata(List<HrefObject> metadata) {

        this.metadata = metadata;
        return this;
    }

    public AuthServerLinks addmetadataItem(HrefObject metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    /**
     * Link to the authorization server metadata
     *
     * @return metadata
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Link to the authorization server metadata")
    @JsonProperty(JSON_PROPERTY_METADATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<HrefObject> getMetadata() {
        return metadata;
    }

    @JsonProperty(JSON_PROPERTY_METADATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(List<HrefObject> metadata) {
        this.metadata = metadata;
    }

    public AuthServerLinks policies(AuthServerLinksAllOfPolicies policies) {

        this.policies = policies;
        return this;
    }

    /**
     * Get policies
     *
     * @return policies
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_POLICIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthServerLinksAllOfPolicies getPolicies() {
        return policies;
    }

    @JsonProperty(JSON_PROPERTY_POLICIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPolicies(AuthServerLinksAllOfPolicies policies) {
        this.policies = policies;
    }

    public AuthServerLinks rotateKey(AuthServerLinksAllOfRotateKey rotateKey) {

        this.rotateKey = rotateKey;
        return this;
    }

    /**
     * Get rotateKey
     *
     * @return rotateKey
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ROTATE_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthServerLinksAllOfRotateKey getRotateKey() {
        return rotateKey;
    }

    @JsonProperty(JSON_PROPERTY_ROTATE_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRotateKey(AuthServerLinksAllOfRotateKey rotateKey) {
        this.rotateKey = rotateKey;
    }

    public AuthServerLinks scopes(AuthServerLinksAllOfScopes scopes) {

        this.scopes = scopes;
        return this;
    }

    /**
     * Get scopes
     *
     * @return scopes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthServerLinksAllOfScopes getScopes() {
        return scopes;
    }

    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(AuthServerLinksAllOfScopes scopes) {
        this.scopes = scopes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthServerLinks authServerLinks = (AuthServerLinks) o;
        return Objects.equals(this.self, authServerLinks.self) && Objects.equals(this.claims, authServerLinks.claims)
                && Objects.equals(this.deactivate, authServerLinks.deactivate)
                && Objects.equals(this.metadata, authServerLinks.metadata)
                && Objects.equals(this.policies, authServerLinks.policies)
                && Objects.equals(this.rotateKey, authServerLinks.rotateKey)
                && Objects.equals(this.scopes, authServerLinks.scopes);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(self, claims, deactivate, metadata, policies, rotateKey, scopes);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthServerLinks {\n");
        sb.append("    self: ").append(toIndentedString(self)).append("\n");
        sb.append("    claims: ").append(toIndentedString(claims)).append("\n");
        sb.append("    deactivate: ").append(toIndentedString(deactivate)).append("\n");
        sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
        sb.append("    policies: ").append(toIndentedString(policies)).append("\n");
        sb.append("    rotateKey: ").append(toIndentedString(rotateKey)).append("\n");
        sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
