package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticatorKeyDuoAllOfProviderConfigurationUserNameTemplate;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticatorKeyDuoAllOfProviderConfiguration
 */
@JsonPropertyOrder({ AuthenticatorKeyDuoAllOfProviderConfiguration.JSON_PROPERTY_HOST,
        AuthenticatorKeyDuoAllOfProviderConfiguration.JSON_PROPERTY_INTEGRATION_KEY,
        AuthenticatorKeyDuoAllOfProviderConfiguration.JSON_PROPERTY_SECRET_KEY,
        AuthenticatorKeyDuoAllOfProviderConfiguration.JSON_PROPERTY_USER_NAME_TEMPLATE })
@JsonTypeName("AuthenticatorKeyDuo_allOf_provider_configuration")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class AuthenticatorKeyDuoAllOfProviderConfiguration implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_HOST = "host";
    private String host;

    public static final String JSON_PROPERTY_INTEGRATION_KEY = "integrationKey";
    private String integrationKey;

    public static final String JSON_PROPERTY_SECRET_KEY = "secretKey";
    private String secretKey;

    public static final String JSON_PROPERTY_USER_NAME_TEMPLATE = "userNameTemplate";
    private AuthenticatorKeyDuoAllOfProviderConfigurationUserNameTemplate userNameTemplate;

    public AuthenticatorKeyDuoAllOfProviderConfiguration() {
    }

    public AuthenticatorKeyDuoAllOfProviderConfiguration host(String host) {

        this.host = host;
        return this;
    }

    /**
     * The Duo Security API hostname
     *
     * @return host
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The Duo Security API hostname")
    @JsonProperty(JSON_PROPERTY_HOST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getHost() {
        return host;
    }

    @JsonProperty(JSON_PROPERTY_HOST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHost(String host) {
        this.host = host;
    }

    public AuthenticatorKeyDuoAllOfProviderConfiguration integrationKey(String integrationKey) {

        this.integrationKey = integrationKey;
        return this;
    }

    /**
     * The Duo Security integration key
     *
     * @return integrationKey
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The Duo Security integration key")
    @JsonProperty(JSON_PROPERTY_INTEGRATION_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIntegrationKey() {
        return integrationKey;
    }

    @JsonProperty(JSON_PROPERTY_INTEGRATION_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIntegrationKey(String integrationKey) {
        this.integrationKey = integrationKey;
    }

    public AuthenticatorKeyDuoAllOfProviderConfiguration secretKey(String secretKey) {

        this.secretKey = secretKey;
        return this;
    }

    /**
     * The Duo Security secret key
     *
     * @return secretKey
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The Duo Security secret key")
    @JsonProperty(JSON_PROPERTY_SECRET_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSecretKey() {
        return secretKey;
    }

    @JsonProperty(JSON_PROPERTY_SECRET_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public AuthenticatorKeyDuoAllOfProviderConfiguration userNameTemplate(
            AuthenticatorKeyDuoAllOfProviderConfigurationUserNameTemplate userNameTemplate) {

        this.userNameTemplate = userNameTemplate;
        return this;
    }

    /**
     * Get userNameTemplate
     *
     * @return userNameTemplate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER_NAME_TEMPLATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthenticatorKeyDuoAllOfProviderConfigurationUserNameTemplate getUserNameTemplate() {
        return userNameTemplate;
    }

    @JsonProperty(JSON_PROPERTY_USER_NAME_TEMPLATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserNameTemplate(AuthenticatorKeyDuoAllOfProviderConfigurationUserNameTemplate userNameTemplate) {
        this.userNameTemplate = userNameTemplate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorKeyDuoAllOfProviderConfiguration authenticatorKeyDuoAllOfProviderConfiguration = (AuthenticatorKeyDuoAllOfProviderConfiguration) o;
        return Objects.equals(this.host, authenticatorKeyDuoAllOfProviderConfiguration.host)
                && Objects.equals(this.integrationKey, authenticatorKeyDuoAllOfProviderConfiguration.integrationKey)
                && Objects.equals(this.secretKey, authenticatorKeyDuoAllOfProviderConfiguration.secretKey) && Objects
                        .equals(this.userNameTemplate, authenticatorKeyDuoAllOfProviderConfiguration.userNameTemplate);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(host, integrationKey, secretKey, userNameTemplate);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorKeyDuoAllOfProviderConfiguration {\n");
        sb.append("    host: ").append(toIndentedString(host)).append("\n");
        sb.append("    integrationKey: ").append(toIndentedString(integrationKey)).append("\n");
        sb.append("    secretKey: ").append(toIndentedString(secretKey)).append("\n");
        sb.append("    userNameTemplate: ").append(toIndentedString(userNameTemplate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
