package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ChannelBinding;
import com.okta.sdk.resource.model.Compliance;
import com.okta.sdk.resource.model.UserVerificationEnum;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticatorKeyOktaVerifyAllOfSettings
 */
@JsonPropertyOrder({ AuthenticatorKeyOktaVerifyAllOfSettings.JSON_PROPERTY_CHANNEL_BINDING,
        AuthenticatorKeyOktaVerifyAllOfSettings.JSON_PROPERTY_COMPLIANCE,
        AuthenticatorKeyOktaVerifyAllOfSettings.JSON_PROPERTY_USER_VERIFICATION,
        AuthenticatorKeyOktaVerifyAllOfSettings.JSON_PROPERTY_APP_INSTANCE_ID })
@JsonTypeName("AuthenticatorKeyOktaVerify_allOf_settings")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class AuthenticatorKeyOktaVerifyAllOfSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CHANNEL_BINDING = "channelBinding";
    private ChannelBinding channelBinding;

    public static final String JSON_PROPERTY_COMPLIANCE = "compliance";
    private Compliance compliance;

    public static final String JSON_PROPERTY_USER_VERIFICATION = "userVerification";
    private UserVerificationEnum userVerification;

    public static final String JSON_PROPERTY_APP_INSTANCE_ID = "appInstanceId";
    private String appInstanceId;

    public AuthenticatorKeyOktaVerifyAllOfSettings() {
    }

    public AuthenticatorKeyOktaVerifyAllOfSettings channelBinding(ChannelBinding channelBinding) {

        this.channelBinding = channelBinding;
        return this;
    }

    /**
     * Get channelBinding
     *
     * @return channelBinding
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CHANNEL_BINDING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ChannelBinding getChannelBinding() {
        return channelBinding;
    }

    @JsonProperty(JSON_PROPERTY_CHANNEL_BINDING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setChannelBinding(ChannelBinding channelBinding) {
        this.channelBinding = channelBinding;
    }

    public AuthenticatorKeyOktaVerifyAllOfSettings compliance(Compliance compliance) {

        this.compliance = compliance;
        return this;
    }

    /**
     * Get compliance
     *
     * @return compliance
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_COMPLIANCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Compliance getCompliance() {
        return compliance;
    }

    @JsonProperty(JSON_PROPERTY_COMPLIANCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCompliance(Compliance compliance) {
        this.compliance = compliance;
    }

    public AuthenticatorKeyOktaVerifyAllOfSettings userVerification(UserVerificationEnum userVerification) {

        this.userVerification = userVerification;
        return this;
    }

    /**
     * Get userVerification
     *
     * @return userVerification
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER_VERIFICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserVerificationEnum getUserVerification() {
        return userVerification;
    }

    @JsonProperty(JSON_PROPERTY_USER_VERIFICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserVerification(UserVerificationEnum userVerification) {
        this.userVerification = userVerification;
    }

    public AuthenticatorKeyOktaVerifyAllOfSettings appInstanceId(String appInstanceId) {

        this.appInstanceId = appInstanceId;
        return this;
    }

    /**
     * The application instance ID
     *
     * @return appInstanceId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The application instance ID")
    @JsonProperty(JSON_PROPERTY_APP_INSTANCE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAppInstanceId() {
        return appInstanceId;
    }

    @JsonProperty(JSON_PROPERTY_APP_INSTANCE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAppInstanceId(String appInstanceId) {
        this.appInstanceId = appInstanceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorKeyOktaVerifyAllOfSettings authenticatorKeyOktaVerifyAllOfSettings = (AuthenticatorKeyOktaVerifyAllOfSettings) o;
        return Objects.equals(this.channelBinding, authenticatorKeyOktaVerifyAllOfSettings.channelBinding)
                && Objects.equals(this.compliance, authenticatorKeyOktaVerifyAllOfSettings.compliance)
                && Objects.equals(this.userVerification, authenticatorKeyOktaVerifyAllOfSettings.userVerification)
                && Objects.equals(this.appInstanceId, authenticatorKeyOktaVerifyAllOfSettings.appInstanceId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(channelBinding, compliance, userVerification, appInstanceId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorKeyOktaVerifyAllOfSettings {\n");
        sb.append("    channelBinding: ").append(toIndentedString(channelBinding)).append("\n");
        sb.append("    compliance: ").append(toIndentedString(compliance)).append("\n");
        sb.append("    userVerification: ").append(toIndentedString(userVerification)).append("\n");
        sb.append("    appInstanceId: ").append(toIndentedString(appInstanceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
