package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IdentitySourceUserProfileForDelete;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * BulkDeleteRequestBody
 */
@JsonPropertyOrder({ BulkDeleteRequestBody.JSON_PROPERTY_ENTITY_TYPE, BulkDeleteRequestBody.JSON_PROPERTY_PROFILES })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class BulkDeleteRequestBody implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Gets or Sets entityType
     */
    public enum EntityTypeEnum {
        USERS(String.valueOf("USERS")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        EntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static EntityTypeEnum fromValue(String value) {
            for (EntityTypeEnum b : EntityTypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
    private EntityTypeEnum entityType;

    public static final String JSON_PROPERTY_PROFILES = "profiles";
    private List<IdentitySourceUserProfileForDelete> profiles = null;

    public BulkDeleteRequestBody() {
    }

    public BulkDeleteRequestBody entityType(EntityTypeEnum entityType) {

        this.entityType = entityType;
        return this;
    }

    /**
     * Get entityType
     *
     * @return entityType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ENTITY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EntityTypeEnum getEntityType() {
        return entityType;
    }

    @JsonProperty(JSON_PROPERTY_ENTITY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
    }

    public BulkDeleteRequestBody profiles(List<IdentitySourceUserProfileForDelete> profiles) {

        this.profiles = profiles;
        return this;
    }

    public BulkDeleteRequestBody addprofilesItem(IdentitySourceUserProfileForDelete profilesItem) {
        if (this.profiles == null) {
            this.profiles = new ArrayList<>();
        }
        this.profiles.add(profilesItem);
        return this;
    }

    /**
     * Get profiles
     *
     * @return profiles
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROFILES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<IdentitySourceUserProfileForDelete> getProfiles() {
        return profiles;
    }

    @JsonProperty(JSON_PROPERTY_PROFILES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfiles(List<IdentitySourceUserProfileForDelete> profiles) {
        this.profiles = profiles;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BulkDeleteRequestBody bulkDeleteRequestBody = (BulkDeleteRequestBody) o;
        return Objects.equals(this.entityType, bulkDeleteRequestBody.entityType)
                && Objects.equals(this.profiles, bulkDeleteRequestBody.profiles);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(entityType, profiles);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkDeleteRequestBody {\n");
        sb.append("    entityType: ").append(toIndentedString(entityType)).append("\n");
        sb.append("    profiles: ").append(toIndentedString(profiles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
