package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ImportScheduleObject;
import com.okta.sdk.resource.model.ImportUsernameObject;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Defines import settings
 */
@ApiModel(description = "Defines import settings")
@JsonPropertyOrder({ CapabilitiesImportSettingsObject.JSON_PROPERTY_SCHEDULE,
        CapabilitiesImportSettingsObject.JSON_PROPERTY_USERNAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class CapabilitiesImportSettingsObject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SCHEDULE = "schedule";
    private ImportScheduleObject schedule;

    public static final String JSON_PROPERTY_USERNAME = "username";
    private ImportUsernameObject username;

    public CapabilitiesImportSettingsObject() {
    }

    public CapabilitiesImportSettingsObject schedule(ImportScheduleObject schedule) {

        this.schedule = schedule;
        return this;
    }

    /**
     * Get schedule
     *
     * @return schedule
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SCHEDULE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ImportScheduleObject getSchedule() {
        return schedule;
    }

    @JsonProperty(JSON_PROPERTY_SCHEDULE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSchedule(ImportScheduleObject schedule) {
        this.schedule = schedule;
    }

    public CapabilitiesImportSettingsObject username(ImportUsernameObject username) {

        this.username = username;
        return this;
    }

    /**
     * Get username
     *
     * @return username
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USERNAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ImportUsernameObject getUsername() {
        return username;
    }

    @JsonProperty(JSON_PROPERTY_USERNAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(ImportUsernameObject username) {
        this.username = username;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CapabilitiesImportSettingsObject capabilitiesImportSettingsObject = (CapabilitiesImportSettingsObject) o;
        return Objects.equals(this.schedule, capabilitiesImportSettingsObject.schedule)
                && Objects.equals(this.username, capabilitiesImportSettingsObject.username);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(schedule, username);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapabilitiesImportSettingsObject {\n");
        sb.append("    schedule: ").append(toIndentedString(schedule)).append("\n");
        sb.append("    username: ").append(toIndentedString(username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
