package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ChromeBrowserVersion;
import com.okta.sdk.resource.model.KeyTrustLevelOSMode;
import com.okta.sdk.resource.model.OSVersionFourComponents;
import com.okta.sdk.resource.model.PasswordProtectionWarningTrigger;
import com.okta.sdk.resource.model.SafeBrowsingProtectionLevel;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Google Chrome Device Trust Connector provider
 */
@ApiModel(description = "Google Chrome Device Trust Connector provider")
@JsonPropertyOrder({ DTCChromeOS.JSON_PROPERTY_ALLOW_SCREEN_LOCK, DTCChromeOS.JSON_PROPERTY_BROWSER_VERSION,
        DTCChromeOS.JSON_PROPERTY_BUILT_IN_DNS_CLIENT_ENABLED,
        DTCChromeOS.JSON_PROPERTY_CHROME_REMOTE_DESKTOP_APP_BLOCKED, DTCChromeOS.JSON_PROPERTY_DEVICE_ENROLLMENT_DOMAIN,
        DTCChromeOS.JSON_PROPERTY_DISK_ENCRYPTED, DTCChromeOS.JSON_PROPERTY_KEY_TRUST_LEVEL,
        DTCChromeOS.JSON_PROPERTY_MANAGED_DEVICE, DTCChromeOS.JSON_PROPERTY_OS_FIREWALL,
        DTCChromeOS.JSON_PROPERTY_OS_VERSION, DTCChromeOS.JSON_PROPERTY_PASSWORD_PROTECTION_WARNING_TRIGGER,
        DTCChromeOS.JSON_PROPERTY_REALTIME_URL_CHECK_MODE, DTCChromeOS.JSON_PROPERTY_SAFE_BROWSING_PROTECTION_LEVEL,
        DTCChromeOS.JSON_PROPERTY_SCREEN_LOCK_SECURED, DTCChromeOS.JSON_PROPERTY_SITE_ISOLATION_ENABLED })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class DTCChromeOS implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALLOW_SCREEN_LOCK = "allowScreenLock";
    private Boolean allowScreenLock;

    public static final String JSON_PROPERTY_BROWSER_VERSION = "browserVersion";
    private ChromeBrowserVersion browserVersion;

    public static final String JSON_PROPERTY_BUILT_IN_DNS_CLIENT_ENABLED = "builtInDnsClientEnabled";
    private Boolean builtInDnsClientEnabled;

    public static final String JSON_PROPERTY_CHROME_REMOTE_DESKTOP_APP_BLOCKED = "chromeRemoteDesktopAppBlocked";
    private Boolean chromeRemoteDesktopAppBlocked;

    public static final String JSON_PROPERTY_DEVICE_ENROLLMENT_DOMAIN = "deviceEnrollmentDomain";
    private String deviceEnrollmentDomain;

    public static final String JSON_PROPERTY_DISK_ENCRYPTED = "diskEncrypted";
    private Boolean diskEncrypted;

    public static final String JSON_PROPERTY_KEY_TRUST_LEVEL = "keyTrustLevel";
    private KeyTrustLevelOSMode keyTrustLevel;

    public static final String JSON_PROPERTY_MANAGED_DEVICE = "managedDevice";
    private Boolean managedDevice;

    public static final String JSON_PROPERTY_OS_FIREWALL = "osFirewall";
    private Boolean osFirewall;

    public static final String JSON_PROPERTY_OS_VERSION = "osVersion";
    private OSVersionFourComponents osVersion;

    public static final String JSON_PROPERTY_PASSWORD_PROTECTION_WARNING_TRIGGER = "passwordProtectionWarningTrigger";
    private PasswordProtectionWarningTrigger passwordProtectionWarningTrigger;

    public static final String JSON_PROPERTY_REALTIME_URL_CHECK_MODE = "realtimeUrlCheckMode";
    private Boolean realtimeUrlCheckMode;

    public static final String JSON_PROPERTY_SAFE_BROWSING_PROTECTION_LEVEL = "safeBrowsingProtectionLevel";
    private SafeBrowsingProtectionLevel safeBrowsingProtectionLevel;

    public static final String JSON_PROPERTY_SCREEN_LOCK_SECURED = "screenLockSecured";
    private Boolean screenLockSecured;

    public static final String JSON_PROPERTY_SITE_ISOLATION_ENABLED = "siteIsolationEnabled";
    private Boolean siteIsolationEnabled;

    public DTCChromeOS() {
    }

    public DTCChromeOS allowScreenLock(Boolean allowScreenLock) {

        this.allowScreenLock = allowScreenLock;
        return this;
    }

    /**
     * Indicates whether the AllowScreenLock enterprise policy is enabled
     *
     * @return allowScreenLock
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether the AllowScreenLock enterprise policy is enabled")
    @JsonProperty(JSON_PROPERTY_ALLOW_SCREEN_LOCK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getAllowScreenLock() {
        return allowScreenLock;
    }

    @JsonProperty(JSON_PROPERTY_ALLOW_SCREEN_LOCK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAllowScreenLock(Boolean allowScreenLock) {
        this.allowScreenLock = allowScreenLock;
    }

    public DTCChromeOS browserVersion(ChromeBrowserVersion browserVersion) {

        this.browserVersion = browserVersion;
        return this;
    }

    /**
     * Get browserVersion
     *
     * @return browserVersion
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_BROWSER_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ChromeBrowserVersion getBrowserVersion() {
        return browserVersion;
    }

    @JsonProperty(JSON_PROPERTY_BROWSER_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBrowserVersion(ChromeBrowserVersion browserVersion) {
        this.browserVersion = browserVersion;
    }

    public DTCChromeOS builtInDnsClientEnabled(Boolean builtInDnsClientEnabled) {

        this.builtInDnsClientEnabled = builtInDnsClientEnabled;
        return this;
    }

    /**
     * Indicates if a software stack is used to communicate with the DNS server
     *
     * @return builtInDnsClientEnabled
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if a software stack is used to communicate with the DNS server")
    @JsonProperty(JSON_PROPERTY_BUILT_IN_DNS_CLIENT_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getBuiltInDnsClientEnabled() {
        return builtInDnsClientEnabled;
    }

    @JsonProperty(JSON_PROPERTY_BUILT_IN_DNS_CLIENT_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBuiltInDnsClientEnabled(Boolean builtInDnsClientEnabled) {
        this.builtInDnsClientEnabled = builtInDnsClientEnabled;
    }

    public DTCChromeOS chromeRemoteDesktopAppBlocked(Boolean chromeRemoteDesktopAppBlocked) {

        this.chromeRemoteDesktopAppBlocked = chromeRemoteDesktopAppBlocked;
        return this;
    }

    /**
     * Indicates whether access to the Chrome Remote Desktop application is blocked through a policy
     *
     * @return chromeRemoteDesktopAppBlocked
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether access to the Chrome Remote Desktop application is blocked through a policy")
    @JsonProperty(JSON_PROPERTY_CHROME_REMOTE_DESKTOP_APP_BLOCKED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getChromeRemoteDesktopAppBlocked() {
        return chromeRemoteDesktopAppBlocked;
    }

    @JsonProperty(JSON_PROPERTY_CHROME_REMOTE_DESKTOP_APP_BLOCKED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setChromeRemoteDesktopAppBlocked(Boolean chromeRemoteDesktopAppBlocked) {
        this.chromeRemoteDesktopAppBlocked = chromeRemoteDesktopAppBlocked;
    }

    public DTCChromeOS deviceEnrollmentDomain(String deviceEnrollmentDomain) {

        this.deviceEnrollmentDomain = deviceEnrollmentDomain;
        return this;
    }

    /**
     * Enrollment domain of the customer that is currently managing the device
     *
     * @return deviceEnrollmentDomain
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Enrollment domain of the customer that is currently managing the device")
    @JsonProperty(JSON_PROPERTY_DEVICE_ENROLLMENT_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDeviceEnrollmentDomain() {
        return deviceEnrollmentDomain;
    }

    @JsonProperty(JSON_PROPERTY_DEVICE_ENROLLMENT_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceEnrollmentDomain(String deviceEnrollmentDomain) {
        this.deviceEnrollmentDomain = deviceEnrollmentDomain;
    }

    public DTCChromeOS diskEncrypted(Boolean diskEncrypted) {

        this.diskEncrypted = diskEncrypted;
        return this;
    }

    /**
     * Indicates whether the main disk is encrypted
     *
     * @return diskEncrypted
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether the main disk is encrypted")
    @JsonProperty(JSON_PROPERTY_DISK_ENCRYPTED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getDiskEncrypted() {
        return diskEncrypted;
    }

    @JsonProperty(JSON_PROPERTY_DISK_ENCRYPTED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDiskEncrypted(Boolean diskEncrypted) {
        this.diskEncrypted = diskEncrypted;
    }

    public DTCChromeOS keyTrustLevel(KeyTrustLevelOSMode keyTrustLevel) {

        this.keyTrustLevel = keyTrustLevel;
        return this;
    }

    /**
     * Get keyTrustLevel
     *
     * @return keyTrustLevel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_KEY_TRUST_LEVEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public KeyTrustLevelOSMode getKeyTrustLevel() {
        return keyTrustLevel;
    }

    @JsonProperty(JSON_PROPERTY_KEY_TRUST_LEVEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKeyTrustLevel(KeyTrustLevelOSMode keyTrustLevel) {
        this.keyTrustLevel = keyTrustLevel;
    }

    public DTCChromeOS managedDevice(Boolean managedDevice) {

        this.managedDevice = managedDevice;
        return this;
    }

    /**
     * Indicates whether the device is enrolled in ChromeOS device management
     *
     * @return managedDevice
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether the device is enrolled in ChromeOS device management")
    @JsonProperty(JSON_PROPERTY_MANAGED_DEVICE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getManagedDevice() {
        return managedDevice;
    }

    @JsonProperty(JSON_PROPERTY_MANAGED_DEVICE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setManagedDevice(Boolean managedDevice) {
        this.managedDevice = managedDevice;
    }

    public DTCChromeOS osFirewall(Boolean osFirewall) {

        this.osFirewall = osFirewall;
        return this;
    }

    /**
     * Indicates whether a firewall is enabled at the OS-level on the device
     *
     * @return osFirewall
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether a firewall is enabled at the OS-level on the device")
    @JsonProperty(JSON_PROPERTY_OS_FIREWALL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getOsFirewall() {
        return osFirewall;
    }

    @JsonProperty(JSON_PROPERTY_OS_FIREWALL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOsFirewall(Boolean osFirewall) {
        this.osFirewall = osFirewall;
    }

    public DTCChromeOS osVersion(OSVersionFourComponents osVersion) {

        this.osVersion = osVersion;
        return this;
    }

    /**
     * Get osVersion
     *
     * @return osVersion
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OS_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OSVersionFourComponents getOsVersion() {
        return osVersion;
    }

    @JsonProperty(JSON_PROPERTY_OS_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOsVersion(OSVersionFourComponents osVersion) {
        this.osVersion = osVersion;
    }

    public DTCChromeOS passwordProtectionWarningTrigger(
            PasswordProtectionWarningTrigger passwordProtectionWarningTrigger) {

        this.passwordProtectionWarningTrigger = passwordProtectionWarningTrigger;
        return this;
    }

    /**
     * Get passwordProtectionWarningTrigger
     *
     * @return passwordProtectionWarningTrigger
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PASSWORD_PROTECTION_WARNING_TRIGGER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordProtectionWarningTrigger getPasswordProtectionWarningTrigger() {
        return passwordProtectionWarningTrigger;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD_PROTECTION_WARNING_TRIGGER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPasswordProtectionWarningTrigger(PasswordProtectionWarningTrigger passwordProtectionWarningTrigger) {
        this.passwordProtectionWarningTrigger = passwordProtectionWarningTrigger;
    }

    public DTCChromeOS realtimeUrlCheckMode(Boolean realtimeUrlCheckMode) {

        this.realtimeUrlCheckMode = realtimeUrlCheckMode;
        return this;
    }

    /**
     * Indicates whether enterprise-grade (custom) unsafe URL scanning is enabled
     *
     * @return realtimeUrlCheckMode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether enterprise-grade (custom) unsafe URL scanning is enabled")
    @JsonProperty(JSON_PROPERTY_REALTIME_URL_CHECK_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getRealtimeUrlCheckMode() {
        return realtimeUrlCheckMode;
    }

    @JsonProperty(JSON_PROPERTY_REALTIME_URL_CHECK_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRealtimeUrlCheckMode(Boolean realtimeUrlCheckMode) {
        this.realtimeUrlCheckMode = realtimeUrlCheckMode;
    }

    public DTCChromeOS safeBrowsingProtectionLevel(SafeBrowsingProtectionLevel safeBrowsingProtectionLevel) {

        this.safeBrowsingProtectionLevel = safeBrowsingProtectionLevel;
        return this;
    }

    /**
     * Get safeBrowsingProtectionLevel
     *
     * @return safeBrowsingProtectionLevel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SAFE_BROWSING_PROTECTION_LEVEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SafeBrowsingProtectionLevel getSafeBrowsingProtectionLevel() {
        return safeBrowsingProtectionLevel;
    }

    @JsonProperty(JSON_PROPERTY_SAFE_BROWSING_PROTECTION_LEVEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSafeBrowsingProtectionLevel(SafeBrowsingProtectionLevel safeBrowsingProtectionLevel) {
        this.safeBrowsingProtectionLevel = safeBrowsingProtectionLevel;
    }

    public DTCChromeOS screenLockSecured(Boolean screenLockSecured) {

        this.screenLockSecured = screenLockSecured;
        return this;
    }

    /**
     * Indicates whether the device is password-protected
     *
     * @return screenLockSecured
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether the device is password-protected")
    @JsonProperty(JSON_PROPERTY_SCREEN_LOCK_SECURED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getScreenLockSecured() {
        return screenLockSecured;
    }

    @JsonProperty(JSON_PROPERTY_SCREEN_LOCK_SECURED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScreenLockSecured(Boolean screenLockSecured) {
        this.screenLockSecured = screenLockSecured;
    }

    public DTCChromeOS siteIsolationEnabled(Boolean siteIsolationEnabled) {

        this.siteIsolationEnabled = siteIsolationEnabled;
        return this;
    }

    /**
     * Indicates whether the Site Isolation (also known as **Site Per Process**) setting is enabled
     *
     * @return siteIsolationEnabled
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether the Site Isolation (also known as **Site Per Process**) setting is enabled")
    @JsonProperty(JSON_PROPERTY_SITE_ISOLATION_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSiteIsolationEnabled() {
        return siteIsolationEnabled;
    }

    @JsonProperty(JSON_PROPERTY_SITE_ISOLATION_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSiteIsolationEnabled(Boolean siteIsolationEnabled) {
        this.siteIsolationEnabled = siteIsolationEnabled;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DTCChromeOS dtCChromeOS = (DTCChromeOS) o;
        return Objects.equals(this.allowScreenLock, dtCChromeOS.allowScreenLock)
                && Objects.equals(this.browserVersion, dtCChromeOS.browserVersion)
                && Objects.equals(this.builtInDnsClientEnabled, dtCChromeOS.builtInDnsClientEnabled)
                && Objects.equals(this.chromeRemoteDesktopAppBlocked, dtCChromeOS.chromeRemoteDesktopAppBlocked)
                && Objects.equals(this.deviceEnrollmentDomain, dtCChromeOS.deviceEnrollmentDomain)
                && Objects.equals(this.diskEncrypted, dtCChromeOS.diskEncrypted)
                && Objects.equals(this.keyTrustLevel, dtCChromeOS.keyTrustLevel)
                && Objects.equals(this.managedDevice, dtCChromeOS.managedDevice)
                && Objects.equals(this.osFirewall, dtCChromeOS.osFirewall)
                && Objects.equals(this.osVersion, dtCChromeOS.osVersion)
                && Objects.equals(this.passwordProtectionWarningTrigger, dtCChromeOS.passwordProtectionWarningTrigger)
                && Objects.equals(this.realtimeUrlCheckMode, dtCChromeOS.realtimeUrlCheckMode)
                && Objects.equals(this.safeBrowsingProtectionLevel, dtCChromeOS.safeBrowsingProtectionLevel)
                && Objects.equals(this.screenLockSecured, dtCChromeOS.screenLockSecured)
                && Objects.equals(this.siteIsolationEnabled, dtCChromeOS.siteIsolationEnabled);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(allowScreenLock, browserVersion, builtInDnsClientEnabled, chromeRemoteDesktopAppBlocked,
                deviceEnrollmentDomain, diskEncrypted, keyTrustLevel, managedDevice, osFirewall, osVersion,
                passwordProtectionWarningTrigger, realtimeUrlCheckMode, safeBrowsingProtectionLevel, screenLockSecured,
                siteIsolationEnabled);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DTCChromeOS {\n");
        sb.append("    allowScreenLock: ").append(toIndentedString(allowScreenLock)).append("\n");
        sb.append("    browserVersion: ").append(toIndentedString(browserVersion)).append("\n");
        sb.append("    builtInDnsClientEnabled: ").append(toIndentedString(builtInDnsClientEnabled)).append("\n");
        sb.append("    chromeRemoteDesktopAppBlocked: ").append(toIndentedString(chromeRemoteDesktopAppBlocked))
                .append("\n");
        sb.append("    deviceEnrollmentDomain: ").append(toIndentedString(deviceEnrollmentDomain)).append("\n");
        sb.append("    diskEncrypted: ").append(toIndentedString(diskEncrypted)).append("\n");
        sb.append("    keyTrustLevel: ").append(toIndentedString(keyTrustLevel)).append("\n");
        sb.append("    managedDevice: ").append(toIndentedString(managedDevice)).append("\n");
        sb.append("    osFirewall: ").append(toIndentedString(osFirewall)).append("\n");
        sb.append("    osVersion: ").append(toIndentedString(osVersion)).append("\n");
        sb.append("    passwordProtectionWarningTrigger: ").append(toIndentedString(passwordProtectionWarningTrigger))
                .append("\n");
        sb.append("    realtimeUrlCheckMode: ").append(toIndentedString(realtimeUrlCheckMode)).append("\n");
        sb.append("    safeBrowsingProtectionLevel: ").append(toIndentedString(safeBrowsingProtectionLevel))
                .append("\n");
        sb.append("    screenLockSecured: ").append(toIndentedString(screenLockSecured)).append("\n");
        sb.append("    siteIsolationEnabled: ").append(toIndentedString(siteIsolationEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
