package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.Embedded;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * A key object with public key details
 */
@ApiModel(description = "A key object with public key details")
@JsonPropertyOrder({ DetailedHookKeyInstance.JSON_PROPERTY_CREATED, DetailedHookKeyInstance.JSON_PROPERTY_ID,
        DetailedHookKeyInstance.JSON_PROPERTY_IS_USED, DetailedHookKeyInstance.JSON_PROPERTY_KEY_ID,
        DetailedHookKeyInstance.JSON_PROPERTY_LAST_UPDATED, DetailedHookKeyInstance.JSON_PROPERTY_NAME,
        DetailedHookKeyInstance.JSON_PROPERTY_EMBEDDED })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class DetailedHookKeyInstance implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private JsonNullable<OffsetDateTime> created = JsonNullable.<OffsetDateTime> undefined();

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_IS_USED = "isUsed";
    private Boolean isUsed;

    public static final String JSON_PROPERTY_KEY_ID = "keyId";
    private String keyId;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private JsonNullable<OffsetDateTime> lastUpdated = JsonNullable.<OffsetDateTime> undefined();

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private Embedded embedded;

    public DetailedHookKeyInstance() {
    }

    /*
     * @JsonCreator public DetailedHookKeyInstance(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_IS_USED) Boolean isUsed,
     *
     * @JsonProperty(JSON_PROPERTY_KEY_ID) String keyId,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created; this.id
     * = id; this.isUsed = isUsed; this.keyId = keyId; this.lastUpdated = lastUpdated; }
     */

    /**
     * Timestamp when the key was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the key was created")
    @JsonIgnore

    public OffsetDateTime getCreated() {

        if (created == null) {
            created = JsonNullable.<OffsetDateTime> undefined();
        }
        return created.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<OffsetDateTime> getCreated_JsonNullable() {
        return created;
    }

    @JsonProperty(JSON_PROPERTY_CREATED)
    private void setCreated_JsonNullable(JsonNullable<OffsetDateTime> created) {
        this.created = created;
    }

    /**
     * The unique Okta ID of this key record
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The unique Okta ID of this key record")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Whether this key is currently in use by other applications
     *
     * @return isUsed
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Whether this key is currently in use by other applications")
    @JsonProperty(JSON_PROPERTY_IS_USED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getIsUsed() {
        return isUsed;
    }

    /**
     * The alias of the public key
     *
     * @return keyId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The alias of the public key")
    @JsonProperty(JSON_PROPERTY_KEY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKeyId() {
        return keyId;
    }

    /**
     * Timestamp when the key was updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the key was updated")
    @JsonIgnore

    public OffsetDateTime getLastUpdated() {

        if (lastUpdated == null) {
            lastUpdated = JsonNullable.<OffsetDateTime> undefined();
        }
        return lastUpdated.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<OffsetDateTime> getLastUpdated_JsonNullable() {
        return lastUpdated;
    }

    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    private void setLastUpdated_JsonNullable(JsonNullable<OffsetDateTime> lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public DetailedHookKeyInstance name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Display name of the key
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Display name of the key")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public DetailedHookKeyInstance embedded(Embedded embedded) {

        this.embedded = embedded;
        return this;
    }

    /**
     * Get embedded
     *
     * @return embedded
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_EMBEDDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Embedded getEmbedded() {
        return embedded;
    }

    @JsonProperty(JSON_PROPERTY_EMBEDDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEmbedded(Embedded embedded) {
        this.embedded = embedded;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DetailedHookKeyInstance detailedHookKeyInstance = (DetailedHookKeyInstance) o;
        return equalsNullable(this.created, detailedHookKeyInstance.created)
                && Objects.equals(this.id, detailedHookKeyInstance.id)
                && Objects.equals(this.isUsed, detailedHookKeyInstance.isUsed)
                && Objects.equals(this.keyId, detailedHookKeyInstance.keyId)
                && equalsNullable(this.lastUpdated, detailedHookKeyInstance.lastUpdated)
                && Objects.equals(this.name, detailedHookKeyInstance.name)
                && Objects.equals(this.embedded, detailedHookKeyInstance.embedded);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(hashCodeNullable(created), id, isUsed, keyId, hashCodeNullable(lastUpdated), name,
                embedded);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DetailedHookKeyInstance {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    isUsed: ").append(toIndentedString(isUsed)).append("\n");
        sb.append("    keyId: ").append(toIndentedString(keyId)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
