package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.DynamicNetworkZoneAllOfAsns;
import com.okta.sdk.resource.model.DynamicNetworkZoneAllOfLocations;
import com.okta.sdk.resource.model.LinksSelfAndLifecycle;
import com.okta.sdk.resource.model.NetworkZone;
import com.okta.sdk.resource.model.NetworkZoneStatus;
import com.okta.sdk.resource.model.NetworkZoneType;
import com.okta.sdk.resource.model.NetworkZoneUsage;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * DynamicNetworkZone
 */
@JsonPropertyOrder({ DynamicNetworkZone.JSON_PROPERTY_ASNS, DynamicNetworkZone.JSON_PROPERTY_PROXY_TYPE,
        DynamicNetworkZone.JSON_PROPERTY_LOCATIONS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true, defaultImpl = DynamicNetworkZone.class)

public class DynamicNetworkZone extends NetworkZone implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ASNS = "asns";
    private DynamicNetworkZoneAllOfAsns asns;

    /**
     * The proxy type used for a Dynamic Network Zone
     */
    public enum ProxyTypeEnum {
        NULL(String.valueOf("null")),

        ANY(String.valueOf("Any")),

        TOR(String.valueOf("Tor")),

        NOT_TOR_ANONYMIZER(String.valueOf("NotTorAnonymizer")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        ProxyTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ProxyTypeEnum fromValue(String value) {
            for (ProxyTypeEnum b : ProxyTypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_PROXY_TYPE = "proxyType";
    private ProxyTypeEnum proxyType;

    public static final String JSON_PROPERTY_LOCATIONS = "locations";
    private DynamicNetworkZoneAllOfLocations locations;

    public DynamicNetworkZone() {
    }

    /*
     * @JsonCreator public DynamicNetworkZone(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_SYSTEM) Boolean system ) { this(); this.created = created; this.id = id;
     * this.lastUpdated = lastUpdated; this.system = system; }
     */

    public DynamicNetworkZone asns(DynamicNetworkZoneAllOfAsns asns) {

        this.asns = asns;
        return this;
    }

    /**
     * Get asns
     *
     * @return asns
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ASNS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DynamicNetworkZoneAllOfAsns getAsns() {
        return asns;
    }

    @JsonProperty(JSON_PROPERTY_ASNS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAsns(DynamicNetworkZoneAllOfAsns asns) {
        this.asns = asns;
    }

    public DynamicNetworkZone proxyType(ProxyTypeEnum proxyType) {

        this.proxyType = proxyType;
        return this;
    }

    /**
     * The proxy type used for a Dynamic Network Zone
     *
     * @return proxyType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The proxy type used for a Dynamic Network Zone")
    @JsonProperty(JSON_PROPERTY_PROXY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProxyTypeEnum getProxyType() {
        return proxyType;
    }

    @JsonProperty(JSON_PROPERTY_PROXY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProxyType(ProxyTypeEnum proxyType) {
        this.proxyType = proxyType;
    }

    public DynamicNetworkZone locations(DynamicNetworkZoneAllOfLocations locations) {

        this.locations = locations;
        return this;
    }

    /**
     * Get locations
     *
     * @return locations
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LOCATIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DynamicNetworkZoneAllOfLocations getLocations() {
        return locations;
    }

    @JsonProperty(JSON_PROPERTY_LOCATIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLocations(DynamicNetworkZoneAllOfLocations locations) {
        this.locations = locations;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DynamicNetworkZone dynamicNetworkZone = (DynamicNetworkZone) o;
        return Objects.equals(this.asns, dynamicNetworkZone.asns)
                && Objects.equals(this.proxyType, dynamicNetworkZone.proxyType)
                && Objects.equals(this.locations, dynamicNetworkZone.locations);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(asns, proxyType, locations, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DynamicNetworkZone {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    asns: ").append(toIndentedString(asns)).append("\n");
        sb.append("    proxyType: ").append(toIndentedString(proxyType)).append("\n");
        sb.append("    locations: ").append(toIndentedString(locations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
