package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * EmailDefaultContent
 */
@JsonPropertyOrder({ EmailDefaultContent.JSON_PROPERTY_BODY, EmailDefaultContent.JSON_PROPERTY_SUBJECT,
        EmailDefaultContent.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class EmailDefaultContent implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_BODY = "body";
    private String body;

    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private Object links;

    public EmailDefaultContent() {
    }

    public EmailDefaultContent body(String body) {

        this.body = body;
        return this;
    }

    /**
     * The HTML body of the email. May contain [variable
     * references](https://velocity.apache.org/engine/1.7/user-guide.html#references). &lt;x-lifecycle
     * class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; Not required if Custom languages for Okta Email Templates is
     * enabled. A &#x60;null&#x60; body is replaced with a default value from one of the following in priority order: 1.
     * An existing default email customization, if one exists 2. Okta-provided translated content for the specified
     * language, if one exists 3. Okta-provided translated content for the brand locale, if it&#39;s set 4.
     * Okta-provided content in English
     *
     * @return body
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The HTML body of the email. May contain [variable references](https://velocity.apache.org/engine/1.7/user-guide.html#references).   <x-lifecycle class=\"ea\"></x-lifecycle> Not required if Custom languages for Okta Email Templates is enabled. A `null` body is replaced with a default value from one of the following in priority order:  1. An existing default email customization, if one exists 2. Okta-provided translated content for the specified language, if one exists 3. Okta-provided translated content for the brand locale, if it's set  4. Okta-provided content in English ")
    @JsonProperty(JSON_PROPERTY_BODY)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getBody() {
        return body;
    }

    @JsonProperty(JSON_PROPERTY_BODY)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setBody(String body) {
        this.body = body;
    }

    public EmailDefaultContent subject(String subject) {

        this.subject = subject;
        return this;
    }

    /**
     * The email subject. May contain [variable
     * references](https://velocity.apache.org/engine/1.7/user-guide.html#references). &lt;x-lifecycle
     * class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; Not required if Custom languages for Okta Email Templates is
     * enabled. A &#x60;null&#x60; subject is replaced with a default value from one of the following in priority order:
     * 1. An existing default email customization, if one exists 2. Okta-provided translated content for the specified
     * language, if one exists 3. Okta-provided translated content for the brand locale, if it&#39;s set 4.
     * Okta-provided content in English
     *
     * @return subject
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The email subject. May contain [variable references](https://velocity.apache.org/engine/1.7/user-guide.html#references).  <x-lifecycle class=\"ea\"></x-lifecycle> Not required if Custom languages for Okta Email Templates is enabled. A `null` subject is replaced with a default value from one of the following in priority order:  1. An existing default email customization, if one exists 2. Okta-provided translated content for the specified language, if one exists 3. Okta-provided translated content for the brand locale, if it's set 4. Okta-provided content in English ")
    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getSubject() {
        return subject;
    }

    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public EmailDefaultContent links(Object links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(Object links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailDefaultContent emailDefaultContent = (EmailDefaultContent) o;
        return Objects.equals(this.body, emailDefaultContent.body)
                && Objects.equals(this.subject, emailDefaultContent.subject)
                && Objects.equals(this.links, emailDefaultContent.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(body, subject, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailDefaultContent {\n");
        sb.append("    body: ").append(toIndentedString(body)).append("\n");
        sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
