package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * EmailSettings
 */
@JsonPropertyOrder({ EmailSettings.JSON_PROPERTY_RECIPIENTS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class EmailSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Gets or Sets recipients
     */
    public enum RecipientsEnum {
        ALL_USERS(String.valueOf("ALL_USERS")),

        ADMINS_ONLY(String.valueOf("ADMINS_ONLY")),

        NO_USERS(String.valueOf("NO_USERS")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        RecipientsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static RecipientsEnum fromValue(String value) {
            for (RecipientsEnum b : RecipientsEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_RECIPIENTS = "recipients";
    private RecipientsEnum recipients;

    public EmailSettings() {
    }

    public EmailSettings recipients(RecipientsEnum recipients) {

        this.recipients = recipients;
        return this;
    }

    /**
     * Get recipients
     *
     * @return recipients
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_RECIPIENTS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public RecipientsEnum getRecipients() {
        return recipients;
    }

    @JsonProperty(JSON_PROPERTY_RECIPIENTS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setRecipients(RecipientsEnum recipients) {
        this.recipients = recipients;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailSettings emailSettings = (EmailSettings) o;
        return Objects.equals(this.recipients, emailSettings.recipients);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(recipients);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailSettings {\n");
        sb.append("    recipients: ").append(toIndentedString(recipients)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
