package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.EmailTemplateResponseEmbedded;
import com.okta.sdk.resource.model.EmailTemplateResponseLinks;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * EmailTemplateResponse
 */
@JsonPropertyOrder({ EmailTemplateResponse.JSON_PROPERTY_NAME, EmailTemplateResponse.JSON_PROPERTY_EMBEDDED,
        EmailTemplateResponse.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class EmailTemplateResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private EmailTemplateResponseEmbedded embedded;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private EmailTemplateResponseLinks links;

    public EmailTemplateResponse() {
    }

    /*
     * @JsonCreator public EmailTemplateResponse(
     *
     * @JsonProperty(JSON_PROPERTY_NAME) String name ) { this(); this.name = name; }
     */

    /**
     * The name of this email template
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The name of this email template")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    public EmailTemplateResponse embedded(EmailTemplateResponseEmbedded embedded) {

        this.embedded = embedded;
        return this;
    }

    /**
     * Get embedded
     *
     * @return embedded
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_EMBEDDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EmailTemplateResponseEmbedded getEmbedded() {
        return embedded;
    }

    @JsonProperty(JSON_PROPERTY_EMBEDDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEmbedded(EmailTemplateResponseEmbedded embedded) {
        this.embedded = embedded;
    }

    public EmailTemplateResponse links(EmailTemplateResponseLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EmailTemplateResponseLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(EmailTemplateResponseLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailTemplateResponse emailTemplateResponse = (EmailTemplateResponse) o;
        return Objects.equals(this.name, emailTemplateResponse.name)
                && Objects.equals(this.embedded, emailTemplateResponse.embedded)
                && Objects.equals(this.links, emailTemplateResponse.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, embedded, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailTemplateResponse {\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
