package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ECKeyJWK;
import com.okta.sdk.resource.model.WebAuthnCredResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Enrollment Initialization Request
 */
@ApiModel(description = "Enrollment Initialization Request")
@JsonPropertyOrder({ EnrollmentActivationRequest.JSON_PROPERTY_CRED_RESPONSES,
        EnrollmentActivationRequest.JSON_PROPERTY_FULFILLMENT_PROVIDER,
        EnrollmentActivationRequest.JSON_PROPERTY_PIN_RESPONSE_JWE, EnrollmentActivationRequest.JSON_PROPERTY_SERIAL,
        EnrollmentActivationRequest.JSON_PROPERTY_USER_ID, EnrollmentActivationRequest.JSON_PROPERTY_VERSION,
        EnrollmentActivationRequest.JSON_PROPERTY_YUBICO_SIGNING_JWKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class EnrollmentActivationRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CRED_RESPONSES = "credResponses";
    private List<WebAuthnCredResponse> credResponses = null;

    /**
     * Name of the fulfillment provider for the WebAuthn Preregistration Factor
     */
    public enum FulfillmentProviderEnum {
        YUBICO(String.valueOf("yubico")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        FulfillmentProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static FulfillmentProviderEnum fromValue(String value) {
            for (FulfillmentProviderEnum b : FulfillmentProviderEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_FULFILLMENT_PROVIDER = "fulfillmentProvider";
    private FulfillmentProviderEnum fulfillmentProvider;

    public static final String JSON_PROPERTY_PIN_RESPONSE_JWE = "pinResponseJwe";
    private String pinResponseJwe;

    public static final String JSON_PROPERTY_SERIAL = "serial";
    private String serial;

    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;

    public static final String JSON_PROPERTY_YUBICO_SIGNING_JWKS = "yubicoSigningJwks";
    private List<ECKeyJWK> yubicoSigningJwks = null;

    public EnrollmentActivationRequest() {
    }

    public EnrollmentActivationRequest credResponses(List<WebAuthnCredResponse> credResponses) {

        this.credResponses = credResponses;
        return this;
    }

    public EnrollmentActivationRequest addcredResponsesItem(WebAuthnCredResponse credResponsesItem) {
        if (this.credResponses == null) {
            this.credResponses = new ArrayList<>();
        }
        this.credResponses.add(credResponsesItem);
        return this;
    }

    /**
     * List of credential responses from the fulfillment provider
     *
     * @return credResponses
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "List of credential responses from the fulfillment provider")
    @JsonProperty(JSON_PROPERTY_CRED_RESPONSES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<WebAuthnCredResponse> getCredResponses() {
        return credResponses;
    }

    @JsonProperty(JSON_PROPERTY_CRED_RESPONSES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredResponses(List<WebAuthnCredResponse> credResponses) {
        this.credResponses = credResponses;
    }

    public EnrollmentActivationRequest fulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {

        this.fulfillmentProvider = fulfillmentProvider;
        return this;
    }

    /**
     * Name of the fulfillment provider for the WebAuthn Preregistration Factor
     *
     * @return fulfillmentProvider
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the fulfillment provider for the WebAuthn Preregistration Factor")
    @JsonProperty(JSON_PROPERTY_FULFILLMENT_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FulfillmentProviderEnum getFulfillmentProvider() {
        return fulfillmentProvider;
    }

    @JsonProperty(JSON_PROPERTY_FULFILLMENT_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
    }

    public EnrollmentActivationRequest pinResponseJwe(String pinResponseJwe) {

        this.pinResponseJwe = pinResponseJwe;
        return this;
    }

    /**
     * Encrypted JWE of PIN response from the fulfillment provider
     *
     * @return pinResponseJwe
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Encrypted JWE of PIN response from the fulfillment provider")
    @JsonProperty(JSON_PROPERTY_PIN_RESPONSE_JWE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPinResponseJwe() {
        return pinResponseJwe;
    }

    @JsonProperty(JSON_PROPERTY_PIN_RESPONSE_JWE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPinResponseJwe(String pinResponseJwe) {
        this.pinResponseJwe = pinResponseJwe;
    }

    public EnrollmentActivationRequest serial(String serial) {

        this.serial = serial;
        return this;
    }

    /**
     * Serial number of the YubiKey
     *
     * @return serial
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Serial number of the YubiKey")
    @JsonProperty(JSON_PROPERTY_SERIAL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSerial() {
        return serial;
    }

    @JsonProperty(JSON_PROPERTY_SERIAL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSerial(String serial) {
        this.serial = serial;
    }

    public EnrollmentActivationRequest userId(String userId) {

        this.userId = userId;
        return this;
    }

    /**
     * ID of an existing Okta user
     *
     * @return userId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID of an existing Okta user")
    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserId() {
        return userId;
    }

    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public EnrollmentActivationRequest version(String version) {

        this.version = version;
        return this;
    }

    /**
     * Firmware version of the YubiKey
     *
     * @return version
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Firmware version of the YubiKey")
    @JsonProperty(JSON_PROPERTY_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getVersion() {
        return version;
    }

    @JsonProperty(JSON_PROPERTY_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(String version) {
        this.version = version;
    }

    public EnrollmentActivationRequest yubicoSigningJwks(List<ECKeyJWK> yubicoSigningJwks) {

        this.yubicoSigningJwks = yubicoSigningJwks;
        return this;
    }

    public EnrollmentActivationRequest addyubicoSigningJwksItem(ECKeyJWK yubicoSigningJwksItem) {
        if (this.yubicoSigningJwks == null) {
            this.yubicoSigningJwks = new ArrayList<>();
        }
        this.yubicoSigningJwks.add(yubicoSigningJwksItem);
        return this;
    }

    /**
     * List of usable signing keys from Yubico (in JWKS format) used to verify the JWS inside the JWE
     *
     * @return yubicoSigningJwks
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "List of usable signing keys from Yubico (in JWKS format) used to verify the JWS inside the JWE")
    @JsonProperty(JSON_PROPERTY_YUBICO_SIGNING_JWKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<ECKeyJWK> getYubicoSigningJwks() {
        return yubicoSigningJwks;
    }

    @JsonProperty(JSON_PROPERTY_YUBICO_SIGNING_JWKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setYubicoSigningJwks(List<ECKeyJWK> yubicoSigningJwks) {
        this.yubicoSigningJwks = yubicoSigningJwks;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EnrollmentActivationRequest enrollmentActivationRequest = (EnrollmentActivationRequest) o;
        return Objects.equals(this.credResponses, enrollmentActivationRequest.credResponses)
                && Objects.equals(this.fulfillmentProvider, enrollmentActivationRequest.fulfillmentProvider)
                && Objects.equals(this.pinResponseJwe, enrollmentActivationRequest.pinResponseJwe)
                && Objects.equals(this.serial, enrollmentActivationRequest.serial)
                && Objects.equals(this.userId, enrollmentActivationRequest.userId)
                && Objects.equals(this.version, enrollmentActivationRequest.version)
                && Objects.equals(this.yubicoSigningJwks, enrollmentActivationRequest.yubicoSigningJwks);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(credResponses, fulfillmentProvider, pinResponseJwe, serial, userId, version,
                yubicoSigningJwks);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnrollmentActivationRequest {\n");
        sb.append("    credResponses: ").append(toIndentedString(credResponses)).append("\n");
        sb.append("    fulfillmentProvider: ").append(toIndentedString(fulfillmentProvider)).append("\n");
        sb.append("    pinResponseJwe: ").append(toIndentedString(pinResponseJwe)).append("\n");
        sb.append("    serial: ").append(toIndentedString(serial)).append("\n");
        sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("    version: ").append(toIndentedString(version)).append("\n");
        sb.append("    yubicoSigningJwks: ").append(toIndentedString(yubicoSigningJwks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
