package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.EntityRiskScorePolicyRuleCondition;
import com.okta.sdk.resource.model.PolicyPeopleCondition;
import com.okta.sdk.resource.model.RiskDetectionTypesPolicyRuleCondition;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * EntityRiskPolicyRuleConditions
 */
@JsonPropertyOrder({ EntityRiskPolicyRuleConditions.JSON_PROPERTY_ENTITY_RISK,
        EntityRiskPolicyRuleConditions.JSON_PROPERTY_PEOPLE,
        EntityRiskPolicyRuleConditions.JSON_PROPERTY_RISK_DETECTION_TYPES })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class EntityRiskPolicyRuleConditions implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ENTITY_RISK = "entityRisk";
    private EntityRiskScorePolicyRuleCondition entityRisk;

    public static final String JSON_PROPERTY_PEOPLE = "people";
    private PolicyPeopleCondition people;

    public static final String JSON_PROPERTY_RISK_DETECTION_TYPES = "riskDetectionTypes";
    private RiskDetectionTypesPolicyRuleCondition riskDetectionTypes;

    public EntityRiskPolicyRuleConditions() {
    }

    public EntityRiskPolicyRuleConditions entityRisk(EntityRiskScorePolicyRuleCondition entityRisk) {

        this.entityRisk = entityRisk;
        return this;
    }

    /**
     * Get entityRisk
     *
     * @return entityRisk
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ENTITY_RISK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EntityRiskScorePolicyRuleCondition getEntityRisk() {
        return entityRisk;
    }

    @JsonProperty(JSON_PROPERTY_ENTITY_RISK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEntityRisk(EntityRiskScorePolicyRuleCondition entityRisk) {
        this.entityRisk = entityRisk;
    }

    public EntityRiskPolicyRuleConditions people(PolicyPeopleCondition people) {

        this.people = people;
        return this;
    }

    /**
     * Get people
     *
     * @return people
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PEOPLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PolicyPeopleCondition getPeople() {
        return people;
    }

    @JsonProperty(JSON_PROPERTY_PEOPLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPeople(PolicyPeopleCondition people) {
        this.people = people;
    }

    public EntityRiskPolicyRuleConditions riskDetectionTypes(RiskDetectionTypesPolicyRuleCondition riskDetectionTypes) {

        this.riskDetectionTypes = riskDetectionTypes;
        return this;
    }

    /**
     * Get riskDetectionTypes
     *
     * @return riskDetectionTypes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RISK_DETECTION_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RiskDetectionTypesPolicyRuleCondition getRiskDetectionTypes() {
        return riskDetectionTypes;
    }

    @JsonProperty(JSON_PROPERTY_RISK_DETECTION_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRiskDetectionTypes(RiskDetectionTypesPolicyRuleCondition riskDetectionTypes) {
        this.riskDetectionTypes = riskDetectionTypes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EntityRiskPolicyRuleConditions entityRiskPolicyRuleConditions = (EntityRiskPolicyRuleConditions) o;
        return Objects.equals(this.entityRisk, entityRiskPolicyRuleConditions.entityRisk)
                && Objects.equals(this.people, entityRiskPolicyRuleConditions.people)
                && Objects.equals(this.riskDetectionTypes, entityRiskPolicyRuleConditions.riskDetectionTypes);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(entityRisk, people, riskDetectionTypes);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityRiskPolicyRuleConditions {\n");
        sb.append("    entityRisk: ").append(toIndentedString(entityRisk)).append("\n");
        sb.append("    people: ").append(toIndentedString(people)).append("\n");
        sb.append("    riskDetectionTypes: ").append(toIndentedString(riskDetectionTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
