package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * EventHookFilterMapObjectCondition
 */
@JsonPropertyOrder({ EventHookFilterMapObjectCondition.JSON_PROPERTY_EXPRESSION,
        EventHookFilterMapObjectCondition.JSON_PROPERTY_VERSION })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class EventHookFilterMapObjectCondition implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXPRESSION = "expression";
    private String expression;

    public static final String JSON_PROPERTY_VERSION = "version";
    private JsonNullable<String> version = JsonNullable.<String> undefined();

    public EventHookFilterMapObjectCondition() {
    }

    /*
     * @JsonCreator public EventHookFilterMapObjectCondition(
     *
     * @JsonProperty(JSON_PROPERTY_VERSION) String version ) { this(); this.version = version; }
     */

    public EventHookFilterMapObjectCondition expression(String expression) {

        this.expression = expression;
        return this;
    }

    /**
     * The Okta Expression language statement that filters the event type
     *
     * @return expression
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The Okta Expression language statement that filters the event type")
    @JsonProperty(JSON_PROPERTY_EXPRESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getExpression() {
        return expression;
    }

    @JsonProperty(JSON_PROPERTY_EXPRESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExpression(String expression) {
        this.expression = expression;
    }

    /**
     * Internal field
     *
     * @return version
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Internal field")
    @JsonIgnore

    public String getVersion() {

        if (version == null) {
            version = JsonNullable.<String> undefined();
        }
        return version.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getVersion_JsonNullable() {
        return version;
    }

    @JsonProperty(JSON_PROPERTY_VERSION)
    private void setVersion_JsonNullable(JsonNullable<String> version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EventHookFilterMapObjectCondition eventHookFilterMapObjectCondition = (EventHookFilterMapObjectCondition) o;
        return Objects.equals(this.expression, eventHookFilterMapObjectCondition.expression)
                && equalsNullable(this.version, eventHookFilterMapObjectCondition.version);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(expression, hashCodeNullable(version));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventHookFilterMapObjectCondition {\n");
        sb.append("    expression: ").append(toIndentedString(expression)).append("\n");
        sb.append("    version: ").append(toIndentedString(version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
