package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * FCMConfiguration
 */
@JsonPropertyOrder({ FCMConfiguration.JSON_PROPERTY_FILE_NAME, FCMConfiguration.JSON_PROPERTY_PROJECT_ID,
        FCMConfiguration.JSON_PROPERTY_SERVICE_ACCOUNT_JSON })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class FCMConfiguration implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_FILE_NAME = "fileName";
    private String fileName;

    public static final String JSON_PROPERTY_PROJECT_ID = "projectId";
    private String projectId;

    public static final String JSON_PROPERTY_SERVICE_ACCOUNT_JSON = "serviceAccountJson";
    private Object serviceAccountJson;

    public FCMConfiguration() {
    }

    /*
     * @JsonCreator public FCMConfiguration(
     *
     * @JsonProperty(JSON_PROPERTY_PROJECT_ID) String projectId ) { this(); this.projectId = projectId; }
     */

    public FCMConfiguration fileName(String fileName) {

        this.fileName = fileName;
        return this;
    }

    /**
     * (Optional) File name for Admin Console display
     *
     * @return fileName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "(Optional) File name for Admin Console display")
    @JsonProperty(JSON_PROPERTY_FILE_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getFileName() {
        return fileName;
    }

    @JsonProperty(JSON_PROPERTY_FILE_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /**
     * Project ID of FCM configuration
     *
     * @return projectId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Project ID of FCM configuration")
    @JsonProperty(JSON_PROPERTY_PROJECT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getProjectId() {
        return projectId;
    }

    public FCMConfiguration serviceAccountJson(Object serviceAccountJson) {

        this.serviceAccountJson = serviceAccountJson;
        return this;
    }

    /**
     * JSON containing the private service account key and service account details. See [Creating and managing service
     * account keys](https://cloud.google.com/iam/docs/creating-managing-service-account-keys) for more information on
     * creating service account keys in JSON.
     *
     * @return serviceAccountJson
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "JSON containing the private service account key and service account details. See [Creating and managing service account keys](https://cloud.google.com/iam/docs/creating-managing-service-account-keys) for more information on creating service account keys in JSON.")
    @JsonProperty(JSON_PROPERTY_SERVICE_ACCOUNT_JSON)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getServiceAccountJson() {
        return serviceAccountJson;
    }

    @JsonProperty(JSON_PROPERTY_SERVICE_ACCOUNT_JSON)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setServiceAccountJson(Object serviceAccountJson) {
        this.serviceAccountJson = serviceAccountJson;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FCMConfiguration fcMConfiguration = (FCMConfiguration) o;
        return Objects.equals(this.fileName, fcMConfiguration.fileName)
                && Objects.equals(this.projectId, fcMConfiguration.projectId)
                && Objects.equals(this.serviceAccountJson, fcMConfiguration.serviceAccountJson);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(fileName, projectId, serviceAccountJson);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FCMConfiguration {\n");
        sb.append("    fileName: ").append(toIndentedString(fileName)).append("\n");
        sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
        sb.append("    serviceAccountJson: ").append(toIndentedString(serviceAccountJson)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
