package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.GroupRuleGroupCondition;
import com.okta.sdk.resource.model.GroupRuleUserCondition;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Defines conditions for &#x60;people&#x60; in a group rule
 */
@ApiModel(description = "Defines conditions for `people` in a group rule")
@JsonPropertyOrder({ GroupRulePeopleCondition.JSON_PROPERTY_GROUPS, GroupRulePeopleCondition.JSON_PROPERTY_USERS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class GroupRulePeopleCondition implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_GROUPS = "groups";
    private GroupRuleGroupCondition groups;

    public static final String JSON_PROPERTY_USERS = "users";
    private GroupRuleUserCondition users;

    public GroupRulePeopleCondition() {
    }

    public GroupRulePeopleCondition groups(GroupRuleGroupCondition groups) {

        this.groups = groups;
        return this;
    }

    /**
     * Get groups
     *
     * @return groups
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupRuleGroupCondition getGroups() {
        return groups;
    }

    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGroups(GroupRuleGroupCondition groups) {
        this.groups = groups;
    }

    public GroupRulePeopleCondition users(GroupRuleUserCondition users) {

        this.users = users;
        return this;
    }

    /**
     * Get users
     *
     * @return users
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupRuleUserCondition getUsers() {
        return users;
    }

    @JsonProperty(JSON_PROPERTY_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUsers(GroupRuleUserCondition users) {
        this.users = users;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GroupRulePeopleCondition groupRulePeopleCondition = (GroupRulePeopleCondition) o;
        return Objects.equals(this.groups, groupRulePeopleCondition.groups)
                && Objects.equals(this.users, groupRulePeopleCondition.users);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(groups, users);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupRulePeopleCondition {\n");
        sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
        sb.append("    users: ").append(toIndentedString(users)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
