package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CsrSelfHrefHints;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Link to the resource (self)
 */
@ApiModel(description = "Link to the resource (self)")
@JsonPropertyOrder({ HrefCsrSelfLink.JSON_PROPERTY_HINTS, HrefCsrSelfLink.JSON_PROPERTY_HREF })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class HrefCsrSelfLink implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_HINTS = "hints";
    private CsrSelfHrefHints hints;

    public static final String JSON_PROPERTY_HREF = "href";
    private String href;

    public HrefCsrSelfLink() {
    }

    public HrefCsrSelfLink hints(CsrSelfHrefHints hints) {

        this.hints = hints;
        return this;
    }

    /**
     * Get hints
     *
     * @return hints
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_HINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CsrSelfHrefHints getHints() {
        return hints;
    }

    @JsonProperty(JSON_PROPERTY_HINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHints(CsrSelfHrefHints hints) {
        this.hints = hints;
    }

    public HrefCsrSelfLink href(String href) {

        this.href = href;
        return this;
    }

    /**
     * Link URI
     *
     * @return href
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "https://{yourOktaDomain}/api/v1/apps/0oad5lTSBOMUBOBVVQSC/credentials/csrs/h9zkutaSe7fZX0SwN1GqDApofgD1OW8g2B5l2azha50", required = true, value = "Link URI")
    @JsonProperty(JSON_PROPERTY_HREF)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getHref() {
        return href;
    }

    @JsonProperty(JSON_PROPERTY_HREF)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrefCsrSelfLink hrefCsrSelfLink = (HrefCsrSelfLink) o;
        return Objects.equals(this.hints, hrefCsrSelfLink.hints) && Objects.equals(this.href, hrefCsrSelfLink.href);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(hints, href);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HrefCsrSelfLink {\n");
        sb.append("    hints: ").append(toIndentedString(hints)).append("\n");
        sb.append("    href: ").append(toIndentedString(href)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
