package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.HrefHintsGuidanceObject;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Link to authorize scopes
 */
@ApiModel(description = "Link to authorize scopes")
@JsonPropertyOrder({ HrefObjectAuthorizeLink.JSON_PROPERTY_HINTS, HrefObjectAuthorizeLink.JSON_PROPERTY_HREF })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class HrefObjectAuthorizeLink implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_HINTS = "hints";
    private HrefHintsGuidanceObject hints;

    public static final String JSON_PROPERTY_HREF = "href";
    private String href;

    public HrefObjectAuthorizeLink() {
    }

    public HrefObjectAuthorizeLink hints(HrefHintsGuidanceObject hints) {

        this.hints = hints;
        return this;
    }

    /**
     * Get hints
     *
     * @return hints
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_HINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefHintsGuidanceObject getHints() {
        return hints;
    }

    @JsonProperty(JSON_PROPERTY_HINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHints(HrefHintsGuidanceObject hints) {
        this.hints = hints;
    }

    public HrefObjectAuthorizeLink href(String href) {

        this.href = href;
        return this;
    }

    /**
     * Link URI
     *
     * @return href
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Link URI")
    @JsonProperty(JSON_PROPERTY_HREF)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getHref() {
        return href;
    }

    @JsonProperty(JSON_PROPERTY_HREF)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrefObjectAuthorizeLink hrefObjectAuthorizeLink = (HrefObjectAuthorizeLink) o;
        return Objects.equals(this.hints, hrefObjectAuthorizeLink.hints)
                && Objects.equals(this.href, hrefObjectAuthorizeLink.href);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(hints, href);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HrefObjectAuthorizeLink {\n");
        sb.append("    hints: ").append(toIndentedString(hints)).append("\n");
        sb.append("    href: ").append(toIndentedString(href)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
