package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PolicyAccountLink;
import com.okta.sdk.resource.model.PolicySubject;
import com.okta.sdk.resource.model.Provisioning;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Policy settings for the IdP. The following provisioning and account linking actions are supported by each IdP
 * provider: | IdP type | User provisioning actions | Group provisioning actions | Account link actions | Account link
 * filters | | ----------------------------------------------------------------- | ------------------------- |
 * ------------------------------------- | -------------------- | -------------------- | | &#x60;SAML2&#x60; |
 * &#x60;AUTO&#x60; or &#x60;DISABLED&#x60; | &#x60;NONE&#x60;, &#x60;ASSIGN&#x60;, &#x60;APPEND&#x60;, or
 * &#x60;SYNC&#x60; | &#x60;AUTO&#x60;, &#x60;DISABLED&#x60; | &#x60;groups&#x60; | | &#x60;X509&#x60; |
 * &#x60;DISABLED&#x60; | No support for JIT provisioning | | | | All social IdP types (any IdP type that isn&#39;t
 * &#x60;SAML2&#x60; or &#x60;X509&#x60;) | &#x60;AUTO&#x60;, &#x60;DISABLED&#x60; | &#x60;NONE&#x60; or
 * &#x60;ASSIGN&#x60; | &#x60;AUTO&#x60;, &#x60;DISABLED&#x60; | &#x60;groups&#x60; |
 */
@ApiModel(description = "Policy settings for the IdP.  The following provisioning and account linking actions are supported by each IdP provider: | IdP type                                                          | User provisioning actions | Group provisioning actions            | Account link actions | Account link filters | | ----------------------------------------------------------------- | ------------------------- | ------------------------------------- | -------------------- | -------------------- | | `SAML2`                                                           | `AUTO` or `DISABLED`      | `NONE`, `ASSIGN`, `APPEND`, or `SYNC` | `AUTO`, `DISABLED`   | `groups`             | | `X509`                                                            | `DISABLED`                | No support for JIT provisioning       |                      |                      | | All social IdP types (any IdP type that isn't `SAML2` or `X509`)  | `AUTO`, `DISABLED`        | `NONE` or `ASSIGN`                    | `AUTO`, `DISABLED`   | `groups`             |")
@JsonPropertyOrder({ IdentityProviderPolicy.JSON_PROPERTY_ACCOUNT_LINK,
        IdentityProviderPolicy.JSON_PROPERTY_MAX_CLOCK_SKEW, IdentityProviderPolicy.JSON_PROPERTY_PROVISIONING,
        IdentityProviderPolicy.JSON_PROPERTY_SUBJECT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class IdentityProviderPolicy implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACCOUNT_LINK = "accountLink";
    private PolicyAccountLink accountLink;

    public static final String JSON_PROPERTY_MAX_CLOCK_SKEW = "maxClockSkew";
    private Integer maxClockSkew;

    public static final String JSON_PROPERTY_PROVISIONING = "provisioning";
    private Provisioning provisioning;

    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private PolicySubject subject;

    public IdentityProviderPolicy() {
    }

    public IdentityProviderPolicy accountLink(PolicyAccountLink accountLink) {

        this.accountLink = accountLink;
        return this;
    }

    /**
     * Get accountLink
     *
     * @return accountLink
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ACCOUNT_LINK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PolicyAccountLink getAccountLink() {
        return accountLink;
    }

    @JsonProperty(JSON_PROPERTY_ACCOUNT_LINK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAccountLink(PolicyAccountLink accountLink) {
        this.accountLink = accountLink;
    }

    public IdentityProviderPolicy maxClockSkew(Integer maxClockSkew) {

        this.maxClockSkew = maxClockSkew;
        return this;
    }

    /**
     * Maximum allowable clock skew when processing messages from the IdP
     *
     * @return maxClockSkew
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "120000", value = "Maximum allowable clock skew when processing messages from the IdP")
    @JsonProperty(JSON_PROPERTY_MAX_CLOCK_SKEW)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getMaxClockSkew() {
        return maxClockSkew;
    }

    @JsonProperty(JSON_PROPERTY_MAX_CLOCK_SKEW)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMaxClockSkew(Integer maxClockSkew) {
        this.maxClockSkew = maxClockSkew;
    }

    public IdentityProviderPolicy provisioning(Provisioning provisioning) {

        this.provisioning = provisioning;
        return this;
    }

    /**
     * Get provisioning
     *
     * @return provisioning
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROVISIONING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Provisioning getProvisioning() {
        return provisioning;
    }

    @JsonProperty(JSON_PROPERTY_PROVISIONING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProvisioning(Provisioning provisioning) {
        this.provisioning = provisioning;
    }

    public IdentityProviderPolicy subject(PolicySubject subject) {

        this.subject = subject;
        return this;
    }

    /**
     * Get subject
     *
     * @return subject
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PolicySubject getSubject() {
        return subject;
    }

    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(PolicySubject subject) {
        this.subject = subject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdentityProviderPolicy identityProviderPolicy = (IdentityProviderPolicy) o;
        return Objects.equals(this.accountLink, identityProviderPolicy.accountLink)
                && Objects.equals(this.maxClockSkew, identityProviderPolicy.maxClockSkew)
                && Objects.equals(this.provisioning, identityProviderPolicy.provisioning)
                && Objects.equals(this.subject, identityProviderPolicy.subject);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountLink, maxClockSkew, provisioning, subject);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityProviderPolicy {\n");
        sb.append("    accountLink: ").append(toIndentedString(accountLink)).append("\n");
        sb.append("    maxClockSkew: ").append(toIndentedString(maxClockSkew)).append("\n");
        sb.append("    provisioning: ").append(toIndentedString(provisioning)).append("\n");
        sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
