package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * IdentitySourceUserProfileForUpsert
 */
@JsonPropertyOrder({ IdentitySourceUserProfileForUpsert.JSON_PROPERTY_EMAIL,
        IdentitySourceUserProfileForUpsert.JSON_PROPERTY_FIRST_NAME,
        IdentitySourceUserProfileForUpsert.JSON_PROPERTY_HOME_ADDRESS,
        IdentitySourceUserProfileForUpsert.JSON_PROPERTY_LAST_NAME,
        IdentitySourceUserProfileForUpsert.JSON_PROPERTY_MOBILE_PHONE,
        IdentitySourceUserProfileForUpsert.JSON_PROPERTY_SECOND_EMAIL,
        IdentitySourceUserProfileForUpsert.JSON_PROPERTY_USER_NAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class IdentitySourceUserProfileForUpsert implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;

    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private JsonNullable<String> firstName = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_HOME_ADDRESS = "homeAddress";
    private JsonNullable<String> homeAddress = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private JsonNullable<String> lastName = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_MOBILE_PHONE = "mobilePhone";
    private JsonNullable<String> mobilePhone = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_SECOND_EMAIL = "secondEmail";
    private String secondEmail;

    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName;

    public IdentitySourceUserProfileForUpsert() {
    }

    public IdentitySourceUserProfileForUpsert email(String email) {

        this.email = email;
        return this;
    }

    /**
     * Email address of the user
     *
     * @return email
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Email address of the user")
    @JsonProperty(JSON_PROPERTY_EMAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getEmail() {
        return email;
    }

    @JsonProperty(JSON_PROPERTY_EMAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public IdentitySourceUserProfileForUpsert firstName(String firstName) {
        this.firstName = JsonNullable.<String> of(firstName);

        return this;
    }

    /**
     * First name of the user
     *
     * @return firstName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "First name of the user")
    @JsonIgnore

    public String getFirstName() {
        return firstName.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_FIRST_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getFirstName_JsonNullable() {
        return firstName;
    }

    @JsonProperty(JSON_PROPERTY_FIRST_NAME)
    public void setFirstName_JsonNullable(JsonNullable<String> firstName) {
        this.firstName = firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = JsonNullable.<String> of(firstName);
    }

    public IdentitySourceUserProfileForUpsert homeAddress(String homeAddress) {
        this.homeAddress = JsonNullable.<String> of(homeAddress);

        return this;
    }

    /**
     * Home address of the user
     *
     * @return homeAddress
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Home address of the user")
    @JsonIgnore

    public String getHomeAddress() {
        return homeAddress.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_HOME_ADDRESS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getHomeAddress_JsonNullable() {
        return homeAddress;
    }

    @JsonProperty(JSON_PROPERTY_HOME_ADDRESS)
    public void setHomeAddress_JsonNullable(JsonNullable<String> homeAddress) {
        this.homeAddress = homeAddress;
    }

    public void setHomeAddress(String homeAddress) {
        this.homeAddress = JsonNullable.<String> of(homeAddress);
    }

    public IdentitySourceUserProfileForUpsert lastName(String lastName) {
        this.lastName = JsonNullable.<String> of(lastName);

        return this;
    }

    /**
     * Last name of the user
     *
     * @return lastName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Last name of the user")
    @JsonIgnore

    public String getLastName() {
        return lastName.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_LAST_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getLastName_JsonNullable() {
        return lastName;
    }

    @JsonProperty(JSON_PROPERTY_LAST_NAME)
    public void setLastName_JsonNullable(JsonNullable<String> lastName) {
        this.lastName = lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = JsonNullable.<String> of(lastName);
    }

    public IdentitySourceUserProfileForUpsert mobilePhone(String mobilePhone) {
        this.mobilePhone = JsonNullable.<String> of(mobilePhone);

        return this;
    }

    /**
     * Mobile phone number of the user
     *
     * @return mobilePhone
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Mobile phone number of the user")
    @JsonIgnore

    public String getMobilePhone() {
        return mobilePhone.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_MOBILE_PHONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getMobilePhone_JsonNullable() {
        return mobilePhone;
    }

    @JsonProperty(JSON_PROPERTY_MOBILE_PHONE)
    public void setMobilePhone_JsonNullable(JsonNullable<String> mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = JsonNullable.<String> of(mobilePhone);
    }

    public IdentitySourceUserProfileForUpsert secondEmail(String secondEmail) {

        this.secondEmail = secondEmail;
        return this;
    }

    /**
     * Alternative email address of the user
     *
     * @return secondEmail
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Alternative email address of the user")
    @JsonProperty(JSON_PROPERTY_SECOND_EMAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSecondEmail() {
        return secondEmail;
    }

    @JsonProperty(JSON_PROPERTY_SECOND_EMAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSecondEmail(String secondEmail) {
        this.secondEmail = secondEmail;
    }

    public IdentitySourceUserProfileForUpsert userName(String userName) {

        this.userName = userName;
        return this;
    }

    /**
     * Username of the user
     *
     * @return userName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Username of the user")
    @JsonProperty(JSON_PROPERTY_USER_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserName() {
        return userName;
    }

    @JsonProperty(JSON_PROPERTY_USER_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdentitySourceUserProfileForUpsert identitySourceUserProfileForUpsert = (IdentitySourceUserProfileForUpsert) o;
        return Objects.equals(this.email, identitySourceUserProfileForUpsert.email)
                && equalsNullable(this.firstName, identitySourceUserProfileForUpsert.firstName)
                && equalsNullable(this.homeAddress, identitySourceUserProfileForUpsert.homeAddress)
                && equalsNullable(this.lastName, identitySourceUserProfileForUpsert.lastName)
                && equalsNullable(this.mobilePhone, identitySourceUserProfileForUpsert.mobilePhone)
                && Objects.equals(this.secondEmail, identitySourceUserProfileForUpsert.secondEmail)
                && Objects.equals(this.userName, identitySourceUserProfileForUpsert.userName);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(email, hashCodeNullable(firstName), hashCodeNullable(homeAddress),
                hashCodeNullable(lastName), hashCodeNullable(mobilePhone), secondEmail, userName);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentitySourceUserProfileForUpsert {\n");
        sb.append("    email: ").append(toIndentedString(email)).append("\n");
        sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
        sb.append("    homeAddress: ").append(toIndentedString(homeAddress)).append("\n");
        sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
        sb.append("    mobilePhone: ").append(toIndentedString(mobilePhone)).append("\n");
        sb.append("    secondEmail: ").append(toIndentedString(secondEmail)).append("\n");
        sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
