package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * JsonWebKey
 */
@JsonPropertyOrder({ JsonWebKey.JSON_PROPERTY_CREATED, JsonWebKey.JSON_PROPERTY_E, JsonWebKey.JSON_PROPERTY_EXPIRES_AT,
        JsonWebKey.JSON_PROPERTY_KID, JsonWebKey.JSON_PROPERTY_KTY, JsonWebKey.JSON_PROPERTY_LAST_UPDATED,
        JsonWebKey.JSON_PROPERTY_N, JsonWebKey.JSON_PROPERTY_USE, JsonWebKey.JSON_PROPERTY_X5C,
        JsonWebKey.JSON_PROPERTY_X5T_HASH_S256 })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class JsonWebKey implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_E = "e";
    private String e;

    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;

    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;

    public static final String JSON_PROPERTY_KTY = "kty";
    private String kty;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_N = "n";
    private String n;

    public static final String JSON_PROPERTY_USE = "use";
    private String use;

    public static final String JSON_PROPERTY_X5C = "x5c";
    private List<String> x5c = null;

    public static final String JSON_PROPERTY_X5T_HASH_S256 = "x5t#S256";
    private String x5tHashS256;

    public JsonWebKey() {
    }

    /*
     * @JsonCreator public JsonWebKey(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_E) String e,
     *
     * @JsonProperty(JSON_PROPERTY_EXPIRES_AT) OffsetDateTime expiresAt,
     *
     * @JsonProperty(JSON_PROPERTY_KID) String kid,
     *
     * @JsonProperty(JSON_PROPERTY_KTY) String kty,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_USE) String use,
     *
     * @JsonProperty(JSON_PROPERTY_X5C) List<String> x5c,
     *
     * @JsonProperty(JSON_PROPERTY_X5T_HASH_S256) String x5tHashS256 ) { this(); this.created = created; this.e = e;
     * this.expiresAt = expiresAt; this.kid = kid; this.kty = kty; this.lastUpdated = lastUpdated; this.use = use;
     * this.x5c = x5c; this.x5tHashS256 = x5tHashS256; }
     */

    /**
     * Timestamp when the object was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2017-03-28T01:11:10Z", value = "Timestamp when the object was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * RSA key value (public exponent) for Key binding
     *
     * @return e
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "RSA key value (public exponent) for Key binding")
    @JsonProperty(JSON_PROPERTY_E)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getE() {
        return e;
    }

    /**
     * Timestamp when the certificate expires
     *
     * @return expiresAt
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the certificate expires")
    @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getExpiresAt() {
        return expiresAt;
    }

    /**
     * Unique identifier for the certificate
     *
     * @return kid
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique identifier for the certificate")
    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKid() {
        return kid;
    }

    /**
     * Cryptographic algorithm family for the certificate&#39;s keypair. Valid value: &#x60;RSA&#x60;
     *
     * @return kty
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Cryptographic algorithm family for the certificate's keypair. Valid value: `RSA`")
    @JsonProperty(JSON_PROPERTY_KTY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKty() {
        return kty;
    }

    /**
     * Timestamp when the object was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the object was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public JsonWebKey n(String n) {

        this.n = n;
        return this;
    }

    /**
     * RSA modulus value that is used by both the public and private keys and provides a link between them
     *
     * @return n
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "RSA modulus value that is used by both the public and private keys and provides a link between them")
    @JsonProperty(JSON_PROPERTY_N)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getN() {
        return n;
    }

    @JsonProperty(JSON_PROPERTY_N)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setN(String n) {
        this.n = n;
    }

    /**
     * Acceptable use of the certificate. Valid value: &#x60;sig&#x60;
     *
     * @return use
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Acceptable use of the certificate. Valid value: `sig`")
    @JsonProperty(JSON_PROPERTY_USE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUse() {
        return use;
    }

    /**
     * X.509 certificate chain that contains a chain of one or more certificates
     *
     * @return x5c
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "X.509 certificate chain that contains a chain of one or more certificates")
    @JsonProperty(JSON_PROPERTY_X5C)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getX5c() {
        return x5c;
    }

    /**
     * X.509 certificate SHA-256 thumbprint, which is the base64url-encoded SHA-256 thumbprint (digest) of the DER
     * encoding of an X.509 certificate
     *
     * @return x5tHashS256
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "X.509 certificate SHA-256 thumbprint, which is the base64url-encoded SHA-256 thumbprint (digest) of the DER encoding of an X.509 certificate")
    @JsonProperty(JSON_PROPERTY_X5T_HASH_S256)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getX5tHashS256() {
        return x5tHashS256;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JsonWebKey jsonWebKey = (JsonWebKey) o;
        return Objects.equals(this.created, jsonWebKey.created) && Objects.equals(this.e, jsonWebKey.e)
                && Objects.equals(this.expiresAt, jsonWebKey.expiresAt) && Objects.equals(this.kid, jsonWebKey.kid)
                && Objects.equals(this.kty, jsonWebKey.kty) && Objects.equals(this.lastUpdated, jsonWebKey.lastUpdated)
                && Objects.equals(this.n, jsonWebKey.n) && Objects.equals(this.use, jsonWebKey.use)
                && Objects.equals(this.x5c, jsonWebKey.x5c) && Objects.equals(this.x5tHashS256, jsonWebKey.x5tHashS256);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, e, expiresAt, kid, kty, lastUpdated, n, use, x5c, x5tHashS256);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JsonWebKey {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    e: ").append(toIndentedString(e)).append("\n");
        sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
        sb.append("    kid: ").append(toIndentedString(kid)).append("\n");
        sb.append("    kty: ").append(toIndentedString(kty)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    n: ").append(toIndentedString(n)).append("\n");
        sb.append("    use: ").append(toIndentedString(use)).append("\n");
        sb.append("    x5c: ").append(toIndentedString(x5c)).append("\n");
        sb.append("    x5tHashS256: ").append(toIndentedString(x5tHashS256)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
